/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.athena.model.ParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngineConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngineConfiguration> {
    private static final SdkField<Integer> COORDINATOR_DPU_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoordinatorDpuSize").getter(EngineConfiguration.getter(EngineConfiguration::coordinatorDpuSize)).setter(EngineConfiguration.setter(Builder::coordinatorDpuSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoordinatorDpuSize").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_DPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentDpus").getter(EngineConfiguration.getter(EngineConfiguration::maxConcurrentDpus)).setter(EngineConfiguration.setter(Builder::maxConcurrentDpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentDpus").build()}).build();
    private static final SdkField<Integer> DEFAULT_EXECUTOR_DPU_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultExecutorDpuSize").getter(EngineConfiguration.getter(EngineConfiguration::defaultExecutorDpuSize)).setter(EngineConfiguration.setter(Builder::defaultExecutorDpuSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExecutorDpuSize").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalConfigs").getter(EngineConfiguration.getter(EngineConfiguration::additionalConfigs)).setter(EngineConfiguration.setter(Builder::additionalConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalConfigs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SparkProperties").getter(EngineConfiguration.getter(EngineConfiguration::sparkProperties)).setter(EngineConfiguration.setter(Builder::sparkProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATOR_DPU_SIZE_FIELD, MAX_CONCURRENT_DPUS_FIELD, DEFAULT_EXECUTOR_DPU_SIZE_FIELD, ADDITIONAL_CONFIGS_FIELD, SPARK_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CoordinatorDpuSize", COORDINATOR_DPU_SIZE_FIELD);
            this.put("MaxConcurrentDpus", MAX_CONCURRENT_DPUS_FIELD);
            this.put("DefaultExecutorDpuSize", DEFAULT_EXECUTOR_DPU_SIZE_FIELD);
            this.put("AdditionalConfigs", ADDITIONAL_CONFIGS_FIELD);
            this.put("SparkProperties", SPARK_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer coordinatorDpuSize;
    private final Integer maxConcurrentDpus;
    private final Integer defaultExecutorDpuSize;
    private final Map<String, String> additionalConfigs;
    private final Map<String, String> sparkProperties;

    private EngineConfiguration(BuilderImpl builder) {
        this.coordinatorDpuSize = builder.coordinatorDpuSize;
        this.maxConcurrentDpus = builder.maxConcurrentDpus;
        this.defaultExecutorDpuSize = builder.defaultExecutorDpuSize;
        this.additionalConfigs = builder.additionalConfigs;
        this.sparkProperties = builder.sparkProperties;
    }

    public final Integer coordinatorDpuSize() {
        return this.coordinatorDpuSize;
    }

    public final Integer maxConcurrentDpus() {
        return this.maxConcurrentDpus;
    }

    public final Integer defaultExecutorDpuSize() {
        return this.defaultExecutorDpuSize;
    }

    public final boolean hasAdditionalConfigs() {
        return this.additionalConfigs != null && !(this.additionalConfigs instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalConfigs() {
        return this.additionalConfigs;
    }

    public final boolean hasSparkProperties() {
        return this.sparkProperties != null && !(this.sparkProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sparkProperties() {
        return this.sparkProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinatorDpuSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExecutorDpuSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConfigs() ? this.additionalConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSparkProperties() ? this.sparkProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineConfiguration)) {
            return false;
        }
        EngineConfiguration other = (EngineConfiguration)obj;
        return Objects.equals(this.coordinatorDpuSize(), other.coordinatorDpuSize()) && Objects.equals(this.maxConcurrentDpus(), other.maxConcurrentDpus()) && Objects.equals(this.defaultExecutorDpuSize(), other.defaultExecutorDpuSize()) && this.hasAdditionalConfigs() == other.hasAdditionalConfigs() && Objects.equals(this.additionalConfigs(), other.additionalConfigs()) && this.hasSparkProperties() == other.hasSparkProperties() && Objects.equals(this.sparkProperties(), other.sparkProperties());
    }

    public final String toString() {
        return ToString.builder((String)"EngineConfiguration").add("CoordinatorDpuSize", (Object)this.coordinatorDpuSize()).add("MaxConcurrentDpus", (Object)this.maxConcurrentDpus()).add("DefaultExecutorDpuSize", (Object)this.defaultExecutorDpuSize()).add("AdditionalConfigs", this.hasAdditionalConfigs() ? this.additionalConfigs() : null).add("SparkProperties", this.hasSparkProperties() ? this.sparkProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoordinatorDpuSize": {
                return Optional.ofNullable(clazz.cast(this.coordinatorDpuSize()));
            }
            case "MaxConcurrentDpus": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentDpus()));
            }
            case "DefaultExecutorDpuSize": {
                return Optional.ofNullable(clazz.cast(this.defaultExecutorDpuSize()));
            }
            case "AdditionalConfigs": {
                return Optional.ofNullable(clazz.cast(this.additionalConfigs()));
            }
            case "SparkProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EngineConfiguration, T> g) {
        return obj -> g.apply((EngineConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer coordinatorDpuSize;
        private Integer maxConcurrentDpus;
        private Integer defaultExecutorDpuSize;
        private Map<String, String> additionalConfigs = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineConfiguration model) {
            this.coordinatorDpuSize(model.coordinatorDpuSize);
            this.maxConcurrentDpus(model.maxConcurrentDpus);
            this.defaultExecutorDpuSize(model.defaultExecutorDpuSize);
            this.additionalConfigs(model.additionalConfigs);
            this.sparkProperties(model.sparkProperties);
        }

        public final Integer getCoordinatorDpuSize() {
            return this.coordinatorDpuSize;
        }

        public final void setCoordinatorDpuSize(Integer coordinatorDpuSize) {
            this.coordinatorDpuSize = coordinatorDpuSize;
        }

        @Override
        public final Builder coordinatorDpuSize(Integer coordinatorDpuSize) {
            this.coordinatorDpuSize = coordinatorDpuSize;
            return this;
        }

        public final Integer getMaxConcurrentDpus() {
            return this.maxConcurrentDpus;
        }

        public final void setMaxConcurrentDpus(Integer maxConcurrentDpus) {
            this.maxConcurrentDpus = maxConcurrentDpus;
        }

        @Override
        public final Builder maxConcurrentDpus(Integer maxConcurrentDpus) {
            this.maxConcurrentDpus = maxConcurrentDpus;
            return this;
        }

        public final Integer getDefaultExecutorDpuSize() {
            return this.defaultExecutorDpuSize;
        }

        public final void setDefaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
            this.defaultExecutorDpuSize = defaultExecutorDpuSize;
        }

        @Override
        public final Builder defaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
            this.defaultExecutorDpuSize = defaultExecutorDpuSize;
            return this;
        }

        public final Map<String, String> getAdditionalConfigs() {
            if (this.additionalConfigs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalConfigs;
        }

        public final void setAdditionalConfigs(Map<String, String> additionalConfigs) {
            this.additionalConfigs = ParametersMapCopier.copy(additionalConfigs);
        }

        @Override
        public final Builder additionalConfigs(Map<String, String> additionalConfigs) {
            this.additionalConfigs = ParametersMapCopier.copy(additionalConfigs);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (this.sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = ParametersMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = ParametersMapCopier.copy(sparkProperties);
            return this;
        }

        public EngineConfiguration build() {
            return new EngineConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngineConfiguration> {
        public Builder coordinatorDpuSize(Integer var1);

        public Builder maxConcurrentDpus(Integer var1);

        public Builder defaultExecutorDpuSize(Integer var1);

        public Builder additionalConfigs(Map<String, String> var1);

        public Builder sparkProperties(Map<String, String> var1);
    }
}

