/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityReservationResponse extends AthenaResponse implements
        ToCopyableBuilder<GetCapacityReservationResponse.Builder, GetCapacityReservationResponse> {
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO).memberName("CapacityReservation")
            .getter(getter(GetCapacityReservationResponse::capacityReservation)).setter(setter(Builder::capacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CapacityReservation capacityReservation;

    private GetCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservation = builder.capacityReservation;
    }

    /**
     * <p>
     * The requested capacity reservation structure.
     * </p>
     * 
     * @return The requested capacity reservation structure.
     */
    public final CapacityReservation capacityReservation() {
        return capacityReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityReservationResponse)) {
            return false;
        }
        GetCapacityReservationResponse other = (GetCapacityReservationResponse) obj;
        return Objects.equals(capacityReservation(), other.capacityReservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityReservationResponse").add("CapacityReservation", capacityReservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservation":
            return Optional.ofNullable(clazz.cast(capacityReservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityReservationResponse, T> g) {
        return obj -> g.apply((GetCapacityReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCapacityReservationResponse> {
        /**
         * <p>
         * The requested capacity reservation structure.
         * </p>
         * 
         * @param capacityReservation
         *        The requested capacity reservation structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservation(CapacityReservation capacityReservation);

        /**
         * <p>
         * The requested capacity reservation structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityReservation(CapacityReservation)}.
         * 
         * @param capacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservation(CapacityReservation)
         */
        default Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return capacityReservation(CapacityReservation.builder().applyMutation(capacityReservation).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private CapacityReservation capacityReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityReservationResponse model) {
            super(model);
            capacityReservation(model.capacityReservation);
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return capacityReservation != null ? capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        @Override
        public GetCapacityReservationResponse build() {
            return new GetCapacityReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
