/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotebookMetadataResponse extends AthenaResponse implements
        ToCopyableBuilder<GetNotebookMetadataResponse.Builder, GetNotebookMetadataResponse> {
    private static final SdkField<NotebookMetadata> NOTEBOOK_METADATA_FIELD = SdkField
            .<NotebookMetadata> builder(MarshallingType.SDK_POJO).memberName("NotebookMetadata")
            .getter(getter(GetNotebookMetadataResponse::notebookMetadata)).setter(setter(Builder::notebookMetadata))
            .constructor(NotebookMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final NotebookMetadata notebookMetadata;

    private GetNotebookMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.notebookMetadata = builder.notebookMetadata;
    }

    /**
     * <p>
     * The metadata that is returned for the specified notebook ID.
     * </p>
     * 
     * @return The metadata that is returned for the specified notebook ID.
     */
    public final NotebookMetadata notebookMetadata() {
        return notebookMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotebookMetadataResponse)) {
            return false;
        }
        GetNotebookMetadataResponse other = (GetNotebookMetadataResponse) obj;
        return Objects.equals(notebookMetadata(), other.notebookMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotebookMetadataResponse").add("NotebookMetadata", notebookMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookMetadata":
            return Optional.ofNullable(clazz.cast(notebookMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotebookMetadata", NOTEBOOK_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotebookMetadataResponse, T> g) {
        return obj -> g.apply((GetNotebookMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNotebookMetadataResponse> {
        /**
         * <p>
         * The metadata that is returned for the specified notebook ID.
         * </p>
         * 
         * @param notebookMetadata
         *        The metadata that is returned for the specified notebook ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookMetadata(NotebookMetadata notebookMetadata);

        /**
         * <p>
         * The metadata that is returned for the specified notebook ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotebookMetadata.Builder} avoiding the
         * need to create one manually via {@link NotebookMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotebookMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #notebookMetadata(NotebookMetadata)}.
         * 
         * @param notebookMetadata
         *        a consumer that will call methods on {@link NotebookMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookMetadata(NotebookMetadata)
         */
        default Builder notebookMetadata(Consumer<NotebookMetadata.Builder> notebookMetadata) {
            return notebookMetadata(NotebookMetadata.builder().applyMutation(notebookMetadata).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private NotebookMetadata notebookMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotebookMetadataResponse model) {
            super(model);
            notebookMetadata(model.notebookMetadata);
        }

        public final NotebookMetadata.Builder getNotebookMetadata() {
            return notebookMetadata != null ? notebookMetadata.toBuilder() : null;
        }

        public final void setNotebookMetadata(NotebookMetadata.BuilderImpl notebookMetadata) {
            this.notebookMetadata = notebookMetadata != null ? notebookMetadata.build() : null;
        }

        @Override
        public final Builder notebookMetadata(NotebookMetadata notebookMetadata) {
            this.notebookMetadata = notebookMetadata;
            return this;
        }

        @Override
        public GetNotebookMetadataResponse build() {
            return new GetNotebookMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
