/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesPublisher;
import software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListCapacityReservationsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListDataCatalogsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListDatabasesPublisher;
import software.amazon.awssdk.services.athena.paginators.ListEngineVersionsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListExecutorsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher;
import software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListSessionsPublisher;
import software.amazon.awssdk.services.athena.paginators.ListTableMetadataPublisher;
import software.amazon.awssdk.services.athena.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.athena.paginators.ListWorkGroupsPublisher;

/**
 * Service client for accessing Amazon Athena asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Athena is an interactive query service that lets you use standard SQL to analyze data directly in Amazon S3.
 * You can point Athena at your data in Amazon S3 and run ad-hoc queries and get results in seconds. Athena is
 * serverless, so there is no infrastructure to set up or manage. You pay only for the queries you run. Athena scales
 * automatically—executing queries in parallel—so results are fast, even with large datasets and complex queries. For
 * more information, see <a href="http://docs.aws.amazon.com/athena/latest/ug/what-is.html">What is Amazon Athena</a> in
 * the <i>Amazon Athena User Guide</i>.
 * </p>
 * <p>
 * If you connect to Athena using the JDBC driver, use version 1.1.0 of the driver or later with the Amazon Athena API.
 * Earlier version drivers do not support the API. For more information and to download the driver, see <a
 * href="https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html">Accessing Amazon Athena with JDBC</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AthenaAsyncClient extends AwsClient {
    String SERVICE_NAME = "athena";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "athena";

    /**
     * <p>
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query
     * ID strings. Requires you to have access to the workgroup in which the queries were saved. Use
     * <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could
     * not be retrieved for a submitted query ID, information about the query ID submitted is listed under
     * <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use
     * <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and
     * <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.
     * </p>
     *
     * @param batchGetNamedQueryRequest
     *        Contains an array of named query IDs.
     * @return A Java Future containing the result of the BatchGetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetNamedQueryResponse> batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query
     * ID strings. Requires you to have access to the workgroup in which the queries were saved. Use
     * <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could
     * not be retrieved for a submitted query ID, information about the query ID submitted is listed under
     * <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use
     * <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and
     * <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetNamedQueryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetNamedQueryRequest#builder()}
     * </p>
     *
     * @param batchGetNamedQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest.Builder} to create a
     *        request. Contains an array of named query IDs.
     * @return A Java Future containing the result of the BatchGetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetNamedQueryResponse> batchGetNamedQuery(
            Consumer<BatchGetNamedQueryRequest.Builder> batchGetNamedQueryRequest) {
        return batchGetNamedQuery(BatchGetNamedQueryRequest.builder().applyMutation(batchGetNamedQueryRequest).build());
    }

    /**
     * <p>
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of
     * prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared
     * statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in
     * <code>UnprocessedPreparedStatementNames</code>.
     * </p>
     *
     * @param batchGetPreparedStatementRequest
     * @return A Java Future containing the result of the BatchGetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetPreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetPreparedStatementResponse> batchGetPreparedStatement(
            BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of
     * prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared
     * statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in
     * <code>UnprocessedPreparedStatementNames</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetPreparedStatementRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetPreparedStatementRequest#builder()}
     * </p>
     *
     * @param batchGetPreparedStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetPreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetPreparedStatementResponse> batchGetPreparedStatement(
            Consumer<BatchGetPreparedStatementRequest.Builder> batchGetPreparedStatementRequest) {
        return batchGetPreparedStatement(BatchGetPreparedStatementRequest.builder()
                .applyMutation(batchGetPreparedStatementRequest).build());
    }

    /**
     * <p>
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an
     * array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To
     * get a list of query execution IDs, use <a>ListQueryExecutionsInput&#36WorkGroup</a>. Query executions differ from
     * named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.
     * </p>
     *
     * @param batchGetQueryExecutionRequest
     *        Contains an array of query execution IDs.
     * @return A Java Future containing the result of the BatchGetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetQueryExecutionResponse> batchGetQueryExecution(
            BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an
     * array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To
     * get a list of query execution IDs, use <a>ListQueryExecutionsInput&#36WorkGroup</a>. Query executions differ from
     * named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetQueryExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetQueryExecutionRequest#builder()}
     * </p>
     *
     * @param batchGetQueryExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest.Builder} to create a
     *        request. Contains an array of query execution IDs.
     * @return A Java Future containing the result of the BatchGetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.BatchGetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetQueryExecutionResponse> batchGetQueryExecution(
            Consumer<BatchGetQueryExecutionRequest.Builder> batchGetQueryExecutionRequest) {
        return batchGetQueryExecution(BatchGetQueryExecutionRequest.builder().applyMutation(batchGetQueryExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will
     * be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has
     * been cancelled, but you can refer to its tags and view it for historical reference.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CancelCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will
     * be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has
     * been cancelled, but you can refer to its tags and view it for historical reference.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelCapacityReservationRequest#builder()}
     * </p>
     *
     * @param cancelCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CancelCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            Consumer<CancelCapacityReservationRequest.Builder> cancelCapacityReservationRequest) {
        return cancelCapacityReservation(CancelCapacityReservationRequest.builder()
                .applyMutation(cancelCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Creates a capacity reservation with the specified name and number of requested data processing units.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a capacity reservation with the specified name and number of requested data processing units.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCapacityReservationRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            Consumer<CreateCapacityReservationRequest.Builder> createCapacityReservationRequest) {
        return createCapacityReservation(CreateCapacityReservationRequest.builder()
                .applyMutation(createCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all
     * users of the same Amazon Web Services account.
     * </p>
     * <p>
     * This API operation creates the following resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CFN Stack Name with a maximum length of 128 characters and prefix
     * <code>athenafederatedcatalog-CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda Function Name with a maximum length of 64 characters and prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Glue Connection Name with a maximum length of 255 characters and a prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDataCatalogRequest
     * @return A Java Future containing the result of the CreateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataCatalogResponse> createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all
     * users of the same Amazon Web Services account.
     * </p>
     * <p>
     * This API operation creates the following resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CFN Stack Name with a maximum length of 128 characters and prefix
     * <code>athenafederatedcatalog-CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda Function Name with a maximum length of 64 characters and prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Glue Connection Name with a maximum length of 255 characters and a prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataCatalogRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataCatalogRequest#builder()}
     * </p>
     *
     * @param createDataCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataCatalogResponse> createDataCatalog(
            Consumer<CreateDataCatalogRequest.Builder> createDataCatalogRequest) {
        return createDataCatalog(CreateDataCatalogRequest.builder().applyMutation(createDataCatalogRequest).build());
    }

    /**
     * <p>
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     * </p>
     *
     * @param createNamedQueryRequest
     * @return A Java Future containing the result of the CreateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNamedQueryResponse> createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamedQueryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamedQueryRequest#builder()}
     * </p>
     *
     * @param createNamedQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNamedQueryResponse> createNamedQuery(
            Consumer<CreateNamedQueryRequest.Builder> createNamedQueryRequest) {
        return createNamedQuery(CreateNamedQueryRequest.builder().applyMutation(createNamedQueryRequest).build());
    }

    /**
     * <p>
     * Creates an empty <code>ipynb</code> file in the specified Apache Spark enabled workgroup. Throws an error if a
     * file in the workgroup with the same name already exists.
     * </p>
     *
     * @param createNotebookRequest
     * @return A Java Future containing the result of the CreateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNotebookResponse> createNotebook(CreateNotebookRequest createNotebookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty <code>ipynb</code> file in the specified Apache Spark enabled workgroup. Throws an error if a
     * file in the workgroup with the same name already exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotebookRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNotebookRequest#builder()}
     * </p>
     *
     * @param createNotebookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreateNotebookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateNotebookResponse> createNotebook(Consumer<CreateNotebookRequest.Builder> createNotebookRequest) {
        return createNotebook(CreateNotebookRequest.builder().applyMutation(createNotebookRequest).build());
    }

    /**
     * <p>
     * Creates a prepared statement for use with SQL queries in Athena.
     * </p>
     *
     * @param createPreparedStatementRequest
     * @return A Java Future containing the result of the CreatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePreparedStatementResponse> createPreparedStatement(
            CreatePreparedStatementRequest createPreparedStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a prepared statement for use with SQL queries in Athena.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePreparedStatementRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePreparedStatementRequest#builder()}
     * </p>
     *
     * @param createPreparedStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePreparedStatementResponse> createPreparedStatement(
            Consumer<CreatePreparedStatementRequest.Builder> createPreparedStatementRequest) {
        return createPreparedStatement(CreatePreparedStatementRequest.builder().applyMutation(createPreparedStatementRequest)
                .build());
    }

    /**
     * <p>
     * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access,
     * <code>CreatePresignedNotebookUrl</code> must be called every 10 minutes to refresh the authentication token. For
     * information about granting programmatic access, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access">Grant
     * programmatic access</a>.
     * </p>
     *
     * @param createPresignedNotebookUrlRequest
     * @return A Java Future containing the result of the CreatePresignedNotebookUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePresignedNotebookUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePresignedNotebookUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedNotebookUrlResponse> createPresignedNotebookUrl(
            CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access,
     * <code>CreatePresignedNotebookUrl</code> must be called every 10 minutes to refresh the authentication token. For
     * information about granting programmatic access, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access">Grant
     * programmatic access</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedNotebookUrlRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePresignedNotebookUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedNotebookUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePresignedNotebookUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreatePresignedNotebookUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePresignedNotebookUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedNotebookUrlResponse> createPresignedNotebookUrl(
            Consumer<CreatePresignedNotebookUrlRequest.Builder> createPresignedNotebookUrlRequest) {
        return createPresignedNotebookUrl(CreatePresignedNotebookUrlRequest.builder()
                .applyMutation(createPresignedNotebookUrlRequest).build());
    }

    /**
     * <p>
     * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena
     * SQL workgroup.
     * </p>
     *
     * @param createWorkGroupRequest
     * @return A Java Future containing the result of the CreateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkGroupResponse> createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena
     * SQL workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkGroupRequest#builder()}
     * </p>
     *
     * @param createWorkGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.CreateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkGroupResponse> createWorkGroup(
            Consumer<CreateWorkGroupRequest.Builder> createWorkGroupRequest) {
        return createWorkGroup(CreateWorkGroupRequest.builder().applyMutation(createWorkGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted
     * reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A
     * deleted reservation cannot be called by <code>GetCapacityReservation</code>, and deleted reservations do not
     * appear in the output of <code>ListCapacityReservations</code>.
     * </p>
     *
     * @param deleteCapacityReservationRequest
     * @return A Java Future containing the result of the DeleteCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCapacityReservationResponse> deleteCapacityReservation(
            DeleteCapacityReservationRequest deleteCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted
     * reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A
     * deleted reservation cannot be called by <code>GetCapacityReservation</code>, and deleted reservations do not
     * appear in the output of <code>ListCapacityReservations</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCapacityReservationRequest#builder()}
     * </p>
     *
     * @param deleteCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCapacityReservationResponse> deleteCapacityReservation(
            Consumer<DeleteCapacityReservationRequest.Builder> deleteCapacityReservationRequest) {
        return deleteCapacityReservation(DeleteCapacityReservationRequest.builder()
                .applyMutation(deleteCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Deletes a data catalog.
     * </p>
     *
     * @param deleteDataCatalogRequest
     * @return A Java Future containing the result of the DeleteDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataCatalogResponse> deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataCatalogRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataCatalogRequest#builder()}
     * </p>
     *
     * @param deleteDataCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataCatalogResponse> deleteDataCatalog(
            Consumer<DeleteDataCatalogRequest.Builder> deleteDataCatalogRequest) {
        return deleteDataCatalog(DeleteDataCatalogRequest.builder().applyMutation(deleteDataCatalogRequest).build());
    }

    /**
     * <p>
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     * </p>
     *
     * @param deleteNamedQueryRequest
     * @return A Java Future containing the result of the DeleteNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNamedQueryResponse> deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamedQueryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamedQueryRequest#builder()}
     * </p>
     *
     * @param deleteNamedQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNamedQueryResponse> deleteNamedQuery(
            Consumer<DeleteNamedQueryRequest.Builder> deleteNamedQueryRequest) {
        return deleteNamedQuery(DeleteNamedQueryRequest.builder().applyMutation(deleteNamedQueryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified notebook.
     * </p>
     *
     * @param deleteNotebookRequest
     * @return A Java Future containing the result of the DeleteNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNotebookResponse> deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notebook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotebookRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNotebookRequest#builder()}
     * </p>
     *
     * @param deleteNotebookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeleteNotebookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteNotebookResponse> deleteNotebook(Consumer<DeleteNotebookRequest.Builder> deleteNotebookRequest) {
        return deleteNotebook(DeleteNotebookRequest.builder().applyMutation(deleteNotebookRequest).build());
    }

    /**
     * <p>
     * Deletes the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param deletePreparedStatementRequest
     * @return A Java Future containing the result of the DeletePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeletePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeletePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePreparedStatementResponse> deletePreparedStatement(
            DeletePreparedStatementRequest deletePreparedStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the prepared statement with the specified name from the specified workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePreparedStatementRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePreparedStatementRequest#builder()}
     * </p>
     *
     * @param deletePreparedStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeletePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeletePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePreparedStatementResponse> deletePreparedStatement(
            Consumer<DeletePreparedStatementRequest.Builder> deletePreparedStatementRequest) {
        return deletePreparedStatement(DeletePreparedStatementRequest.builder().applyMutation(deletePreparedStatementRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     * </p>
     *
     * @param deleteWorkGroupRequest
     * @return A Java Future containing the result of the DeleteWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkGroupResponse> deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkGroupRequest#builder()}
     * </p>
     *
     * @param deleteWorkGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.DeleteWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkGroupResponse> deleteWorkGroup(
            Consumer<DeleteWorkGroupRequest.Builder> deleteWorkGroupRequest) {
        return deleteWorkGroup(DeleteWorkGroupRequest.builder().applyMutation(deleteWorkGroupRequest).build());
    }

    /**
     * <p>
     * Exports the specified notebook and its metadata.
     * </p>
     *
     * @param exportNotebookRequest
     * @return A Java Future containing the result of the ExportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ExportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ExportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportNotebookResponse> exportNotebook(ExportNotebookRequest exportNotebookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports the specified notebook and its metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportNotebookRequest.Builder} avoiding the need to
     * create one manually via {@link ExportNotebookRequest#builder()}
     * </p>
     *
     * @param exportNotebookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ExportNotebookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ExportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ExportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportNotebookResponse> exportNotebook(Consumer<ExportNotebookRequest.Builder> exportNotebookRequest) {
        return exportNotebook(ExportNotebookRequest.builder().applyMutation(exportNotebookRequest).build());
    }

    /**
     * <p>
     * Describes a previously submitted calculation execution.
     * </p>
     *
     * @param getCalculationExecutionRequest
     * @return A Java Future containing the result of the GetCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionResponse> getCalculationExecution(
            GetCalculationExecutionRequest getCalculationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a previously submitted calculation execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link GetCalculationExecutionRequest#builder()}
     * </p>
     *
     * @param getCalculationExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionResponse> getCalculationExecution(
            Consumer<GetCalculationExecutionRequest.Builder> getCalculationExecutionRequest) {
        return getCalculationExecution(GetCalculationExecutionRequest.builder().applyMutation(getCalculationExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the unencrypted code that was executed for the calculation.
     * </p>
     *
     * @param getCalculationExecutionCodeRequest
     * @return A Java Future containing the result of the GetCalculationExecutionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionCodeResponse> getCalculationExecutionCode(
            GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the unencrypted code that was executed for the calculation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculationExecutionCodeRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculationExecutionCodeRequest#builder()}
     * </p>
     *
     * @param getCalculationExecutionCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetCalculationExecutionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionCodeResponse> getCalculationExecutionCode(
            Consumer<GetCalculationExecutionCodeRequest.Builder> getCalculationExecutionCodeRequest) {
        return getCalculationExecutionCode(GetCalculationExecutionCodeRequest.builder()
                .applyMutation(getCalculationExecutionCodeRequest).build());
    }

    /**
     * <p>
     * Gets the status of a current calculation.
     * </p>
     *
     * @param getCalculationExecutionStatusRequest
     * @return A Java Future containing the result of the GetCalculationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionStatusResponse> getCalculationExecutionStatus(
            GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a current calculation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param getCalculationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCalculationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCalculationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCalculationExecutionStatusResponse> getCalculationExecutionStatus(
            Consumer<GetCalculationExecutionStatusRequest.Builder> getCalculationExecutionStatusRequest) {
        return getCalculationExecutionStatus(GetCalculationExecutionStatusRequest.builder()
                .applyMutation(getCalculationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Gets the capacity assignment configuration for a capacity reservation, if one exists.
     * </p>
     *
     * @param getCapacityAssignmentConfigurationRequest
     * @return A Java Future containing the result of the GetCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCapacityAssignmentConfigurationResponse> getCapacityAssignmentConfiguration(
            GetCapacityAssignmentConfigurationRequest getCapacityAssignmentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the capacity assignment configuration for a capacity reservation, if one exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCapacityAssignmentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetCapacityAssignmentConfigurationRequest#builder()}
     * </p>
     *
     * @param getCapacityAssignmentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCapacityAssignmentConfigurationResponse> getCapacityAssignmentConfiguration(
            Consumer<GetCapacityAssignmentConfigurationRequest.Builder> getCapacityAssignmentConfigurationRequest) {
        return getCapacityAssignmentConfiguration(GetCapacityAssignmentConfigurationRequest.builder()
                .applyMutation(getCapacityAssignmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about the capacity reservation with the specified name.
     * </p>
     *
     * @param getCapacityReservationRequest
     * @return A Java Future containing the result of the GetCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCapacityReservationResponse> getCapacityReservation(
            GetCapacityReservationRequest getCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the capacity reservation with the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCapacityReservationRequest.Builder} avoiding the
     * need to create one manually via {@link GetCapacityReservationRequest#builder()}
     * </p>
     *
     * @param getCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCapacityReservationResponse> getCapacityReservation(
            Consumer<GetCapacityReservationRequest.Builder> getCapacityReservationRequest) {
        return getCapacityReservation(GetCapacityReservationRequest.builder().applyMutation(getCapacityReservationRequest)
                .build());
    }

    /**
     * <p>
     * Returns the specified data catalog.
     * </p>
     *
     * @param getDataCatalogRequest
     * @return A Java Future containing the result of the GetDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataCatalogResponse> getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specified data catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataCatalogRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataCatalogRequest#builder()}
     * </p>
     *
     * @param getDataCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetDataCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataCatalogResponse> getDataCatalog(Consumer<GetDataCatalogRequest.Builder> getDataCatalogRequest) {
        return getDataCatalog(GetDataCatalogRequest.builder().applyMutation(getDataCatalogRequest).build());
    }

    /**
     * <p>
     * Returns a database object for the specified database and data catalog.
     * </p>
     *
     * @param getDatabaseRequest
     * @return A Java Future containing the result of the GetDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabaseResponse> getDatabase(GetDatabaseRequest getDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database object for the specified database and data catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabaseRequest#builder()}
     * </p>
     *
     * @param getDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabaseResponse> getDatabase(Consumer<GetDatabaseRequest.Builder> getDatabaseRequest) {
        return getDatabase(GetDatabaseRequest.builder().applyMutation(getDatabaseRequest).build());
    }

    /**
     * <p>
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was
     * saved.
     * </p>
     *
     * @param getNamedQueryRequest
     * @return A Java Future containing the result of the GetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNamedQueryResponse> getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was
     * saved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamedQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamedQueryRequest#builder()}
     * </p>
     *
     * @param getNamedQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetNamedQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNamedQueryResponse> getNamedQuery(Consumer<GetNamedQueryRequest.Builder> getNamedQueryRequest) {
        return getNamedQuery(GetNamedQueryRequest.builder().applyMutation(getNamedQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves notebook metadata for the specified notebook ID.
     * </p>
     *
     * @param getNotebookMetadataRequest
     * @return A Java Future containing the result of the GetNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNotebookMetadataResponse> getNotebookMetadata(
            GetNotebookMetadataRequest getNotebookMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves notebook metadata for the specified notebook ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotebookMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetNotebookMetadataRequest#builder()}
     * </p>
     *
     * @param getNotebookMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNotebookMetadataResponse> getNotebookMetadata(
            Consumer<GetNotebookMetadataRequest.Builder> getNotebookMetadataRequest) {
        return getNotebookMetadata(GetNotebookMetadataRequest.builder().applyMutation(getNotebookMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param getPreparedStatementRequest
     * @return A Java Future containing the result of the GetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetPreparedStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPreparedStatementResponse> getPreparedStatement(
            GetPreparedStatementRequest getPreparedStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPreparedStatementRequest.Builder} avoiding the
     * need to create one manually via {@link GetPreparedStatementRequest#builder()}
     * </p>
     *
     * @param getPreparedStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetPreparedStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPreparedStatementResponse> getPreparedStatement(
            Consumer<GetPreparedStatementRequest.Builder> getPreparedStatementRequest) {
        return getPreparedStatement(GetPreparedStatementRequest.builder().applyMutation(getPreparedStatementRequest).build());
    }

    /**
     * <p>
     * Returns information about a single execution of a query if you have access to the workgroup in which the query
     * ran. Each time a query executes, information about the query execution is saved with a unique ID.
     * </p>
     *
     * @param getQueryExecutionRequest
     * @return A Java Future containing the result of the GetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryExecutionResponse> getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a single execution of a query if you have access to the workgroup in which the query
     * ran. Each time a query executes, information about the query execution is saved with a unique ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryExecutionRequest#builder()}
     * </p>
     *
     * @param getQueryExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryExecutionResponse> getQueryExecution(
            Consumer<GetQueryExecutionRequest.Builder> getQueryExecutionRequest) {
        return getQueryExecution(GetQueryExecutionRequest.builder().applyMutation(getQueryExecutionRequest).build());
    }

    /**
     * <p>
     * Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query
     * results location in Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with query results, recent queries, and
     * output files</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns
     * results. Use <a>StartQueryExecution</a> to run a query.
     * </p>
     * <p>
     * To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also
     * must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.
     * </p>
     * <important>
     * <p>
     * IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are
     * able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is
     * denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are
     * denied.
     * </p>
     * </important>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query
     * results location in Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with query results, recent queries, and
     * output files</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns
     * results. Use <a>StartQueryExecution</a> to run a query.
     * </p>
     * <p>
     * To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also
     * must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.
     * </p>
     * <important>
     * <p>
     * IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are
     * able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is
     * denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are
     * denied.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetQueryResultsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(
            Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResults(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.athena.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.athena.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) {
        return new GetQueryResultsPublisher(this, getQueryResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.athena.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.athena.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetQueryResultsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResultsPaginator(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the
     * workgroup in which the query ran. Statistics from the <code>Timeline</code> section of the response object are
     * available as soon as <a>QueryExecutionStatus&#36State</a> is in a SUCCEEDED or FAILED state. The remaining
     * non-timeline statistics in the response (like stage-level input and output row count and data size) are updated
     * asynchronously and may not be available immediately after a query completes. The non-timeline statistics are also
     * not included when a query has row-level filters defined in Lake Formation.
     * </p>
     *
     * @param getQueryRuntimeStatisticsRequest
     * @return A Java Future containing the result of the GetQueryRuntimeStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryRuntimeStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryRuntimeStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryRuntimeStatisticsResponse> getQueryRuntimeStatistics(
            GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the
     * workgroup in which the query ran. Statistics from the <code>Timeline</code> section of the response object are
     * available as soon as <a>QueryExecutionStatus&#36State</a> is in a SUCCEEDED or FAILED state. The remaining
     * non-timeline statistics in the response (like stage-level input and output row count and data size) are updated
     * asynchronously and may not be available immediately after a query completes. The non-timeline statistics are also
     * not included when a query has row-level filters defined in Lake Formation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryRuntimeStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link GetQueryRuntimeStatisticsRequest#builder()}
     * </p>
     *
     * @param getQueryRuntimeStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQueryRuntimeStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetQueryRuntimeStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryRuntimeStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetQueryRuntimeStatisticsResponse> getQueryRuntimeStatistics(
            Consumer<GetQueryRuntimeStatisticsRequest.Builder> getQueryRuntimeStatisticsRequest) {
        return getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest.builder()
                .applyMutation(getQueryRuntimeStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets the full details of a previously created session, including the session status and configuration.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the full details of a previously created session, including the session status and configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Gets the current status of a session.
     * </p>
     *
     * @param getSessionStatusRequest
     * @return A Java Future containing the result of the GetSessionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSessionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSessionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionStatusResponse> getSessionStatus(GetSessionStatusRequest getSessionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current status of a session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetSessionStatusRequest#builder()}
     * </p>
     *
     * @param getSessionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetSessionStatusRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSessionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetSessionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSessionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionStatusResponse> getSessionStatus(
            Consumer<GetSessionStatusRequest.Builder> getSessionStatusRequest) {
        return getSessionStatus(GetSessionStatusRequest.builder().applyMutation(getSessionStatusRequest).build());
    }

    /**
     * <p>
     * Returns table metadata for the specified catalog, database, and table.
     * </p>
     *
     * @param getTableMetadataRequest
     * @return A Java Future containing the result of the GetTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableMetadataResponse> getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table metadata for the specified catalog, database, and table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableMetadataRequest#builder()}
     * </p>
     *
     * @param getTableMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetTableMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableMetadataResponse> getTableMetadata(
            Consumer<GetTableMetadataRequest.Builder> getTableMetadataRequest) {
        return getTableMetadata(GetTableMetadataRequest.builder().applyMutation(getTableMetadataRequest).build());
    }

    /**
     * <p>
     * Returns information about the workgroup with the specified name.
     * </p>
     *
     * @param getWorkGroupRequest
     * @return A Java Future containing the result of the GetWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkGroupResponse> getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the workgroup with the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkGroupRequest#builder()}
     * </p>
     *
     * @param getWorkGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.GetWorkGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.GetWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkGroupResponse> getWorkGroup(Consumer<GetWorkGroupRequest.Builder> getWorkGroupRequest) {
        return getWorkGroup(GetWorkGroupRequest.builder().applyMutation(getWorkGroupRequest).build());
    }

    /**
     * <p>
     * Imports a single <code>ipynb</code> file to a Spark enabled workgroup. To import the notebook, the request must
     * specify a value for either <code>Payload</code> or <code>NoteBookS3LocationUri</code>. If neither is specified or
     * both are specified, an <code>InvalidRequestException</code> occurs. The maximum file size that can be imported is
     * 10 megabytes. If an <code>ipynb</code> file with the same name already exists in the workgroup, throws an error.
     * </p>
     *
     * @param importNotebookRequest
     * @return A Java Future containing the result of the ImportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ImportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ImportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportNotebookResponse> importNotebook(ImportNotebookRequest importNotebookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a single <code>ipynb</code> file to a Spark enabled workgroup. To import the notebook, the request must
     * specify a value for either <code>Payload</code> or <code>NoteBookS3LocationUri</code>. If neither is specified or
     * both are specified, an <code>InvalidRequestException</code> occurs. The maximum file size that can be imported is
     * 10 megabytes. If an <code>ipynb</code> file with the same name already exists in the workgroup, throws an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportNotebookRequest.Builder} avoiding the need to
     * create one manually via {@link ImportNotebookRequest#builder()}
     * </p>
     *
     * @param importNotebookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ImportNotebookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ImportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ImportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportNotebookResponse> importNotebook(Consumer<ImportNotebookRequest.Builder> importNotebookRequest) {
        return importNotebook(ImportNotebookRequest.builder().applyMutation(importNotebookRequest).build());
    }

    /**
     * <p>
     * Returns the supported DPU sizes for the supported application runtimes (for example,
     * <code>Athena notebook version 1</code>).
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     * @return A Java Future containing the result of the ListApplicationDPUSizes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationDpuSizesResponse> listApplicationDPUSizes(
            ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the supported DPU sizes for the supported application runtimes (for example,
     * <code>Athena notebook version 1</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDpuSizesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationDpuSizesRequest#builder()}
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationDPUSizes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationDpuSizesResponse> listApplicationDPUSizes(
            Consumer<ListApplicationDpuSizesRequest.Builder> listApplicationDpuSizesRequest) {
        return listApplicationDPUSizes(ListApplicationDpuSizesRequest.builder().applyMutation(listApplicationDpuSizesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationDPUSizes(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesPublisher publisher = client.listApplicationDPUSizesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesPublisher publisher = client.listApplicationDPUSizesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDPUSizes(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDPUSizesPublisher listApplicationDPUSizesPaginator(
            ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) {
        return new ListApplicationDPUSizesPublisher(this, listApplicationDpuSizesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationDPUSizes(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesPublisher publisher = client.listApplicationDPUSizesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListApplicationDPUSizesPublisher publisher = client.listApplicationDPUSizesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationDPUSizes(software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationDpuSizesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationDpuSizesRequest#builder()}
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationDPUSizesPublisher listApplicationDPUSizesPaginator(
            Consumer<ListApplicationDpuSizesRequest.Builder> listApplicationDpuSizesRequest) {
        return listApplicationDPUSizesPaginator(ListApplicationDpuSizesRequest.builder()
                .applyMutation(listApplicationDpuSizesRequest).build());
    }

    /**
     * <p>
     * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed
     * first; older calculations are listed later.
     * </p>
     *
     * @param listCalculationExecutionsRequest
     * @return A Java Future containing the result of the ListCalculationExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCalculationExecutionsResponse> listCalculationExecutions(
            ListCalculationExecutionsRequest listCalculationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed
     * first; older calculations are listed later.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculationExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCalculationExecutionsRequest#builder()}
     * </p>
     *
     * @param listCalculationExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCalculationExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCalculationExecutionsResponse> listCalculationExecutions(
            Consumer<ListCalculationExecutionsRequest.Builder> listCalculationExecutionsRequest) {
        return listCalculationExecutions(ListCalculationExecutionsRequest.builder()
                .applyMutation(listCalculationExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCalculationExecutions(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsPublisher publisher = client.listCalculationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsPublisher publisher = client.listCalculationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCalculationExecutions(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCalculationExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculationExecutionsPublisher listCalculationExecutionsPaginator(
            ListCalculationExecutionsRequest listCalculationExecutionsRequest) {
        return new ListCalculationExecutionsPublisher(this, listCalculationExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCalculationExecutions(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsPublisher publisher = client.listCalculationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCalculationExecutionsPublisher publisher = client.listCalculationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCalculationExecutions(software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculationExecutionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCalculationExecutionsRequest#builder()}
     * </p>
     *
     * @param listCalculationExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculationExecutionsPublisher listCalculationExecutionsPaginator(
            Consumer<ListCalculationExecutionsRequest.Builder> listCalculationExecutionsRequest) {
        return listCalculationExecutionsPaginator(ListCalculationExecutionsRequest.builder()
                .applyMutation(listCalculationExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists the capacity reservations for the current account.
     * </p>
     *
     * @param listCapacityReservationsRequest
     * @return A Java Future containing the result of the ListCapacityReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCapacityReservationsResponse> listCapacityReservations(
            ListCapacityReservationsRequest listCapacityReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the capacity reservations for the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapacityReservationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCapacityReservationsRequest#builder()}
     * </p>
     *
     * @param listCapacityReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCapacityReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCapacityReservationsResponse> listCapacityReservations(
            Consumer<ListCapacityReservationsRequest.Builder> listCapacityReservationsRequest) {
        return listCapacityReservations(ListCapacityReservationsRequest.builder().applyMutation(listCapacityReservationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapacityReservations(software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCapacityReservationsPublisher publisher = client.listCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCapacityReservationsPublisher publisher = client.listCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapacityReservations(software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCapacityReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCapacityReservationsPublisher listCapacityReservationsPaginator(
            ListCapacityReservationsRequest listCapacityReservationsRequest) {
        return new ListCapacityReservationsPublisher(this, listCapacityReservationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapacityReservations(software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCapacityReservationsPublisher publisher = client.listCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListCapacityReservationsPublisher publisher = client.listCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapacityReservations(software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapacityReservationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCapacityReservationsRequest#builder()}
     * </p>
     *
     * @param listCapacityReservationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCapacityReservationsPublisher listCapacityReservationsPaginator(
            Consumer<ListCapacityReservationsRequest.Builder> listCapacityReservationsRequest) {
        return listCapacityReservationsPaginator(ListCapacityReservationsRequest.builder()
                .applyMutation(listCapacityReservationsRequest).build());
    }

    /**
     * <p>
     * Lists the data catalogs in the current Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the
     * <b>Data source name</b> column.
     * </p>
     * </note>
     *
     * @param listDataCatalogsRequest
     * @return A Java Future containing the result of the ListDataCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataCatalogsResponse> listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data catalogs in the current Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the
     * <b>Data source name</b> column.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataCatalogsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataCatalogsRequest#builder()}
     * </p>
     *
     * @param listDataCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataCatalogsResponse> listDataCatalogs(
            Consumer<ListDataCatalogsRequest.Builder> listDataCatalogsRequest) {
        return listDataCatalogs(ListDataCatalogsRequest.builder().applyMutation(listDataCatalogsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataCatalogs(software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDataCatalogsPublisher publisher = client.listDataCatalogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDataCatalogsPublisher publisher = client.listDataCatalogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataCatalogs(software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest)} operation.</b>
     * </p>
     *
     * @param listDataCatalogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataCatalogsPublisher listDataCatalogsPaginator(ListDataCatalogsRequest listDataCatalogsRequest) {
        return new ListDataCatalogsPublisher(this, listDataCatalogsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataCatalogs(software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDataCatalogsPublisher publisher = client.listDataCatalogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDataCatalogsPublisher publisher = client.listDataCatalogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataCatalogs(software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataCatalogsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataCatalogsRequest#builder()}
     * </p>
     *
     * @param listDataCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataCatalogsPublisher listDataCatalogsPaginator(Consumer<ListDataCatalogsRequest.Builder> listDataCatalogsRequest) {
        return listDataCatalogsPaginator(ListDataCatalogsRequest.builder().applyMutation(listDataCatalogsRequest).build());
    }

    /**
     * <p>
     * Lists the databases in the specified data catalog.
     * </p>
     *
     * @param listDatabasesRequest
     * @return A Java Future containing the result of the ListDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the databases in the specified data catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListDatabasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDatabasesResponse> listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) {
        return listDatabases(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDatabases(software.amazon.awssdk.services.athena.model.ListDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.athena.model.ListDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listDatabasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesPublisher listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) {
        return new ListDatabasesPublisher(this, listDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDatabases(software.amazon.awssdk.services.athena.model.ListDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.athena.model.ListDatabasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListDatabasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatabasesPublisher listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) {
        return listDatabasesPaginator(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return A Java Future containing the result of the ListEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEngineVersionsResponse> listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngineVersionsRequest#builder()}
     * </p>
     *
     * @param listEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEngineVersionsResponse> listEngineVersions(
            Consumer<ListEngineVersionsRequest.Builder> listEngineVersionsRequest) {
        return listEngineVersions(ListEngineVersionsRequest.builder().applyMutation(listEngineVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngineVersions(software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngineVersions(software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEngineVersionsPublisher listEngineVersionsPaginator(ListEngineVersionsRequest listEngineVersionsRequest) {
        return new ListEngineVersionsPublisher(this, listEngineVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngineVersions(software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngineVersions(software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngineVersionsRequest#builder()}
     * </p>
     *
     * @param listEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEngineVersionsPublisher listEngineVersionsPaginator(
            Consumer<ListEngineVersionsRequest.Builder> listEngineVersionsRequest) {
        return listEngineVersionsPaginator(ListEngineVersionsRequest.builder().applyMutation(listEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older
     * executors are listed later. The result can be optionally filtered by state.
     * </p>
     *
     * @param listExecutorsRequest
     * @return A Java Future containing the result of the ListExecutors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutorsResponse> listExecutors(ListExecutorsRequest listExecutorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older
     * executors are listed later. The result can be optionally filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutorsRequest#builder()}
     * </p>
     *
     * @param listExecutorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListExecutorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExecutors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutorsResponse> listExecutors(Consumer<ListExecutorsRequest.Builder> listExecutorsRequest) {
        return listExecutors(ListExecutorsRequest.builder().applyMutation(listExecutorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutors(software.amazon.awssdk.services.athena.model.ListExecutorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListExecutorsPublisher publisher = client.listExecutorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListExecutorsPublisher publisher = client.listExecutorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListExecutorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListExecutorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutors(software.amazon.awssdk.services.athena.model.ListExecutorsRequest)} operation.</b>
     * </p>
     *
     * @param listExecutorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutorsPublisher listExecutorsPaginator(ListExecutorsRequest listExecutorsRequest) {
        return new ListExecutorsPublisher(this, listExecutorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listExecutors(software.amazon.awssdk.services.athena.model.ListExecutorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListExecutorsPublisher publisher = client.listExecutorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListExecutorsPublisher publisher = client.listExecutorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListExecutorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListExecutorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutors(software.amazon.awssdk.services.athena.model.ListExecutorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutorsRequest#builder()}
     * </p>
     *
     * @param listExecutorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListExecutorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutorsPublisher listExecutorsPaginator(Consumer<ListExecutorsRequest.Builder> listExecutorsRequest) {
        return listExecutorsPaginator(ListExecutorsRequest.builder().applyMutation(listExecutorsRequest).build());
    }

    /**
     * <p>
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have
     * access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary
     * workgroup.
     * </p>
     *
     * @param listNamedQueriesRequest
     * @return A Java Future containing the result of the ListNamedQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNamedQueriesResponse> listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have
     * access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary
     * workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamedQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNamedQueriesRequest#builder()}
     * </p>
     *
     * @param listNamedQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNamedQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNamedQueriesResponse> listNamedQueries(
            Consumer<ListNamedQueriesRequest.Builder> listNamedQueriesRequest) {
        return listNamedQueries(ListNamedQueriesRequest.builder().applyMutation(listNamedQueriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have
     * access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary
     * workgroup.
     * </p>
     *
     * @return A Java Future containing the result of the ListNamedQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNamedQueriesResponse> listNamedQueries() {
        return listNamedQueries(ListNamedQueriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamedQueriesPublisher listNamedQueriesPaginator() {
        return listNamedQueriesPaginator(ListNamedQueriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listNamedQueriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamedQueriesPublisher listNamedQueriesPaginator(ListNamedQueriesRequest listNamedQueriesRequest) {
        return new ListNamedQueriesPublisher(this, listNamedQueriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListNamedQueriesPublisher publisher = client.listNamedQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamedQueries(software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamedQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListNamedQueriesRequest#builder()}
     * </p>
     *
     * @param listNamedQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamedQueriesPublisher listNamedQueriesPaginator(Consumer<ListNamedQueriesRequest.Builder> listNamedQueriesRequest) {
        return listNamedQueriesPaginator(ListNamedQueriesRequest.builder().applyMutation(listNamedQueriesRequest).build());
    }

    /**
     * <p>
     * Displays the notebook files for the specified workgroup in paginated format.
     * </p>
     *
     * @param listNotebookMetadataRequest
     * @return A Java Future containing the result of the ListNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotebookMetadataResponse> listNotebookMetadata(
            ListNotebookMetadataRequest listNotebookMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the notebook files for the specified workgroup in paginated format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookMetadataRequest#builder()}
     * </p>
     *
     * @param listNotebookMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotebookMetadataResponse> listNotebookMetadata(
            Consumer<ListNotebookMetadataRequest.Builder> listNotebookMetadataRequest) {
        return listNotebookMetadata(ListNotebookMetadataRequest.builder().applyMutation(listNotebookMetadataRequest).build());
    }

    /**
     * <p>
     * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like
     * <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code> or <code>BUSY</code>. Newer sessions are listed
     * first; older sessions are listed later.
     * </p>
     *
     * @param listNotebookSessionsRequest
     * @return A Java Future containing the result of the ListNotebookSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotebookSessionsResponse> listNotebookSessions(
            ListNotebookSessionsRequest listNotebookSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like
     * <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code> or <code>BUSY</code>. Newer sessions are listed
     * first; older sessions are listed later.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookSessionsRequest#builder()}
     * </p>
     *
     * @param listNotebookSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotebookSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListNotebookSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNotebookSessionsResponse> listNotebookSessions(
            Consumer<ListNotebookSessionsRequest.Builder> listNotebookSessionsRequest) {
        return listNotebookSessions(ListNotebookSessionsRequest.builder().applyMutation(listNotebookSessionsRequest).build());
    }

    /**
     * <p>
     * Lists the prepared statements in the specified workgroup.
     * </p>
     *
     * @param listPreparedStatementsRequest
     * @return A Java Future containing the result of the ListPreparedStatements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPreparedStatementsResponse> listPreparedStatements(
            ListPreparedStatementsRequest listPreparedStatementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the prepared statements in the specified workgroup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPreparedStatementsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPreparedStatementsRequest#builder()}
     * </p>
     *
     * @param listPreparedStatementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPreparedStatements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPreparedStatementsResponse> listPreparedStatements(
            Consumer<ListPreparedStatementsRequest.Builder> listPreparedStatementsRequest) {
        return listPreparedStatements(ListPreparedStatementsRequest.builder().applyMutation(listPreparedStatementsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPreparedStatements(software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsPublisher publisher = client.listPreparedStatementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsPublisher publisher = client.listPreparedStatementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPreparedStatements(software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPreparedStatementsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPreparedStatementsPublisher listPreparedStatementsPaginator(
            ListPreparedStatementsRequest listPreparedStatementsRequest) {
        return new ListPreparedStatementsPublisher(this, listPreparedStatementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPreparedStatements(software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsPublisher publisher = client.listPreparedStatementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListPreparedStatementsPublisher publisher = client.listPreparedStatementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPreparedStatements(software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPreparedStatementsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPreparedStatementsRequest#builder()}
     * </p>
     *
     * @param listPreparedStatementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPreparedStatementsPublisher listPreparedStatementsPaginator(
            Consumer<ListPreparedStatementsRequest.Builder> listPreparedStatementsRequest) {
        return listPreparedStatementsPaginator(ListPreparedStatementsRequest.builder()
                .applyMutation(listPreparedStatementsRequest).build());
    }

    /**
     * <p>
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query
     * history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary
     * workgroup. Requires you to have access to the workgroup in which the queries ran.
     * </p>
     *
     * @param listQueryExecutionsRequest
     * @return A Java Future containing the result of the ListQueryExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions(
            ListQueryExecutionsRequest listQueryExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query
     * history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary
     * workgroup. Requires you to have access to the workgroup in which the queries ran.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueryExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueryExecutionsRequest#builder()}
     * </p>
     *
     * @param listQueryExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQueryExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions(
            Consumer<ListQueryExecutionsRequest.Builder> listQueryExecutionsRequest) {
        return listQueryExecutions(ListQueryExecutionsRequest.builder().applyMutation(listQueryExecutionsRequest).build());
    }

    /**
     * <p>
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query
     * history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary
     * workgroup. Requires you to have access to the workgroup in which the queries ran.
     * </p>
     *
     * @return A Java Future containing the result of the ListQueryExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions() {
        return listQueryExecutions(ListQueryExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQueryExecutionsPublisher listQueryExecutionsPaginator() {
        return listQueryExecutionsPaginator(ListQueryExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueryExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQueryExecutionsPublisher listQueryExecutionsPaginator(ListQueryExecutionsRequest listQueryExecutionsRequest) {
        return new ListQueryExecutionsPublisher(this, listQueryExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListQueryExecutionsPublisher publisher = client.listQueryExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueryExecutions(software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueryExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueryExecutionsRequest#builder()}
     * </p>
     *
     * @param listQueryExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListQueryExecutionsPublisher listQueryExecutionsPaginator(
            Consumer<ListQueryExecutionsRequest.Builder> listQueryExecutionsRequest) {
        return listQueryExecutionsPaginator(ListQueryExecutionsRequest.builder().applyMutation(listQueryExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the sessions in a workgroup that are in an active state like <code>CREATING</code>, <code>CREATED</code>,
     * <code>IDLE</code>, or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sessions in a workgroup that are in an active state like <code>CREATING</code>, <code>CREATED</code>,
     * <code>IDLE</code>, or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.athena.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.athena.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(ListSessionsRequest listSessionsRequest) {
        return new ListSessionsPublisher(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSessions(software.amazon.awssdk.services.athena.model.ListSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.athena.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListSessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Lists the metadata for the tables in the specified data catalog database.
     * </p>
     *
     * @param listTableMetadataRequest
     * @return A Java Future containing the result of the ListTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableMetadataResponse> listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the metadata for the tables in the specified data catalog database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableMetadataRequest#builder()}
     * </p>
     *
     * @param listTableMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListTableMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTableMetadataResponse> listTableMetadata(
            Consumer<ListTableMetadataRequest.Builder> listTableMetadataRequest) {
        return listTableMetadata(ListTableMetadataRequest.builder().applyMutation(listTableMetadataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableMetadata(software.amazon.awssdk.services.athena.model.ListTableMetadataRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTableMetadataPublisher publisher = client.listTableMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTableMetadataPublisher publisher = client.listTableMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListTableMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListTableMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableMetadata(software.amazon.awssdk.services.athena.model.ListTableMetadataRequest)} operation.</b>
     * </p>
     *
     * @param listTableMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableMetadataPublisher listTableMetadataPaginator(ListTableMetadataRequest listTableMetadataRequest) {
        return new ListTableMetadataPublisher(this, listTableMetadataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableMetadata(software.amazon.awssdk.services.athena.model.ListTableMetadataRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTableMetadataPublisher publisher = client.listTableMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTableMetadataPublisher publisher = client.listTableMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListTableMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListTableMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableMetadata(software.amazon.awssdk.services.athena.model.ListTableMetadataRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableMetadataRequest#builder()}
     * </p>
     *
     * @param listTableMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListTableMetadataRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>MetadataException An exception that Athena received when it called a custom metastore. Occurs if the
     *         error is not caused by user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableMetadataPublisher listTableMetadataPaginator(
            Consumer<ListTableMetadataRequest.Builder> listTableMetadataRequest) {
        return listTableMetadataPaginator(ListTableMetadataRequest.builder().applyMutation(listTableMetadataRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with an Athena resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with an Athena resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists available workgroups for the account.
     * </p>
     *
     * @param listWorkGroupsRequest
     * @return A Java Future containing the result of the ListWorkGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkGroupsResponse> listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available workgroups for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkGroupsRequest#builder()}
     * </p>
     *
     * @param listWorkGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkGroupsResponse> listWorkGroups(Consumer<ListWorkGroupsRequest.Builder> listWorkGroupsRequest) {
        return listWorkGroups(ListWorkGroupsRequest.builder().applyMutation(listWorkGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkGroups(software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListWorkGroupsPublisher publisher = client.listWorkGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListWorkGroupsPublisher publisher = client.listWorkGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkGroups(software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkGroupsPublisher listWorkGroupsPaginator(ListWorkGroupsRequest listWorkGroupsRequest) {
        return new ListWorkGroupsPublisher(this, listWorkGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkGroups(software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListWorkGroupsPublisher publisher = client.listWorkGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.athena.paginators.ListWorkGroupsPublisher publisher = client.listWorkGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkGroups(software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkGroupsRequest#builder()}
     * </p>
     *
     * @param listWorkGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkGroupsPublisher listWorkGroupsPaginator(Consumer<ListWorkGroupsRequest.Builder> listWorkGroupsRequest) {
        return listWorkGroupsPaginator(ListWorkGroupsRequest.builder().applyMutation(listWorkGroupsRequest).build());
    }

    /**
     * <p>
     * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment
     * configuration already exists for the capacity reservation, replaces the existing capacity assignment
     * configuration.
     * </p>
     *
     * @param putCapacityAssignmentConfigurationRequest
     * @return A Java Future containing the result of the PutCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.PutCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/PutCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCapacityAssignmentConfigurationResponse> putCapacityAssignmentConfiguration(
            PutCapacityAssignmentConfigurationRequest putCapacityAssignmentConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment
     * configuration already exists for the capacity reservation, replaces the existing capacity assignment
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCapacityAssignmentConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutCapacityAssignmentConfigurationRequest#builder()}
     * </p>
     *
     * @param putCapacityAssignmentConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutCapacityAssignmentConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.PutCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/PutCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCapacityAssignmentConfigurationResponse> putCapacityAssignmentConfiguration(
            Consumer<PutCapacityAssignmentConfigurationRequest.Builder> putCapacityAssignmentConfigurationRequest) {
        return putCapacityAssignmentConfiguration(PutCapacityAssignmentConfigurationRequest.builder()
                .applyMutation(putCapacityAssignmentConfigurationRequest).build());
    }

    /**
     * <p>
     * Submits calculations for execution within a session. You can supply the code to run as an inline code block
     * within the request.
     * </p>
     * <note>
     * <p>
     * The request syntax requires the <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter or the
     * <a>CalculationConfiguration&#36CodeBlock</a> parameter, but not both. Because
     * <a>CalculationConfiguration&#36CodeBlock</a> is deprecated, use the
     * <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter instead.
     * </p>
     * </note>
     *
     * @param startCalculationExecutionRequest
     * @return A Java Future containing the result of the StartCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCalculationExecutionResponse> startCalculationExecution(
            StartCalculationExecutionRequest startCalculationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits calculations for execution within a session. You can supply the code to run as an inline code block
     * within the request.
     * </p>
     * <note>
     * <p>
     * The request syntax requires the <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter or the
     * <a>CalculationConfiguration&#36CodeBlock</a> parameter, but not both. Because
     * <a>CalculationConfiguration&#36CodeBlock</a> is deprecated, use the
     * <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCalculationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link StartCalculationExecutionRequest#builder()}
     * </p>
     *
     * @param startCalculationExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartCalculationExecutionResponse> startCalculationExecution(
            Consumer<StartCalculationExecutionRequest.Builder> startCalculationExecutionRequest) {
        return startCalculationExecution(StartCalculationExecutionRequest.builder()
                .applyMutation(startCalculationExecutionRequest).build());
    }

    /**
     * <p>
     * Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup
     * in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to
     * the catalog. For code samples using the Amazon Web Services SDK for Java, see <a
     * href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the
     * <i>Amazon Athena User Guide</i>.
     * </p>
     *
     * @param startQueryExecutionRequest
     * @return A Java Future containing the result of the StartQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartQueryExecutionResponse> startQueryExecution(
            StartQueryExecutionRequest startQueryExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup
     * in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to
     * the catalog. For code samples using the Amazon Web Services SDK for Java, see <a
     * href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the
     * <i>Amazon Athena User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartQueryExecutionRequest#builder()}
     * </p>
     *
     * @param startQueryExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartQueryExecutionResponse> startQueryExecution(
            Consumer<StartQueryExecutionRequest.Builder> startQueryExecutionRequest) {
        return startQueryExecution(StartQueryExecutionRequest.builder().applyMutation(startQueryExecutionRequest).build());
    }

    /**
     * <p>
     * Creates a session for running calculations within a workgroup. The session is ready when it reaches an
     * <code>IDLE</code> state.
     * </p>
     *
     * @param startSessionRequest
     * @return A Java Future containing the result of the StartSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SessionAlreadyExistsException The specified session already exists.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSessionResponse> startSession(StartSessionRequest startSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session for running calculations within a workgroup. The session is ready when it reaches an
     * <code>IDLE</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSessionRequest.Builder} avoiding the need to
     * create one manually via {@link StartSessionRequest#builder()}
     * </p>
     *
     * @param startSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.StartSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SessionAlreadyExistsException The specified session already exists.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartSessionResponse> startSession(Consumer<StartSessionRequest.Builder> startSessionRequest) {
        return startSession(StartSessionRequest.builder().applyMutation(startSessionRequest).build());
    }

    /**
     * <p>
     * Requests the cancellation of a calculation. A <code>StopCalculationExecution</code> call on a calculation that is
     * already in a terminal state (for example, <code>STOPPED</code>, <code>FAILED</code>, or <code>COMPLETED</code>)
     * succeeds but has no effect.
     * </p>
     * <note>
     * <p>
     * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged
     * for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider
     * terminating the session in which the calculation is running.
     * </p>
     * </note>
     *
     * @param stopCalculationExecutionRequest
     * @return A Java Future containing the result of the StopCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCalculationExecutionResponse> stopCalculationExecution(
            StopCalculationExecutionRequest stopCalculationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests the cancellation of a calculation. A <code>StopCalculationExecution</code> call on a calculation that is
     * already in a terminal state (for example, <code>STOPPED</code>, <code>FAILED</code>, or <code>COMPLETED</code>)
     * succeeds but has no effect.
     * </p>
     * <note>
     * <p>
     * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged
     * for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider
     * terminating the session in which the calculation is running.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCalculationExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link StopCalculationExecutionRequest#builder()}
     * </p>
     *
     * @param stopCalculationExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopCalculationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopCalculationExecutionResponse> stopCalculationExecution(
            Consumer<StopCalculationExecutionRequest.Builder> stopCalculationExecutionRequest) {
        return stopCalculationExecution(StopCalculationExecutionRequest.builder().applyMutation(stopCalculationExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     * </p>
     *
     * @param stopQueryExecutionRequest
     * @return A Java Future containing the result of the StopQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQueryExecutionResponse> stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQueryExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StopQueryExecutionRequest#builder()}
     * </p>
     *
     * @param stopQueryExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopQueryExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.StopQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQueryExecutionResponse> stopQueryExecution(
            Consumer<StopQueryExecutionRequest.Builder> stopQueryExecutionRequest) {
        return stopQueryExecution(StopQueryExecutionRequest.builder().applyMutation(stopQueryExecutionRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of
     * a key and an optional value, both of which you define. For example, you can use tags to categorize Athena
     * workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of
     * tag keys to make it easier to search and filter the resources in your account. For best practices, see <a
     * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging
     * Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256
     * UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters:
     * + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify
     * more than one tag, separate them by commas.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of
     * a key and an optional value, both of which you define. For example, you can use tags to categorize Athena
     * workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of
     * tag keys to make it easier to search and filter the resources in your account. For best practices, see <a
     * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging
     * Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256
     * UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters:
     * + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify
     * more than one tag, separate them by commas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Terminates an active session. A <code>TerminateSession</code> call on a session that is already inactive (for
     * example, in a <code>FAILED</code>, <code>TERMINATED</code> or <code>TERMINATING</code> state) succeeds but has no
     * effect. Calculations running in the session when <code>TerminateSession</code> is called are forcefully stopped,
     * but may display as <code>FAILED</code> instead of <code>STOPPED</code>.
     * </p>
     *
     * @param terminateSessionRequest
     * @return A Java Future containing the result of the TerminateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateSessionResponse> terminateSession(TerminateSessionRequest terminateSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates an active session. A <code>TerminateSession</code> call on a session that is already inactive (for
     * example, in a <code>FAILED</code>, <code>TERMINATED</code> or <code>TERMINATING</code> state) succeeds but has no
     * effect. Calculations running in the session when <code>TerminateSession</code> is called are forcefully stopped,
     * but may display as <code>FAILED</code> instead of <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateSessionRequest.Builder} avoiding the need
     * to create one manually via {@link TerminateSessionRequest#builder()}
     * </p>
     *
     * @param terminateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.TerminateSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TerminateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateSessionResponse> terminateSession(
            Consumer<TerminateSessionRequest.Builder> terminateSessionRequest) {
        return terminateSession(TerminateSessionRequest.builder().applyMutation(terminateSessionRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from an Athena resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from an Athena resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the number of requested data processing units for the capacity reservation with the specified name.
     * </p>
     *
     * @param updateCapacityReservationRequest
     * @return A Java Future containing the result of the UpdateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCapacityReservationResponse> updateCapacityReservation(
            UpdateCapacityReservationRequest updateCapacityReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the number of requested data processing units for the capacity reservation with the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCapacityReservationRequest#builder()}
     * </p>
     *
     * @param updateCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCapacityReservationResponse> updateCapacityReservation(
            Consumer<UpdateCapacityReservationRequest.Builder> updateCapacityReservationRequest) {
        return updateCapacityReservation(UpdateCapacityReservationRequest.builder()
                .applyMutation(updateCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Updates the data catalog that has the specified name.
     * </p>
     *
     * @param updateDataCatalogRequest
     * @return A Java Future containing the result of the UpdateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataCatalogResponse> updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data catalog that has the specified name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataCatalogRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataCatalogRequest#builder()}
     * </p>
     *
     * @param updateDataCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDataCatalogResponse> updateDataCatalog(
            Consumer<UpdateDataCatalogRequest.Builder> updateDataCatalogRequest) {
        return updateDataCatalog(UpdateDataCatalogRequest.builder().applyMutation(updateDataCatalogRequest).build());
    }

    /**
     * <p>
     * Updates a <a>NamedQuery</a> object. The database or workgroup cannot be updated.
     * </p>
     *
     * @param updateNamedQueryRequest
     * @return A Java Future containing the result of the UpdateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateNamedQueryResponse> updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <a>NamedQuery</a> object. The database or workgroup cannot be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNamedQueryRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateNamedQueryRequest#builder()}
     * </p>
     *
     * @param updateNamedQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateNamedQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateNamedQueryResponse> updateNamedQuery(
            Consumer<UpdateNamedQueryRequest.Builder> updateNamedQueryRequest) {
        return updateNamedQuery(UpdateNamedQueryRequest.builder().applyMutation(updateNamedQueryRequest).build());
    }

    /**
     * <p>
     * Updates the contents of a Spark notebook.
     * </p>
     *
     * @param updateNotebookRequest
     * @return A Java Future containing the result of the UpdateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateNotebookResponse> updateNotebook(UpdateNotebookRequest updateNotebookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the contents of a Spark notebook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotebookRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateNotebookRequest#builder()}
     * </p>
     *
     * @param updateNotebookRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateNotebookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateNotebook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateNotebookResponse> updateNotebook(Consumer<UpdateNotebookRequest.Builder> updateNotebookRequest) {
        return updateNotebook(UpdateNotebookRequest.builder().applyMutation(updateNotebookRequest).build());
    }

    /**
     * <p>
     * Updates the metadata for a notebook.
     * </p>
     *
     * @param updateNotebookMetadataRequest
     * @return A Java Future containing the result of the UpdateNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateNotebookMetadataResponse> updateNotebookMetadata(
            UpdateNotebookMetadataRequest updateNotebookMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata for a notebook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotebookMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNotebookMetadataRequest#builder()}
     * </p>
     *
     * @param updateNotebookMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNotebookMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>TooManyRequestsException Indicates that the request was throttled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateNotebookMetadataResponse> updateNotebookMetadata(
            Consumer<UpdateNotebookMetadataRequest.Builder> updateNotebookMetadataRequest) {
        return updateNotebookMetadata(UpdateNotebookMetadataRequest.builder().applyMutation(updateNotebookMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Updates a prepared statement.
     * </p>
     *
     * @param updatePreparedStatementRequest
     * @return A Java Future containing the result of the UpdatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreparedStatementResponse> updatePreparedStatement(
            UpdatePreparedStatementRequest updatePreparedStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a prepared statement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePreparedStatementRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePreparedStatementRequest#builder()}
     * </p>
     *
     * @param updatePreparedStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePreparedStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>ResourceNotFoundException A resource, such as a workgroup, was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreparedStatementResponse> updatePreparedStatement(
            Consumer<UpdatePreparedStatementRequest.Builder> updatePreparedStatementRequest) {
        return updatePreparedStatement(UpdatePreparedStatementRequest.builder().applyMutation(updatePreparedStatementRequest)
                .build());
    }

    /**
     * <p>
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only
     * <code>ConfigurationUpdates</code> can be specified.
     * </p>
     *
     * @param updateWorkGroupRequest
     * @return A Java Future containing the result of the UpdateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkGroupResponse> updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only
     * <code>ConfigurationUpdates</code> can be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkGroupRequest#builder()}
     * </p>
     *
     * @param updateWorkGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorkGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Indicates a platform issue, which may be due to a transient condition or
     *         outage.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a required parameter may be missing or out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AthenaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AthenaAsyncClient.UpdateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkGroupResponse> updateWorkGroup(
            Consumer<UpdateWorkGroupRequest.Builder> updateWorkGroupRequest) {
        return updateWorkGroup(UpdateWorkGroupRequest.builder().applyMutation(updateWorkGroupRequest).build());
    }

    @Override
    default AthenaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AthenaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AthenaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AthenaAsyncClient}.
     */
    static AthenaAsyncClientBuilder builder() {
        return new DefaultAthenaAsyncClientBuilder();
    }
}
