/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCalculationExecutionsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListCalculationExecutionsResponse.Builder, ListCalculationExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCalculationExecutionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CalculationSummary>> CALCULATIONS_FIELD = SdkField
            .<List<CalculationSummary>> builder(MarshallingType.LIST)
            .memberName("Calculations")
            .getter(getter(ListCalculationExecutionsResponse::calculations))
            .setter(setter(Builder::calculations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Calculations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CalculationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CalculationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CALCULATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CalculationSummary> calculations;

    private ListCalculationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.calculations = builder.calculations;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Calculations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalculations() {
        return calculations != null && !(calculations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculations} method.
     * </p>
     * 
     * @return A list of <a>CalculationSummary</a> objects.
     */
    public final List<CalculationSummary> calculations() {
        return calculations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculations() ? calculations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCalculationExecutionsResponse)) {
            return false;
        }
        ListCalculationExecutionsResponse other = (ListCalculationExecutionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCalculations() == other.hasCalculations()
                && Objects.equals(calculations(), other.calculations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCalculationExecutionsResponse").add("NextToken", nextToken())
                .add("Calculations", hasCalculations() ? calculations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Calculations":
            return Optional.ofNullable(clazz.cast(calculations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Calculations", CALCULATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCalculationExecutionsResponse, T> g) {
        return obj -> g.apply((ListCalculationExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCalculationExecutionsResponse> {
        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <a>CalculationSummary</a> objects.
         * </p>
         * 
         * @param calculations
         *        A list of <a>CalculationSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculations(Collection<CalculationSummary> calculations);

        /**
         * <p>
         * A list of <a>CalculationSummary</a> objects.
         * </p>
         * 
         * @param calculations
         *        A list of <a>CalculationSummary</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculations(CalculationSummary... calculations);

        /**
         * <p>
         * A list of <a>CalculationSummary</a> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.CalculationSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.athena.model.CalculationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.CalculationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #calculations(List<CalculationSummary>)}.
         * 
         * @param calculations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.CalculationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculations(java.util.Collection<CalculationSummary>)
         */
        Builder calculations(Consumer<CalculationSummary.Builder>... calculations);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CalculationSummary> calculations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCalculationExecutionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            calculations(model.calculations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CalculationSummary.Builder> getCalculations() {
            List<CalculationSummary.Builder> result = CalculationsListCopier.copyToBuilder(this.calculations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculations(Collection<CalculationSummary.BuilderImpl> calculations) {
            this.calculations = CalculationsListCopier.copyFromBuilder(calculations);
        }

        @Override
        public final Builder calculations(Collection<CalculationSummary> calculations) {
            this.calculations = CalculationsListCopier.copy(calculations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculations(CalculationSummary... calculations) {
            calculations(Arrays.asList(calculations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculations(Consumer<CalculationSummary.Builder>... calculations) {
            calculations(Stream.of(calculations).map(c -> CalculationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCalculationExecutionsResponse build() {
            return new ListCalculationExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
