/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains statistics for a session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionStatistics.Builder, SessionStatistics> {
    private static final SdkField<Long> DPU_EXECUTION_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DpuExecutionInMillis").getter(getter(SessionStatistics::dpuExecutionInMillis))
            .setter(setter(Builder::dpuExecutionInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpuExecutionInMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DPU_EXECUTION_IN_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long dpuExecutionInMillis;

    private SessionStatistics(BuilderImpl builder) {
        this.dpuExecutionInMillis = builder.dpuExecutionInMillis;
    }

    /**
     * <p>
     * The data processing unit execution time for a session in milliseconds.
     * </p>
     * 
     * @return The data processing unit execution time for a session in milliseconds.
     */
    public final Long dpuExecutionInMillis() {
        return dpuExecutionInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dpuExecutionInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionStatistics)) {
            return false;
        }
        SessionStatistics other = (SessionStatistics) obj;
        return Objects.equals(dpuExecutionInMillis(), other.dpuExecutionInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionStatistics").add("DpuExecutionInMillis", dpuExecutionInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DpuExecutionInMillis":
            return Optional.ofNullable(clazz.cast(dpuExecutionInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DpuExecutionInMillis", DPU_EXECUTION_IN_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionStatistics, T> g) {
        return obj -> g.apply((SessionStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionStatistics> {
        /**
         * <p>
         * The data processing unit execution time for a session in milliseconds.
         * </p>
         * 
         * @param dpuExecutionInMillis
         *        The data processing unit execution time for a session in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuExecutionInMillis(Long dpuExecutionInMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long dpuExecutionInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionStatistics model) {
            dpuExecutionInMillis(model.dpuExecutionInMillis);
        }

        public final Long getDpuExecutionInMillis() {
            return dpuExecutionInMillis;
        }

        public final void setDpuExecutionInMillis(Long dpuExecutionInMillis) {
            this.dpuExecutionInMillis = dpuExecutionInMillis;
        }

        @Override
        public final Builder dpuExecutionInMillis(Long dpuExecutionInMillis) {
            this.dpuExecutionInMillis = dpuExecutionInMillis;
            return this;
        }

        @Override
        public SessionStatistics build() {
            return new SessionStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
