/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportNotebookRequest extends AthenaRequest implements
        ToCopyableBuilder<ImportNotebookRequest.Builder, ImportNotebookRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(ImportNotebookRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImportNotebookRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Payload")
            .getter(getter(ImportNotebookRequest::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ImportNotebookRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NOTEBOOK_S3_LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookS3LocationUri").getter(getter(ImportNotebookRequest::notebookS3LocationUri))
            .setter(setter(Builder::notebookS3LocationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookS3LocationUri").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(ImportNotebookRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD, NAME_FIELD,
            PAYLOAD_FIELD, TYPE_FIELD, NOTEBOOK_S3_LOCATION_URI_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workGroup;

    private final String name;

    private final String payload;

    private final String type;

    private final String notebookS3LocationUri;

    private final String clientRequestToken;

    private ImportNotebookRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.name = builder.name;
        this.payload = builder.payload;
        this.type = builder.type;
        this.notebookS3LocationUri = builder.notebookS3LocationUri;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to import the notebook to.
     * </p>
     * 
     * @return The name of the Spark enabled workgroup to import the notebook to.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The name of the notebook to import.
     * </p>
     * 
     * @return The name of the notebook to import.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The notebook content to be imported. The payload must be in <code>ipynb</code> format.
     * </p>
     * 
     * @return The notebook content to be imported. The payload must be in <code>ipynb</code> format.
     */
    public final String payload() {
        return payload;
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotebookType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */
    public final NotebookType type() {
        return NotebookType.fromValue(type);
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotebookType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A URI that specifies the Amazon S3 location of a notebook file in <code>ipynb</code> format.
     * </p>
     * 
     * @return A URI that specifies the Amazon S3 location of a notebook file in <code>ipynb</code> format.
     */
    public final String notebookS3LocationUri() {
        return notebookS3LocationUri;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @return A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes
     *         only once).</p> <important>
     *         <p>
     *         This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
     *         Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK
     *         or the Amazon Web Services CLI, you must provide this token or the action will fail.
     *         </p>
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notebookS3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportNotebookRequest)) {
            return false;
        }
        ImportNotebookRequest other = (ImportNotebookRequest) obj;
        return Objects.equals(workGroup(), other.workGroup()) && Objects.equals(name(), other.name())
                && Objects.equals(payload(), other.payload()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(notebookS3LocationUri(), other.notebookS3LocationUri())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportNotebookRequest").add("WorkGroup", workGroup()).add("Name", name())
                .add("Payload", payload()).add("Type", typeAsString()).add("NotebookS3LocationUri", notebookS3LocationUri())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NotebookS3LocationUri":
            return Optional.ofNullable(clazz.cast(notebookS3LocationUri()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("NotebookS3LocationUri", NOTEBOOK_S3_LOCATION_URI_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportNotebookRequest, T> g) {
        return obj -> g.apply((ImportNotebookRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportNotebookRequest> {
        /**
         * <p>
         * The name of the Spark enabled workgroup to import the notebook to.
         * </p>
         * 
         * @param workGroup
         *        The name of the Spark enabled workgroup to import the notebook to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The name of the notebook to import.
         * </p>
         * 
         * @param name
         *        The name of the notebook to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The notebook content to be imported. The payload must be in <code>ipynb</code> format.
         * </p>
         * 
         * @param payload
         *        The notebook content to be imported. The payload must be in <code>ipynb</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(String payload);

        /**
         * <p>
         * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
         * </p>
         * 
         * @param type
         *        The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
         * @see NotebookType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookType
         */
        Builder type(String type);

        /**
         * <p>
         * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
         * </p>
         * 
         * @param type
         *        The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
         * @see NotebookType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookType
         */
        Builder type(NotebookType type);

        /**
         * <p>
         * A URI that specifies the Amazon S3 location of a notebook file in <code>ipynb</code> format.
         * </p>
         * 
         * @param notebookS3LocationUri
         *        A URI that specifies the Amazon S3 location of a notebook file in <code>ipynb</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookS3LocationUri(String notebookS3LocationUri);

        /**
         * <p>
         * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
         * once).
         * </p>
         * <important>
         * <p>
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
         * SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon
         * Web Services CLI, you must provide this token or the action will fail.
         * </p>
         * </important>
         * 
         * @param clientRequestToken
         *        A unique case-sensitive string used to ensure the request to import the notebook is idempotent
         *        (executes only once).</p> <important>
         *        <p>
         *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
         *        Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services
         *        SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String workGroup;

        private String name;

        private String payload;

        private String type;

        private String notebookS3LocationUri;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportNotebookRequest model) {
            super(model);
            workGroup(model.workGroup);
            name(model.name);
            payload(model.payload);
            type(model.type);
            notebookS3LocationUri(model.notebookS3LocationUri);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPayload() {
            return payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotebookType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNotebookS3LocationUri() {
            return notebookS3LocationUri;
        }

        public final void setNotebookS3LocationUri(String notebookS3LocationUri) {
            this.notebookS3LocationUri = notebookS3LocationUri;
        }

        @Override
        public final Builder notebookS3LocationUri(String notebookS3LocationUri) {
            this.notebookS3LocationUri = notebookS3LocationUri;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportNotebookRequest build() {
            return new ImportNotebookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
