/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the application runtime IDs and their supported DPU sizes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationDPUSizes implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationDPUSizes.Builder, ApplicationDPUSizes> {
    private static final SdkField<String> APPLICATION_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationRuntimeId").getter(getter(ApplicationDPUSizes::applicationRuntimeId))
            .setter(setter(Builder::applicationRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRuntimeId").build())
            .build();

    private static final SdkField<List<Integer>> SUPPORTED_DPU_SIZES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("SupportedDPUSizes")
            .getter(getter(ApplicationDPUSizes::supportedDPUSizes))
            .setter(setter(Builder::supportedDPUSizes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedDPUSizes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_RUNTIME_ID_FIELD,
            SUPPORTED_DPU_SIZES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationRuntimeId;

    private final List<Integer> supportedDPUSizes;

    private ApplicationDPUSizes(BuilderImpl builder) {
        this.applicationRuntimeId = builder.applicationRuntimeId;
        this.supportedDPUSizes = builder.supportedDPUSizes;
    }

    /**
     * <p>
     * The name of the supported application runtime (for example, <code>Athena notebook version 1</code>).
     * </p>
     * 
     * @return The name of the supported application runtime (for example, <code>Athena notebook version 1</code>).
     */
    public final String applicationRuntimeId() {
        return applicationRuntimeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDPUSizes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedDPUSizes() {
        return supportedDPUSizes != null && !(supportedDPUSizes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDPUSizes} method.
     * </p>
     * 
     * @return A list of the supported DPU sizes that the application runtime supports.
     */
    public final List<Integer> supportedDPUSizes() {
        return supportedDPUSizes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedDPUSizes() ? supportedDPUSizes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDPUSizes)) {
            return false;
        }
        ApplicationDPUSizes other = (ApplicationDPUSizes) obj;
        return Objects.equals(applicationRuntimeId(), other.applicationRuntimeId())
                && hasSupportedDPUSizes() == other.hasSupportedDPUSizes()
                && Objects.equals(supportedDPUSizes(), other.supportedDPUSizes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationDPUSizes").add("ApplicationRuntimeId", applicationRuntimeId())
                .add("SupportedDPUSizes", hasSupportedDPUSizes() ? supportedDPUSizes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationRuntimeId":
            return Optional.ofNullable(clazz.cast(applicationRuntimeId()));
        case "SupportedDPUSizes":
            return Optional.ofNullable(clazz.cast(supportedDPUSizes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationRuntimeId", APPLICATION_RUNTIME_ID_FIELD);
        map.put("SupportedDPUSizes", SUPPORTED_DPU_SIZES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDPUSizes, T> g) {
        return obj -> g.apply((ApplicationDPUSizes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationDPUSizes> {
        /**
         * <p>
         * The name of the supported application runtime (for example, <code>Athena notebook version 1</code>).
         * </p>
         * 
         * @param applicationRuntimeId
         *        The name of the supported application runtime (for example, <code>Athena notebook version 1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationRuntimeId(String applicationRuntimeId);

        /**
         * <p>
         * A list of the supported DPU sizes that the application runtime supports.
         * </p>
         * 
         * @param supportedDPUSizes
         *        A list of the supported DPU sizes that the application runtime supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDPUSizes(Collection<Integer> supportedDPUSizes);

        /**
         * <p>
         * A list of the supported DPU sizes that the application runtime supports.
         * </p>
         * 
         * @param supportedDPUSizes
         *        A list of the supported DPU sizes that the application runtime supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDPUSizes(Integer... supportedDPUSizes);
    }

    static final class BuilderImpl implements Builder {
        private String applicationRuntimeId;

        private List<Integer> supportedDPUSizes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDPUSizes model) {
            applicationRuntimeId(model.applicationRuntimeId);
            supportedDPUSizes(model.supportedDPUSizes);
        }

        public final String getApplicationRuntimeId() {
            return applicationRuntimeId;
        }

        public final void setApplicationRuntimeId(String applicationRuntimeId) {
            this.applicationRuntimeId = applicationRuntimeId;
        }

        @Override
        public final Builder applicationRuntimeId(String applicationRuntimeId) {
            this.applicationRuntimeId = applicationRuntimeId;
            return this;
        }

        public final Collection<Integer> getSupportedDPUSizes() {
            if (supportedDPUSizes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDPUSizes;
        }

        public final void setSupportedDPUSizes(Collection<Integer> supportedDPUSizes) {
            this.supportedDPUSizes = SupportedDPUSizeListCopier.copy(supportedDPUSizes);
        }

        @Override
        public final Builder supportedDPUSizes(Collection<Integer> supportedDPUSizes) {
            this.supportedDPUSizes = SupportedDPUSizeListCopier.copy(supportedDPUSizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDPUSizes(Integer... supportedDPUSizes) {
            supportedDPUSizes(Arrays.asList(supportedDPUSizes));
            return this;
        }

        @Override
        public ApplicationDPUSizes build() {
            return new ApplicationDPUSizes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
