/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reservation for a specified number of data processing units (DPUs). When a reservation is initially created, it has
 * no DPUs. Athena allocates DPUs until the allocated amount equals the requested amount.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservation implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservation.Builder, CapacityReservation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CapacityReservation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CapacityReservation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> TARGET_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetDpus").getter(getter(CapacityReservation::targetDpus)).setter(setter(Builder::targetDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDpus").build()).build();

    private static final SdkField<Integer> ALLOCATED_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedDpus").getter(getter(CapacityReservation::allocatedDpus))
            .setter(setter(Builder::allocatedDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedDpus").build()).build();

    private static final SdkField<CapacityAllocation> LAST_ALLOCATION_FIELD = SdkField
            .<CapacityAllocation> builder(MarshallingType.SDK_POJO).memberName("LastAllocation")
            .getter(getter(CapacityReservation::lastAllocation)).setter(setter(Builder::lastAllocation))
            .constructor(CapacityAllocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAllocation").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulAllocationTime")
            .getter(getter(CapacityReservation::lastSuccessfulAllocationTime))
            .setter(setter(Builder::lastSuccessfulAllocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulAllocationTime")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CapacityReservation::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            TARGET_DPUS_FIELD, ALLOCATED_DPUS_FIELD, LAST_ALLOCATION_FIELD, LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD,
            CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final Integer targetDpus;

    private final Integer allocatedDpus;

    private final CapacityAllocation lastAllocation;

    private final Instant lastSuccessfulAllocationTime;

    private final Instant creationTime;

    private CapacityReservation(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.targetDpus = builder.targetDpus;
        this.allocatedDpus = builder.allocatedDpus;
        this.lastAllocation = builder.lastAllocation;
        this.lastSuccessfulAllocationTime = builder.lastSuccessfulAllocationTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the capacity reservation.
     * </p>
     * 
     * @return The name of the capacity reservation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the capacity reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityReservationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the capacity reservation.
     * @see CapacityReservationStatus
     */
    public final CapacityReservationStatus status() {
        return CapacityReservationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the capacity reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CapacityReservationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the capacity reservation.
     * @see CapacityReservationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The number of data processing units requested.
     * </p>
     * 
     * @return The number of data processing units requested.
     */
    public final Integer targetDpus() {
        return targetDpus;
    }

    /**
     * <p>
     * The number of data processing units currently allocated.
     * </p>
     * 
     * @return The number of data processing units currently allocated.
     */
    public final Integer allocatedDpus() {
        return allocatedDpus;
    }

    /**
     * Returns the value of the LastAllocation property for this object.
     * 
     * @return The value of the LastAllocation property for this object.
     */
    public final CapacityAllocation lastAllocation() {
        return lastAllocation;
    }

    /**
     * <p>
     * The time of the most recent capacity allocation that succeeded.
     * </p>
     * 
     * @return The time of the most recent capacity allocation that succeeded.
     */
    public final Instant lastSuccessfulAllocationTime() {
        return lastSuccessfulAllocationTime;
    }

    /**
     * <p>
     * The time in UTC epoch millis when the capacity reservation was created.
     * </p>
     * 
     * @return The time in UTC epoch millis when the capacity reservation was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetDpus());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedDpus());
        hashCode = 31 * hashCode + Objects.hashCode(lastAllocation());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulAllocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservation)) {
            return false;
        }
        CapacityReservation other = (CapacityReservation) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetDpus(), other.targetDpus()) && Objects.equals(allocatedDpus(), other.allocatedDpus())
                && Objects.equals(lastAllocation(), other.lastAllocation())
                && Objects.equals(lastSuccessfulAllocationTime(), other.lastSuccessfulAllocationTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservation").add("Name", name()).add("Status", statusAsString())
                .add("TargetDpus", targetDpus()).add("AllocatedDpus", allocatedDpus()).add("LastAllocation", lastAllocation())
                .add("LastSuccessfulAllocationTime", lastSuccessfulAllocationTime()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetDpus":
            return Optional.ofNullable(clazz.cast(targetDpus()));
        case "AllocatedDpus":
            return Optional.ofNullable(clazz.cast(allocatedDpus()));
        case "LastAllocation":
            return Optional.ofNullable(clazz.cast(lastAllocation()));
        case "LastSuccessfulAllocationTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulAllocationTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetDpus", TARGET_DPUS_FIELD);
        map.put("AllocatedDpus", ALLOCATED_DPUS_FIELD);
        map.put("LastAllocation", LAST_ALLOCATION_FIELD);
        map.put("LastSuccessfulAllocationTime", LAST_SUCCESSFUL_ALLOCATION_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservation, T> g) {
        return obj -> g.apply((CapacityReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservation> {
        /**
         * <p>
         * The name of the capacity reservation.
         * </p>
         * 
         * @param name
         *        The name of the capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the capacity reservation.
         * </p>
         * 
         * @param status
         *        The status of the capacity reservation.
         * @see CapacityReservationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the capacity reservation.
         * </p>
         * 
         * @param status
         *        The status of the capacity reservation.
         * @see CapacityReservationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationStatus
         */
        Builder status(CapacityReservationStatus status);

        /**
         * <p>
         * The number of data processing units requested.
         * </p>
         * 
         * @param targetDpus
         *        The number of data processing units requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDpus(Integer targetDpus);

        /**
         * <p>
         * The number of data processing units currently allocated.
         * </p>
         * 
         * @param allocatedDpus
         *        The number of data processing units currently allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedDpus(Integer allocatedDpus);

        /**
         * Sets the value of the LastAllocation property for this object.
         *
         * @param lastAllocation
         *        The new value for the LastAllocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAllocation(CapacityAllocation lastAllocation);

        /**
         * Sets the value of the LastAllocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CapacityAllocation.Builder} avoiding the
         * need to create one manually via {@link CapacityAllocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityAllocation.Builder#build()} is called immediately and its
         * result is passed to {@link #lastAllocation(CapacityAllocation)}.
         * 
         * @param lastAllocation
         *        a consumer that will call methods on {@link CapacityAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastAllocation(CapacityAllocation)
         */
        default Builder lastAllocation(Consumer<CapacityAllocation.Builder> lastAllocation) {
            return lastAllocation(CapacityAllocation.builder().applyMutation(lastAllocation).build());
        }

        /**
         * <p>
         * The time of the most recent capacity allocation that succeeded.
         * </p>
         * 
         * @param lastSuccessfulAllocationTime
         *        The time of the most recent capacity allocation that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulAllocationTime(Instant lastSuccessfulAllocationTime);

        /**
         * <p>
         * The time in UTC epoch millis when the capacity reservation was created.
         * </p>
         * 
         * @param creationTime
         *        The time in UTC epoch millis when the capacity reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private Integer targetDpus;

        private Integer allocatedDpus;

        private CapacityAllocation lastAllocation;

        private Instant lastSuccessfulAllocationTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservation model) {
            name(model.name);
            status(model.status);
            targetDpus(model.targetDpus);
            allocatedDpus(model.allocatedDpus);
            lastAllocation(model.lastAllocation);
            lastSuccessfulAllocationTime(model.lastSuccessfulAllocationTime);
            creationTime(model.creationTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CapacityReservationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getTargetDpus() {
            return targetDpus;
        }

        public final void setTargetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
        }

        @Override
        public final Builder targetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
            return this;
        }

        public final Integer getAllocatedDpus() {
            return allocatedDpus;
        }

        public final void setAllocatedDpus(Integer allocatedDpus) {
            this.allocatedDpus = allocatedDpus;
        }

        @Override
        public final Builder allocatedDpus(Integer allocatedDpus) {
            this.allocatedDpus = allocatedDpus;
            return this;
        }

        public final CapacityAllocation.Builder getLastAllocation() {
            return lastAllocation != null ? lastAllocation.toBuilder() : null;
        }

        public final void setLastAllocation(CapacityAllocation.BuilderImpl lastAllocation) {
            this.lastAllocation = lastAllocation != null ? lastAllocation.build() : null;
        }

        @Override
        public final Builder lastAllocation(CapacityAllocation lastAllocation) {
            this.lastAllocation = lastAllocation;
            return this;
        }

        public final Instant getLastSuccessfulAllocationTime() {
            return lastSuccessfulAllocationTime;
        }

        public final void setLastSuccessfulAllocationTime(Instant lastSuccessfulAllocationTime) {
            this.lastSuccessfulAllocationTime = lastSuccessfulAllocationTime;
        }

        @Override
        public final Builder lastSuccessfulAllocationTime(Instant lastSuccessfulAllocationTime) {
            this.lastSuccessfulAllocationTime = lastSuccessfulAllocationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CapacityReservation build() {
            return new CapacityReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
