/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCalculationExecutionRequest extends AthenaRequest implements
        ToCopyableBuilder<StartCalculationExecutionRequest.Builder, StartCalculationExecutionRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(StartCalculationExecutionRequest::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartCalculationExecutionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CalculationConfiguration> CALCULATION_CONFIGURATION_FIELD = SdkField
            .<CalculationConfiguration> builder(MarshallingType.SDK_POJO).memberName("CalculationConfiguration")
            .getter(getter(StartCalculationExecutionRequest::calculationConfiguration))
            .setter(setter(Builder::calculationConfiguration)).constructor(CalculationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationConfiguration").build())
            .build();

    private static final SdkField<String> CODE_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeBlock").getter(getter(StartCalculationExecutionRequest::codeBlock))
            .setter(setter(Builder::codeBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBlock").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartCalculationExecutionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            DESCRIPTION_FIELD, CALCULATION_CONFIGURATION_FIELD, CODE_BLOCK_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String description;

    private final CalculationConfiguration calculationConfiguration;

    private final String codeBlock;

    private final String clientRequestToken;

    private StartCalculationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.calculationConfiguration = builder.calculationConfiguration;
        this.codeBlock = builder.codeBlock;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * A description of the calculation.
     * </p>
     * 
     * @return A description of the calculation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Contains configuration information for the calculation.
     * </p>
     * 
     * @return Contains configuration information for the calculation.
     * @deprecated Structure is deprecated.
     */
    @Deprecated
    public final CalculationConfiguration calculationConfiguration() {
        return calculationConfiguration;
    }

    /**
     * <p>
     * A string that contains the code of the calculation. Use this parameter instead of
     * <a>CalculationConfiguration$CodeBlock</a>, which is deprecated.
     * </p>
     * 
     * @return A string that contains the code of the calculation. Use this parameter instead of
     *         <a>CalculationConfiguration$CodeBlock</a>, which is deprecated.
     */
    public final String codeBlock() {
        return codeBlock;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to create the calculation is idempotent (executes only
     * once). If another <code>StartCalculationExecutionRequest</code> is received, the same response is returned and
     * another calculation is not created. If a parameter has changed, an error is returned.
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @return A unique case-sensitive string used to ensure the request to create the calculation is idempotent
     *         (executes only once). If another <code>StartCalculationExecutionRequest</code> is received, the same
     *         response is returned and another calculation is not created. If a parameter has changed, an error is
     *         returned.</p> <important>
     *         <p>
     *         This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
     *         Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services
     *         SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
     *         </p>
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(calculationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(codeBlock());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCalculationExecutionRequest)) {
            return false;
        }
        StartCalculationExecutionRequest other = (StartCalculationExecutionRequest) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(description(), other.description())
                && Objects.equals(calculationConfiguration(), other.calculationConfiguration())
                && Objects.equals(codeBlock(), other.codeBlock())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCalculationExecutionRequest").add("SessionId", sessionId())
                .add("Description", description()).add("CalculationConfiguration", calculationConfiguration())
                .add("CodeBlock", codeBlock()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CalculationConfiguration":
            return Optional.ofNullable(clazz.cast(calculationConfiguration()));
        case "CodeBlock":
            return Optional.ofNullable(clazz.cast(codeBlock()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CalculationConfiguration", CALCULATION_CONFIGURATION_FIELD);
        map.put("CodeBlock", CODE_BLOCK_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCalculationExecutionRequest, T> g) {
        return obj -> g.apply((StartCalculationExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCalculationExecutionRequest> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A description of the calculation.
         * </p>
         * 
         * @param description
         *        A description of the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains configuration information for the calculation.
         * </p>
         * 
         * @param calculationConfiguration
         *        Contains configuration information for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Structure is deprecated.
         */
        @Deprecated
        Builder calculationConfiguration(CalculationConfiguration calculationConfiguration);

        /**
         * <p>
         * Contains configuration information for the calculation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationConfiguration.Builder}
         * avoiding the need to create one manually via {@link CalculationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #calculationConfiguration(CalculationConfiguration)}.
         * 
         * @param calculationConfiguration
         *        a consumer that will call methods on {@link CalculationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculationConfiguration(CalculationConfiguration)
         * @deprecated Structure is deprecated.
         */
        @Deprecated
        default Builder calculationConfiguration(Consumer<CalculationConfiguration.Builder> calculationConfiguration) {
            return calculationConfiguration(CalculationConfiguration.builder().applyMutation(calculationConfiguration).build());
        }

        /**
         * <p>
         * A string that contains the code of the calculation. Use this parameter instead of
         * <a>CalculationConfiguration$CodeBlock</a>, which is deprecated.
         * </p>
         * 
         * @param codeBlock
         *        A string that contains the code of the calculation. Use this parameter instead of
         *        <a>CalculationConfiguration$CodeBlock</a>, which is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeBlock(String codeBlock);

        /**
         * <p>
         * A unique case-sensitive string used to ensure the request to create the calculation is idempotent (executes
         * only once). If another <code>StartCalculationExecutionRequest</code> is received, the same response is
         * returned and another calculation is not created. If a parameter has changed, an error is returned.
         * </p>
         * <important>
         * <p>
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
         * SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services SDK or the
         * Amazon Web Services CLI, you must provide this token or the action will fail.
         * </p>
         * </important>
         * 
         * @param clientRequestToken
         *        A unique case-sensitive string used to ensure the request to create the calculation is idempotent
         *        (executes only once). If another <code>StartCalculationExecutionRequest</code> is received, the same
         *        response is returned and another calculation is not created. If a parameter has changed, an error is
         *        returned.</p> <important>
         *        <p>
         *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
         *        Services SDK for Java) auto-generate the token for users. If you are not using the Amazon Web Services
         *        SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String sessionId;

        private String description;

        private CalculationConfiguration calculationConfiguration;

        private String codeBlock;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCalculationExecutionRequest model) {
            super(model);
            sessionId(model.sessionId);
            description(model.description);
            calculationConfiguration(model.calculationConfiguration);
            codeBlock(model.codeBlock);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final CalculationConfiguration.Builder getCalculationConfiguration() {
            return calculationConfiguration != null ? calculationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setCalculationConfiguration(CalculationConfiguration.BuilderImpl calculationConfiguration) {
            this.calculationConfiguration = calculationConfiguration != null ? calculationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder calculationConfiguration(CalculationConfiguration calculationConfiguration) {
            this.calculationConfiguration = calculationConfiguration;
            return this;
        }

        public final String getCodeBlock() {
            return codeBlock;
        }

        public final void setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
        }

        @Override
        public final Builder codeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCalculationExecutionRequest build() {
            return new StartCalculationExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
