/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaError;
import software.amazon.awssdk.services.athena.model.QueryExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryExecutionStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(QueryExecutionStatus.getter(QueryExecutionStatus::stateAsString)).setter(QueryExecutionStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateChangeReason").getter(QueryExecutionStatus.getter(QueryExecutionStatus::stateChangeReason)).setter(QueryExecutionStatus.setter(Builder::stateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<Instant> SUBMISSION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmissionDateTime").getter(QueryExecutionStatus.getter(QueryExecutionStatus::submissionDateTime)).setter(QueryExecutionStatus.setter(Builder::submissionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionDateTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDateTime").getter(QueryExecutionStatus.getter(QueryExecutionStatus::completionDateTime)).setter(QueryExecutionStatus.setter(Builder::completionDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDateTime").build()}).build();
    private static final SdkField<AthenaError> ATHENA_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AthenaError").getter(QueryExecutionStatus.getter(QueryExecutionStatus::athenaError)).setter(QueryExecutionStatus.setter(Builder::athenaError)).constructor(AthenaError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD, SUBMISSION_DATE_TIME_FIELD, COMPLETION_DATE_TIME_FIELD, ATHENA_ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryExecutionStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String stateChangeReason;
    private final Instant submissionDateTime;
    private final Instant completionDateTime;
    private final AthenaError athenaError;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
        this.athenaError = builder.athenaError;
    }

    public final QueryExecutionState state() {
        return QueryExecutionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateChangeReason() {
        return this.stateChangeReason;
    }

    public final Instant submissionDateTime() {
        return this.submissionDateTime;
    }

    public final Instant completionDateTime() {
        return this.completionDateTime;
    }

    public final AthenaError athenaError() {
        return this.athenaError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.submissionDateTime(), other.submissionDateTime()) && Objects.equals(this.completionDateTime(), other.completionDateTime()) && Objects.equals(this.athenaError(), other.athenaError());
    }

    public final String toString() {
        return ToString.builder((String)"QueryExecutionStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("SubmissionDateTime", (Object)this.submissionDateTime()).add("CompletionDateTime", (Object)this.completionDateTime()).add("AthenaError", (Object)this.athenaError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "SubmissionDateTime": {
                return Optional.ofNullable(clazz.cast(this.submissionDateTime()));
            }
            case "CompletionDateTime": {
                return Optional.ofNullable(clazz.cast(this.completionDateTime()));
            }
            case "AthenaError": {
                return Optional.ofNullable(clazz.cast(this.athenaError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("SubmissionDateTime", SUBMISSION_DATE_TIME_FIELD);
        map.put("CompletionDateTime", COMPLETION_DATE_TIME_FIELD);
        map.put("AthenaError", ATHENA_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatus, T> g) {
        return obj -> g.apply((QueryExecutionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateChangeReason;
        private Instant submissionDateTime;
        private Instant completionDateTime;
        private AthenaError athenaError;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.submissionDateTime(model.submissionDateTime);
            this.completionDateTime(model.completionDateTime);
            this.athenaError(model.athenaError);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateChangeReason() {
            return this.stateChangeReason;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final Instant getSubmissionDateTime() {
            return this.submissionDateTime;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final Instant getCompletionDateTime() {
            return this.completionDateTime;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final AthenaError.Builder getAthenaError() {
            return this.athenaError != null ? this.athenaError.toBuilder() : null;
        }

        public final void setAthenaError(AthenaError.BuilderImpl athenaError) {
            this.athenaError = athenaError != null ? athenaError.build() : null;
        }

        @Override
        public final Builder athenaError(AthenaError athenaError) {
            this.athenaError = athenaError;
            return this;
        }

        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryExecutionStatus> {
        public Builder state(String var1);

        public Builder state(QueryExecutionState var1);

        public Builder stateChangeReason(String var1);

        public Builder submissionDateTime(Instant var1);

        public Builder completionDateTime(Instant var1);

        public Builder athenaError(AthenaError var1);

        default public Builder athenaError(Consumer<AthenaError.Builder> athenaError) {
            return this.athenaError((AthenaError)((AthenaError.Builder)AthenaError.builder().applyMutation(athenaError)).build());
        }
    }
}

