/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a notebook calculation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculationSummary.Builder, CalculationSummary> {
    private static final SdkField<String> CALCULATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculationExecutionId").getter(getter(CalculationSummary::calculationExecutionId))
            .setter(setter(Builder::calculationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationExecutionId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CalculationSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CalculationStatus> STATUS_FIELD = SdkField
            .<CalculationStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(CalculationSummary::status)).setter(setter(Builder::status)).constructor(CalculationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CALCULATION_EXECUTION_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String calculationExecutionId;

    private final String description;

    private final CalculationStatus status;

    private CalculationSummary(BuilderImpl builder) {
        this.calculationExecutionId = builder.calculationExecutionId;
        this.description = builder.description;
        this.status = builder.status;
    }

    /**
     * <p>
     * The calculation execution UUID.
     * </p>
     * 
     * @return The calculation execution UUID.
     */
    public final String calculationExecutionId() {
        return calculationExecutionId;
    }

    /**
     * <p>
     * A description of the calculation.
     * </p>
     * 
     * @return A description of the calculation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Contains information about the status of the calculation.
     * </p>
     * 
     * @return Contains information about the status of the calculation.
     */
    public final CalculationStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(calculationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculationSummary)) {
            return false;
        }
        CalculationSummary other = (CalculationSummary) obj;
        return Objects.equals(calculationExecutionId(), other.calculationExecutionId())
                && Objects.equals(description(), other.description()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculationSummary").add("CalculationExecutionId", calculationExecutionId())
                .add("Description", description()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculationExecutionId":
            return Optional.ofNullable(clazz.cast(calculationExecutionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CalculationExecutionId", CALCULATION_EXECUTION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculationSummary, T> g) {
        return obj -> g.apply((CalculationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculationSummary> {
        /**
         * <p>
         * The calculation execution UUID.
         * </p>
         * 
         * @param calculationExecutionId
         *        The calculation execution UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculationExecutionId(String calculationExecutionId);

        /**
         * <p>
         * A description of the calculation.
         * </p>
         * 
         * @param description
         *        A description of the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains information about the status of the calculation.
         * </p>
         * 
         * @param status
         *        Contains information about the status of the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CalculationStatus status);

        /**
         * <p>
         * Contains information about the status of the calculation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculationStatus.Builder} avoiding the
         * need to create one manually via {@link CalculationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(CalculationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CalculationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CalculationStatus)
         */
        default Builder status(Consumer<CalculationStatus.Builder> status) {
            return status(CalculationStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String calculationExecutionId;

        private String description;

        private CalculationStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculationSummary model) {
            calculationExecutionId(model.calculationExecutionId);
            description(model.description);
            status(model.status);
        }

        public final String getCalculationExecutionId() {
            return calculationExecutionId;
        }

        public final void setCalculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
        }

        @Override
        public final Builder calculationExecutionId(String calculationExecutionId) {
            this.calculationExecutionId = calculationExecutionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CalculationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CalculationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CalculationStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CalculationSummary build() {
            return new CalculationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
