/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.NotebookSessionSummary;
import software.amazon.awssdk.services.athena.model.NotebookSessionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookSessionsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListNotebookSessionsResponse> {
    private static final SdkField<List<NotebookSessionSummary>> NOTEBOOK_SESSIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotebookSessionsList").getter(ListNotebookSessionsResponse.getter(ListNotebookSessionsResponse::notebookSessionsList)).setter(ListNotebookSessionsResponse.setter(Builder::notebookSessionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookSessionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotebookSessionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNotebookSessionsResponse.getter(ListNotebookSessionsResponse::nextToken)).setter(ListNotebookSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_SESSIONS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotebookSessionsResponse.memberNameToFieldInitializer();
    private final List<NotebookSessionSummary> notebookSessionsList;
    private final String nextToken;

    private ListNotebookSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.notebookSessionsList = builder.notebookSessionsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotebookSessionsList() {
        return this.notebookSessionsList != null && !(this.notebookSessionsList instanceof SdkAutoConstructList);
    }

    public final List<NotebookSessionSummary> notebookSessionsList() {
        return this.notebookSessionsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotebookSessionsList() ? this.notebookSessionsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookSessionsResponse)) {
            return false;
        }
        ListNotebookSessionsResponse other = (ListNotebookSessionsResponse)((Object)obj);
        return this.hasNotebookSessionsList() == other.hasNotebookSessionsList() && Objects.equals(this.notebookSessionsList(), other.notebookSessionsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotebookSessionsResponse").add("NotebookSessionsList", this.hasNotebookSessionsList() ? this.notebookSessionsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookSessionsList": {
                return Optional.ofNullable(clazz.cast(this.notebookSessionsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookSessionsList", NOTEBOOK_SESSIONS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookSessionsResponse, T> g) {
        return obj -> g.apply((ListNotebookSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<NotebookSessionSummary> notebookSessionsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookSessionsResponse model) {
            super(model);
            this.notebookSessionsList(model.notebookSessionsList);
            this.nextToken(model.nextToken);
        }

        public final List<NotebookSessionSummary.Builder> getNotebookSessionsList() {
            List<NotebookSessionSummary.Builder> result = NotebookSessionsListCopier.copyToBuilder(this.notebookSessionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookSessionsList(Collection<NotebookSessionSummary.BuilderImpl> notebookSessionsList) {
            this.notebookSessionsList = NotebookSessionsListCopier.copyFromBuilder(notebookSessionsList);
        }

        @Override
        public final Builder notebookSessionsList(Collection<NotebookSessionSummary> notebookSessionsList) {
            this.notebookSessionsList = NotebookSessionsListCopier.copy(notebookSessionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookSessionsList(NotebookSessionSummary ... notebookSessionsList) {
            this.notebookSessionsList(Arrays.asList(notebookSessionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookSessionsList(Consumer<NotebookSessionSummary.Builder> ... notebookSessionsList) {
            this.notebookSessionsList(Stream.of(notebookSessionsList).map(c -> (NotebookSessionSummary)((NotebookSessionSummary.Builder)NotebookSessionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotebookSessionsResponse build() {
            return new ListNotebookSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookSessionsResponse> {
        public Builder notebookSessionsList(Collection<NotebookSessionSummary> var1);

        public Builder notebookSessionsList(NotebookSessionSummary ... var1);

        public Builder notebookSessionsList(Consumer<NotebookSessionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

