/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryResultsResponse extends AthenaResponse implements
        ToCopyableBuilder<GetQueryResultsResponse.Builder, GetQueryResultsResponse> {
    private static final SdkField<Long> UPDATE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UpdateCount").getter(getter(GetQueryResultsResponse::updateCount)).setter(setter(Builder::updateCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateCount").build()).build();

    private static final SdkField<ResultSet> RESULT_SET_FIELD = SdkField.<ResultSet> builder(MarshallingType.SDK_POJO)
            .memberName("ResultSet").getter(getter(GetQueryResultsResponse::resultSet)).setter(setter(Builder::resultSet))
            .constructor(ResultSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSet").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetQueryResultsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_COUNT_FIELD,
            RESULT_SET_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long updateCount;

    private final ResultSet resultSet;

    private final String nextToken;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.updateCount = builder.updateCount;
        this.resultSet = builder.resultSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>, <code>INSERT INTO</code>, or
     * <code>UPDATE</code> statement.
     * </p>
     * 
     * @return The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>, <code>INSERT INTO</code>, or
     *         <code>UPDATE</code> statement.
     */
    public final Long updateCount() {
        return updateCount;
    }

    /**
     * <p>
     * The results of the query execution.
     * </p>
     * 
     * @return The results of the query execution.
     */
    public final ResultSet resultSet() {
        return resultSet;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateCount());
        hashCode = 31 * hashCode + Objects.hashCode(resultSet());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse) obj;
        return Objects.equals(updateCount(), other.updateCount()) && Objects.equals(resultSet(), other.resultSet())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryResultsResponse").add("UpdateCount", updateCount()).add("ResultSet", resultSet())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateCount":
            return Optional.ofNullable(clazz.cast(updateCount()));
        case "ResultSet":
            return Optional.ofNullable(clazz.cast(resultSet()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateCount", UPDATE_COUNT_FIELD);
        map.put("ResultSet", RESULT_SET_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryResultsResponse> {
        /**
         * <p>
         * The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>, <code>INSERT INTO</code>, or
         * <code>UPDATE</code> statement.
         * </p>
         * 
         * @param updateCount
         *        The number of rows inserted with a <code>CREATE TABLE AS SELECT</code>, <code>INSERT INTO</code>, or
         *        <code>UPDATE</code> statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateCount(Long updateCount);

        /**
         * <p>
         * The results of the query execution.
         * </p>
         * 
         * @param resultSet
         *        The results of the query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSet(ResultSet resultSet);

        /**
         * <p>
         * The results of the query execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultSet.Builder} avoiding the need to
         * create one manually via {@link ResultSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultSet.Builder#build()} is called immediately and its result
         * is passed to {@link #resultSet(ResultSet)}.
         * 
         * @param resultSet
         *        a consumer that will call methods on {@link ResultSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultSet(ResultSet)
         */
        default Builder resultSet(Consumer<ResultSet.Builder> resultSet) {
            return resultSet(ResultSet.builder().applyMutation(resultSet).build());
        }

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private Long updateCount;

        private ResultSet resultSet;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            updateCount(model.updateCount);
            resultSet(model.resultSet);
            nextToken(model.nextToken);
        }

        public final Long getUpdateCount() {
            return updateCount;
        }

        public final void setUpdateCount(Long updateCount) {
            this.updateCount = updateCount;
        }

        @Override
        public final Builder updateCount(Long updateCount) {
            this.updateCount = updateCount;
            return this;
        }

        public final ResultSet.Builder getResultSet() {
            return resultSet != null ? resultSet.toBuilder() : null;
        }

        public final void setResultSet(ResultSet.BuilderImpl resultSet) {
            this.resultSet = resultSet != null ? resultSet.build() : null;
        }

        @Override
        public final Builder resultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
