/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.athena.internal.AthenaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.athena.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetResourceDashboardRequest;
import software.amazon.awssdk.services.athena.model.GetResourceDashboardResponse;
import software.amazon.awssdk.services.athena.model.GetSessionEndpointRequest;
import software.amazon.awssdk.services.athena.model.GetSessionEndpointResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.SessionAlreadyExistsException;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePresignedNotebookUrlRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeletePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ExportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionCodeRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryRuntimeStatisticsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetResourceDashboardRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionEndpointRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ImportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListApplicationDpuSizesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCalculationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListExecutorsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListPreparedStatementsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.PutCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link AthenaClient}.
 *
 * @see AthenaClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAthenaClient implements AthenaClient {
    private static final Logger log = Logger.loggerFor(DefaultAthenaClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Athena" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query
     * ID strings. Requires you to have access to the workgroup in which the queries were saved. Use
     * <a>ListNamedQueriesInput</a> to get the list of named query IDs in the specified workgroup. If information could
     * not be retrieved for a submitted query ID, information about the query ID submitted is listed under
     * <a>UnprocessedNamedQueryId</a>. Named queries differ from executed queries. Use
     * <a>BatchGetQueryExecutionInput</a> to get details about each unique query execution, and
     * <a>ListQueryExecutionsInput</a> to get a list of query execution IDs.
     * </p>
     *
     * @param batchGetNamedQueryRequest
     *        Contains an array of named query IDs.
     * @return Result of the BatchGetNamedQuery operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.BatchGetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetNamedQueryResponse batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetNamedQuery");

            return clientHandler.execute(new ClientExecutionParams<BatchGetNamedQueryRequest, BatchGetNamedQueryResponse>()
                    .withOperationName("BatchGetNamedQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetNamedQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetNamedQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of
     * prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared
     * statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in
     * <code>UnprocessedPreparedStatementNames</code>.
     * </p>
     *
     * @param batchGetPreparedStatementRequest
     * @return Result of the BatchGetPreparedStatement operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.BatchGetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetPreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetPreparedStatementResponse batchGetPreparedStatement(
            BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetPreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetPreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetPreparedStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetPreparedStatementRequest, BatchGetPreparedStatementResponse>()
                            .withOperationName("BatchGetPreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetPreparedStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetPreparedStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an
     * array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To
     * get a list of query execution IDs, use <a>ListQueryExecutionsInput&#36WorkGroup</a>. Query executions differ from
     * named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details about named queries.
     * </p>
     *
     * @param batchGetQueryExecutionRequest
     *        Contains an array of query execution IDs.
     * @return Result of the BatchGetQueryExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.BatchGetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetQueryExecutionResponse batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetQueryExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetQueryExecutionRequest, BatchGetQueryExecutionResponse>()
                            .withOperationName("BatchGetQueryExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetQueryExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetQueryExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will
     * be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has
     * been cancelled, but you can refer to its tags and view it for historical reference.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return Result of the CancelCapacityReservation operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CancelCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelCapacityReservationResponse cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) throws InvalidRequestException,
            InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationRequest, CancelCapacityReservationResponse>()
                            .withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a capacity reservation with the specified name and number of requested data processing units.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return Result of the CreateCapacityReservation operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCapacityReservationResponse createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationRequest, CreateCapacityReservationResponse>()
                            .withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all
     * users of the same Amazon Web Services account.
     * </p>
     * <p>
     * For a <code>FEDERATED</code> catalog, this API operation creates the following resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CFN Stack Name with a maximum length of 128 characters and prefix
     * <code>athenafederatedcatalog-CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda Function Name with a maximum length of 64 characters and prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Glue Connection Name with a maximum length of 255 characters and a prefix
     * <code>athenafederatedcatalog_CATALOG_NAME_SANITIZED</code> with length 23 characters.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDataCatalogRequest
     * @return Result of the CreateDataCatalog operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataCatalogResponse createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCatalog");

            return clientHandler.execute(new ClientExecutionParams<CreateDataCatalogRequest, CreateDataCatalogResponse>()
                    .withOperationName("CreateDataCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
     * </p>
     *
     * @param createNamedQueryRequest
     * @return Result of the CreateNamedQuery operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNamedQueryResponse createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamedQuery");

            return clientHandler.execute(new ClientExecutionParams<CreateNamedQueryRequest, CreateNamedQueryResponse>()
                    .withOperationName("CreateNamedQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNamedQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNamedQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an empty <code>ipynb</code> file in the specified Apache Spark enabled workgroup. Throws an error if a
     * file in the workgroup with the same name already exists.
     * </p>
     *
     * @param createNotebookRequest
     * @return Result of the CreateNotebook operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNotebookResponse createNotebook(CreateNotebookRequest createNotebookRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNotebookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebook");

            return clientHandler.execute(new ClientExecutionParams<CreateNotebookRequest, CreateNotebookResponse>()
                    .withOperationName("CreateNotebook").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNotebookRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNotebookRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a prepared statement for use with SQL queries in Athena.
     * </p>
     *
     * @param createPreparedStatementRequest
     * @return Result of the CreatePreparedStatement operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePreparedStatementResponse createPreparedStatement(CreatePreparedStatementRequest createPreparedStatementRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePreparedStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePreparedStatementRequest, CreatePreparedStatementResponse>()
                            .withOperationName("CreatePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPreparedStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePreparedStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access,
     * <code>CreatePresignedNotebookUrl</code> must be called every 10 minutes to refresh the authentication token. For
     * information about granting programmatic access, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access">Grant
     * programmatic access</a>.
     * </p>
     *
     * @param createPresignedNotebookUrlRequest
     * @return Result of the CreatePresignedNotebookUrl operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreatePresignedNotebookUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreatePresignedNotebookUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePresignedNotebookUrlResponse createPresignedNotebookUrl(
            CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePresignedNotebookUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePresignedNotebookUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPresignedNotebookUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPresignedNotebookUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePresignedNotebookUrlRequest, CreatePresignedNotebookUrlResponse>()
                            .withOperationName("CreatePresignedNotebookUrl").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPresignedNotebookUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePresignedNotebookUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena
     * SQL workgroup.
     * </p>
     *
     * @param createWorkGroupRequest
     * @return Result of the CreateWorkGroup operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.CreateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkGroupResponse createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkGroupRequest, CreateWorkGroupResponse>()
                    .withOperationName("CreateWorkGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted
     * reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A
     * deleted reservation cannot be called by <code>GetCapacityReservation</code>, and deleted reservations do not
     * appear in the output of <code>ListCapacityReservations</code>.
     * </p>
     *
     * @param deleteCapacityReservationRequest
     * @return Result of the DeleteCapacityReservation operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeleteCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCapacityReservationResponse deleteCapacityReservation(
            DeleteCapacityReservationRequest deleteCapacityReservationRequest) throws InvalidRequestException,
            InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCapacityReservationRequest, DeleteCapacityReservationResponse>()
                            .withOperationName("DeleteCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a data catalog.
     * </p>
     *
     * @param deleteDataCatalogRequest
     * @return Result of the DeleteDataCatalog operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeleteDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataCatalogResponse deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCatalog");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataCatalogRequest, DeleteDataCatalogResponse>()
                    .withOperationName("DeleteDataCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the named query if you have access to the workgroup in which the query was saved.
     * </p>
     *
     * @param deleteNamedQueryRequest
     * @return Result of the DeleteNamedQuery operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeleteNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNamedQueryResponse deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamedQuery");

            return clientHandler.execute(new ClientExecutionParams<DeleteNamedQueryRequest, DeleteNamedQueryResponse>()
                    .withOperationName("DeleteNamedQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNamedQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNamedQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified notebook.
     * </p>
     *
     * @param deleteNotebookRequest
     * @return Result of the DeleteNotebook operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeleteNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNotebookResponse deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNotebookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebook");

            return clientHandler.execute(new ClientExecutionParams<DeleteNotebookRequest, DeleteNotebookResponse>()
                    .withOperationName("DeleteNotebook").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNotebookRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNotebookRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param deletePreparedStatementRequest
     * @return Result of the DeletePreparedStatement operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeletePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeletePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePreparedStatementResponse deletePreparedStatement(DeletePreparedStatementRequest deletePreparedStatementRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePreparedStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePreparedStatementRequest, DeletePreparedStatementResponse>()
                            .withOperationName("DeletePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deletePreparedStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePreparedStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
     * </p>
     *
     * @param deleteWorkGroupRequest
     * @return Result of the DeleteWorkGroup operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.DeleteWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkGroupResponse deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkGroupRequest, DeleteWorkGroupResponse>()
                    .withOperationName("DeleteWorkGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteWorkGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports the specified notebook and its metadata.
     * </p>
     *
     * @param exportNotebookRequest
     * @return Result of the ExportNotebook operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ExportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ExportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ExportNotebookResponse exportNotebook(ExportNotebookRequest exportNotebookRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportNotebookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExportNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportNotebook");

            return clientHandler.execute(new ClientExecutionParams<ExportNotebookRequest, ExportNotebookResponse>()
                    .withOperationName("ExportNotebook").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(exportNotebookRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExportNotebookRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a previously submitted calculation execution.
     * </p>
     *
     * @param getCalculationExecutionRequest
     * @return Result of the GetCalculationExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCalculationExecutionResponse getCalculationExecution(GetCalculationExecutionRequest getCalculationExecutionRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionRequest, GetCalculationExecutionResponse>()
                            .withOperationName("GetCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCalculationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the unencrypted code that was executed for the calculation.
     * </p>
     *
     * @param getCalculationExecutionCodeRequest
     * @return Result of the GetCalculationExecutionCode operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetCalculationExecutionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCalculationExecutionCodeResponse getCalculationExecutionCode(
            GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCalculationExecutionCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCalculationExecutionCodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalculationExecutionCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionCode");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionCodeRequest, GetCalculationExecutionCodeResponse>()
                            .withOperationName("GetCalculationExecutionCode").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionCodeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCalculationExecutionCodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of a current calculation.
     * </p>
     *
     * @param getCalculationExecutionStatusRequest
     * @return Result of the GetCalculationExecutionStatus operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetCalculationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCalculationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCalculationExecutionStatusResponse getCalculationExecutionStatus(
            GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCalculationExecutionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCalculationExecutionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCalculationExecutionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCalculationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCalculationExecutionStatusRequest, GetCalculationExecutionStatusResponse>()
                            .withOperationName("GetCalculationExecutionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCalculationExecutionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the capacity assignment configuration for a capacity reservation, if one exists.
     * </p>
     *
     * @param getCapacityAssignmentConfigurationRequest
     * @return Result of the GetCapacityAssignmentConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCapacityAssignmentConfigurationResponse getCapacityAssignmentConfiguration(
            GetCapacityAssignmentConfigurationRequest getCapacityAssignmentConfigurationRequest) throws InvalidRequestException,
            InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCapacityAssignmentConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCapacityAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCapacityAssignmentConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityAssignmentConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCapacityAssignmentConfigurationRequest, GetCapacityAssignmentConfigurationResponse>()
                            .withOperationName("GetCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCapacityAssignmentConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCapacityAssignmentConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the capacity reservation with the specified name.
     * </p>
     *
     * @param getCapacityReservationRequest
     * @return Result of the GetCapacityReservation operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCapacityReservationResponse getCapacityReservation(GetCapacityReservationRequest getCapacityReservationRequest)
            throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCapacityReservationRequest, GetCapacityReservationResponse>()
                            .withOperationName("GetCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the specified data catalog.
     * </p>
     *
     * @param getDataCatalogRequest
     * @return Result of the GetDataCatalog operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataCatalogResponse getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCatalog");

            return clientHandler.execute(new ClientExecutionParams<GetDataCatalogRequest, GetDataCatalogResponse>()
                    .withOperationName("GetDataCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDataCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a database object for the specified database and data catalog.
     * </p>
     *
     * @param getDatabaseRequest
     * @return Result of the GetDatabase operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws MetadataException
     *         An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by
     *         user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InternalServerException,
            InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDatabase");

            return clientHandler.execute(new ClientExecutionParams<GetDatabaseRequest, GetDatabaseResponse>()
                    .withOperationName("GetDatabase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDatabaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDatabaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a single query. Requires that you have access to the workgroup in which the query was
     * saved.
     * </p>
     *
     * @param getNamedQueryRequest
     * @return Result of the GetNamedQuery operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetNamedQueryResponse getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamedQuery");

            return clientHandler.execute(new ClientExecutionParams<GetNamedQueryRequest, GetNamedQueryResponse>()
                    .withOperationName("GetNamedQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getNamedQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNamedQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves notebook metadata for the specified notebook ID.
     * </p>
     *
     * @param getNotebookMetadataRequest
     * @return Result of the GetNotebookMetadata operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetNotebookMetadataResponse getNotebookMetadata(GetNotebookMetadataRequest getNotebookMetadataRequest)
            throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNotebookMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetNotebookMetadataRequest, GetNotebookMetadataResponse>()
                    .withOperationName("GetNotebookMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getNotebookMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNotebookMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the prepared statement with the specified name from the specified workgroup.
     * </p>
     *
     * @param getPreparedStatementRequest
     * @return Result of the GetPreparedStatement operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetPreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetPreparedStatement" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPreparedStatementResponse getPreparedStatement(GetPreparedStatementRequest getPreparedStatementRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreparedStatement");

            return clientHandler.execute(new ClientExecutionParams<GetPreparedStatementRequest, GetPreparedStatementResponse>()
                    .withOperationName("GetPreparedStatement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getPreparedStatementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPreparedStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a single execution of a query if you have access to the workgroup in which the query
     * ran. Each time a query executes, information about the query execution is saved with a unique ID.
     * </p>
     *
     * @param getQueryExecutionRequest
     * @return Result of the GetQueryExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQueryExecutionResponse getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryExecution");

            return clientHandler.execute(new ClientExecutionParams<GetQueryExecutionRequest, GetQueryExecutionResponse>()
                    .withOperationName("GetQueryExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueryExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQueryExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Streams the results of a single query execution specified by <code>QueryExecutionId</code> from the Athena query
     * results location in Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with query results, recent queries, and
     * output files</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query but returns
     * results. Use <a>StartQueryExecution</a> to run a query.
     * </p>
     * <p>
     * To stream query results successfully, the IAM principal with permission to call <code>GetQueryResults</code> also
     * must have permissions to the Amazon S3 <code>GetObject</code> action for the Athena query results location.
     * </p>
     * <important>
     * <p>
     * IAM principals with permission to the Amazon S3 <code>GetObject</code> action for the query results location are
     * able to retrieve query results from Amazon S3 even if permission to the <code>GetQueryResults</code> action is
     * denied. To restrict user or role access, ensure that Amazon S3 permissions to the Athena query location are
     * denied.
     * </p>
     * </important>
     *
     * @param getQueryResultsRequest
     * @return Result of the GetQueryResults operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueryResultsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQueryResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");

            return clientHandler.execute(new ClientExecutionParams<GetQueryResultsRequest, GetQueryResultsResponse>()
                    .withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueryResultsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQueryResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns query execution runtime statistics related to a single execution of a query if you have access to the
     * workgroup in which the query ran. Statistics from the <code>Timeline</code> section of the response object are
     * available as soon as <a>QueryExecutionStatus&#36State</a> is in a SUCCEEDED or FAILED state. The remaining
     * non-timeline statistics in the response (like stage-level input and output row count and data size) are updated
     * asynchronously and may not be available immediately after a query completes or, in some cases, may not be
     * returned. The non-timeline statistics are also not included when a query has row-level filters defined in Lake
     * Formation.
     * </p>
     *
     * @param getQueryRuntimeStatisticsRequest
     * @return Result of the GetQueryRuntimeStatistics operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetQueryRuntimeStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryRuntimeStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetQueryRuntimeStatisticsResponse getQueryRuntimeStatistics(
            GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueryRuntimeStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetQueryRuntimeStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryRuntimeStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryRuntimeStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryRuntimeStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetQueryRuntimeStatisticsRequest, GetQueryRuntimeStatisticsResponse>()
                            .withOperationName("GetQueryRuntimeStatistics").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getQueryRuntimeStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetQueryRuntimeStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the Live UI/Persistence UI for a session.
     * </p>
     *
     * @param getResourceDashboardRequest
     * @return Result of the GetResourceDashboard operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetResourceDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetResourceDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetResourceDashboardResponse getResourceDashboard(GetResourceDashboardRequest getResourceDashboardRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceDashboard");

            return clientHandler.execute(new ClientExecutionParams<GetResourceDashboardRequest, GetResourceDashboardResponse>()
                    .withOperationName("GetResourceDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getResourceDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourceDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the full details of a previously created session, including the session status and configuration.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");

            return clientHandler.execute(new ClientExecutionParams<GetSessionRequest, GetSessionResponse>()
                    .withOperationName("GetSession").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getSessionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a connection endpoint and authentication token for a given session Id.
     * </p>
     *
     * @param getSessionEndpointRequest
     * @return Result of the GetSessionEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetSessionEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSessionEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionEndpointResponse getSessionEndpoint(GetSessionEndpointRequest getSessionEndpointRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSessionEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionEndpoint");

            return clientHandler.execute(new ClientExecutionParams<GetSessionEndpointRequest, GetSessionEndpointResponse>()
                    .withOperationName("GetSessionEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSessionEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the current status of a session.
     * </p>
     *
     * @param getSessionStatusRequest
     * @return Result of the GetSessionStatus operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetSessionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetSessionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSessionStatusResponse getSessionStatus(GetSessionStatusRequest getSessionStatusRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSessionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSessionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionStatus");

            return clientHandler.execute(new ClientExecutionParams<GetSessionStatusRequest, GetSessionStatusResponse>()
                    .withOperationName("GetSessionStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSessionStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns table metadata for the specified catalog, database, and table.
     * </p>
     *
     * @param getTableMetadataRequest
     * @return Result of the GetTableMetadata operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws MetadataException
     *         An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by
     *         user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTableMetadataResponse getTableMetadata(GetTableMetadataRequest getTableMetadataRequest)
            throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException,
            AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTableMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTableMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTableMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTableMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetTableMetadataRequest, GetTableMetadataResponse>()
                    .withOperationName("GetTableMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTableMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTableMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the workgroup with the specified name.
     * </p>
     *
     * @param getWorkGroupRequest
     * @return Result of the GetWorkGroup operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.GetWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkGroupResponse getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkGroup");

            return clientHandler.execute(new ClientExecutionParams<GetWorkGroupRequest, GetWorkGroupResponse>()
                    .withOperationName("GetWorkGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a single <code>ipynb</code> file to a Spark enabled workgroup. To import the notebook, the request must
     * specify a value for either <code>Payload</code> or <code>NoteBookS3LocationUri</code>. If neither is specified or
     * both are specified, an <code>InvalidRequestException</code> occurs. The maximum file size that can be imported is
     * 10 megabytes. If an <code>ipynb</code> file with the same name already exists in the workgroup, throws an error.
     * </p>
     *
     * @param importNotebookRequest
     * @return Result of the ImportNotebook operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ImportNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ImportNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ImportNotebookResponse importNotebook(ImportNotebookRequest importNotebookRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportNotebookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportNotebook");

            return clientHandler.execute(new ClientExecutionParams<ImportNotebookRequest, ImportNotebookResponse>()
                    .withOperationName("ImportNotebook").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importNotebookRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportNotebookRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the supported DPU sizes for the supported application runtimes (for example,
     * <code>Athena notebook version 1</code>).
     * </p>
     *
     * @param listApplicationDpuSizesRequest
     * @return Result of the ListApplicationDPUSizes operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListApplicationDPUSizes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApplicationDpuSizesResponse listApplicationDPUSizes(ListApplicationDpuSizesRequest listApplicationDpuSizesRequest)
            throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApplicationDpuSizesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListApplicationDpuSizesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationDpuSizesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationDpuSizesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationDPUSizes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListApplicationDpuSizesRequest, ListApplicationDpuSizesResponse>()
                            .withOperationName("ListApplicationDPUSizes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listApplicationDpuSizesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListApplicationDpuSizesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed
     * first; older calculations are listed later.
     * </p>
     *
     * @param listCalculationExecutionsRequest
     * @return Result of the ListCalculationExecutions operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListCalculationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCalculationExecutionsResponse listCalculationExecutions(
            ListCalculationExecutionsRequest listCalculationExecutionsRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCalculationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCalculationExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCalculationExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCalculationExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCalculationExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCalculationExecutionsRequest, ListCalculationExecutionsResponse>()
                            .withOperationName("ListCalculationExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCalculationExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCalculationExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the capacity reservations for the current account.
     * </p>
     *
     * @param listCapacityReservationsRequest
     * @return Result of the ListCapacityReservations operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListCapacityReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCapacityReservationsResponse listCapacityReservations(
            ListCapacityReservationsRequest listCapacityReservationsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCapacityReservationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCapacityReservationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCapacityReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCapacityReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCapacityReservations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCapacityReservationsRequest, ListCapacityReservationsResponse>()
                            .withOperationName("ListCapacityReservations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCapacityReservationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCapacityReservationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the data catalogs in the current Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * In the Athena console, data catalogs are listed as "data sources" on the <b>Data sources</b> page under the
     * <b>Data source name</b> column.
     * </p>
     * </note>
     *
     * @param listDataCatalogsRequest
     * @return Result of the ListDataCatalogs operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListDataCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDataCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataCatalogsResponse listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataCatalogsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataCatalogsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataCatalogsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataCatalogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCatalogs");

            return clientHandler.execute(new ClientExecutionParams<ListDataCatalogsRequest, ListDataCatalogsResponse>()
                    .withOperationName("ListDataCatalogs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDataCatalogsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataCatalogsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the databases in the specified data catalog.
     * </p>
     *
     * @param listDatabasesRequest
     * @return Result of the ListDatabases operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws MetadataException
     *         An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by
     *         user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException,
            InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatabasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatabases");

            return clientHandler.execute(new ClientExecutionParams<ListDatabasesRequest, ListDatabasesResponse>()
                    .withOperationName("ListDatabases").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDatabasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDatabasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of engine versions that are available to choose from, including the Auto option.
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return Result of the ListEngineVersions operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEngineVersionsResponse listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngineVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEngineVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngineVersions");

            return clientHandler.execute(new ClientExecutionParams<ListEngineVersionsRequest, ListEngineVersionsResponse>()
                    .withOperationName("ListEngineVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEngineVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEngineVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists, in descending order, the executors that joined a session. Newer executors are listed first; older
     * executors are listed later. The result can be optionally filtered by state.
     * </p>
     *
     * @param listExecutorsRequest
     * @return Result of the ListExecutors operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListExecutors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExecutorsResponse listExecutors(ListExecutorsRequest listExecutorsRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExecutorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExecutorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listExecutorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExecutorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExecutors");

            return clientHandler.execute(new ClientExecutionParams<ListExecutorsRequest, ListExecutorsResponse>()
                    .withOperationName("ListExecutors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listExecutorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExecutorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have
     * access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary
     * workgroup.
     * </p>
     *
     * @param listNamedQueriesRequest
     * @return Result of the ListNamedQueries operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListNamedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListNamedQueriesResponse listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNamedQueriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListNamedQueriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNamedQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamedQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamedQueries");

            return clientHandler.execute(new ClientExecutionParams<ListNamedQueriesRequest, ListNamedQueriesResponse>()
                    .withOperationName("ListNamedQueries").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listNamedQueriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNamedQueriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the notebook files for the specified workgroup in paginated format.
     * </p>
     *
     * @param listNotebookMetadataRequest
     * @return Result of the ListNotebookMetadata operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListNotebookMetadataResponse listNotebookMetadata(ListNotebookMetadataRequest listNotebookMetadataRequest)
            throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookMetadata");

            return clientHandler.execute(new ClientExecutionParams<ListNotebookMetadataRequest, ListNotebookMetadataResponse>()
                    .withOperationName("ListNotebookMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listNotebookMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNotebookMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists, in descending order, the sessions that have been created in a notebook that are in an active state like
     * <code>CREATING</code>, <code>CREATED</code>, <code>IDLE</code> or <code>BUSY</code>. Newer sessions are listed
     * first; older sessions are listed later.
     * </p>
     *
     * @param listNotebookSessionsRequest
     * @return Result of the ListNotebookSessions operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListNotebookSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest listNotebookSessionsRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNotebookSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNotebookSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNotebookSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNotebookSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookSessions");

            return clientHandler.execute(new ClientExecutionParams<ListNotebookSessionsRequest, ListNotebookSessionsResponse>()
                    .withOperationName("ListNotebookSessions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listNotebookSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNotebookSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the prepared statements in the specified workgroup.
     * </p>
     *
     * @param listPreparedStatementsRequest
     * @return Result of the ListPreparedStatements operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListPreparedStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListPreparedStatements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPreparedStatementsResponse listPreparedStatements(ListPreparedStatementsRequest listPreparedStatementsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPreparedStatementsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPreparedStatementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPreparedStatementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPreparedStatementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPreparedStatements");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPreparedStatementsRequest, ListPreparedStatementsResponse>()
                            .withOperationName("ListPreparedStatements").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listPreparedStatementsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPreparedStatementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query
     * history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary
     * workgroup. Requires you to have access to the workgroup in which the queries ran.
     * </p>
     *
     * @param listQueryExecutionsRequest
     * @return Result of the ListQueryExecutions operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListQueryExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListQueryExecutionsResponse listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListQueryExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListQueryExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listQueryExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listQueryExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueryExecutions");

            return clientHandler.execute(new ClientExecutionParams<ListQueryExecutionsRequest, ListQueryExecutionsResponse>()
                    .withOperationName("ListQueryExecutions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listQueryExecutionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListQueryExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the sessions in a workgroup that are in an active state like <code>CREATING</code>, <code>CREATED</code>,
     * <code>IDLE</code>, or <code>BUSY</code>. Newer sessions are listed first; older sessions are listed later.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");

            return clientHandler.execute(new ClientExecutionParams<ListSessionsRequest, ListSessionsResponse>()
                    .withOperationName("ListSessions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the metadata for the tables in the specified data catalog database.
     * </p>
     *
     * @param listTableMetadataRequest
     * @return Result of the ListTableMetadata operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws MetadataException
     *         An exception that Athena received when it called a custom metastore. Occurs if the error is not caused by
     *         user input (<code>InvalidRequestException</code>) or from the Athena platform (
     *         <code>InternalServerException</code>). For example, if a user-created Lambda function is missing
     *         permissions, the Lambda <code>4XX</code> exception is returned in a <code>MetadataException</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTableMetadataResponse listTableMetadata(ListTableMetadataRequest listTableMetadataRequest)
            throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException,
            AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTableMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTableMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTableMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTableMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableMetadata");

            return clientHandler.execute(new ClientExecutionParams<ListTableMetadataRequest, ListTableMetadataResponse>()
                    .withOperationName("ListTableMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTableMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTableMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags associated with an Athena resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists available workgroups for the account.
     * </p>
     *
     * @param listWorkGroupsRequest
     * @return Result of the ListWorkGroups operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.ListWorkGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkGroupsResponse listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkGroups");

            return clientHandler.execute(new ClientExecutionParams<ListWorkGroupsRequest, ListWorkGroupsResponse>()
                    .withOperationName("ListWorkGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listWorkGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment
     * configuration already exists for the capacity reservation, replaces the existing capacity assignment
     * configuration.
     * </p>
     *
     * @param putCapacityAssignmentConfigurationRequest
     * @return Result of the PutCapacityAssignmentConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.PutCapacityAssignmentConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/PutCapacityAssignmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutCapacityAssignmentConfigurationResponse putCapacityAssignmentConfiguration(
            PutCapacityAssignmentConfigurationRequest putCapacityAssignmentConfigurationRequest) throws InvalidRequestException,
            InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutCapacityAssignmentConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutCapacityAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putCapacityAssignmentConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutCapacityAssignmentConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutCapacityAssignmentConfigurationRequest, PutCapacityAssignmentConfigurationResponse>()
                            .withOperationName("PutCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putCapacityAssignmentConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutCapacityAssignmentConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits calculations for execution within a session. You can supply the code to run as an inline code block
     * within the request.
     * </p>
     * <note>
     * <p>
     * The request syntax requires the <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter or the
     * <a>CalculationConfiguration&#36CodeBlock</a> parameter, but not both. Because
     * <a>CalculationConfiguration&#36CodeBlock</a> is deprecated, use the
     * <a>StartCalculationExecutionRequest&#36CodeBlock</a> parameter instead.
     * </p>
     * </note>
     *
     * @param startCalculationExecutionRequest
     * @return Result of the StartCalculationExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.StartCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartCalculationExecutionResponse startCalculationExecution(
            StartCalculationExecutionRequest startCalculationExecutionRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCalculationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartCalculationExecutionRequest, StartCalculationExecutionResponse>()
                            .withOperationName("StartCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startCalculationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartCalculationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs the SQL query statements contained in the <code>Query</code>. Requires you to have access to the workgroup
     * in which the query ran. Running queries against an external catalog requires <a>GetDataCatalog</a> permission to
     * the catalog. For code samples using the Amazon Web Services SDK for Java, see <a
     * href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and Code Samples</a> in the
     * <i>Amazon Athena User Guide</i>.
     * </p>
     *
     * @param startQueryExecutionRequest
     * @return Result of the StartQueryExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.StartQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartQueryExecutionResponse startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest)
            throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryExecution");

            return clientHandler.execute(new ClientExecutionParams<StartQueryExecutionRequest, StartQueryExecutionResponse>()
                    .withOperationName("StartQueryExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startQueryExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartQueryExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a session for running calculations within a workgroup. The session is ready when it reaches an
     * <code>IDLE</code> state.
     * </p>
     *
     * @param startSessionRequest
     * @return Result of the StartSession operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SessionAlreadyExistsException
     *         The specified session already exists.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartSessionResponse startSession(StartSessionRequest startSessionRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, SessionAlreadyExistsException, TooManyRequestsException,
            AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");

            return clientHandler.execute(new ClientExecutionParams<StartSessionRequest, StartSessionResponse>()
                    .withOperationName("StartSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests the cancellation of a calculation. A <code>StopCalculationExecution</code> call on a calculation that is
     * already in a terminal state (for example, <code>STOPPED</code>, <code>FAILED</code>, or <code>COMPLETED</code>)
     * succeeds but has no effect.
     * </p>
     * <note>
     * <p>
     * Cancelling a calculation is done on a best effort basis. If a calculation cannot be cancelled, you can be charged
     * for its completion. If you are concerned about being charged for a calculation that cannot be cancelled, consider
     * terminating the session in which the calculation is running.
     * </p>
     * </note>
     *
     * @param stopCalculationExecutionRequest
     * @return Result of the StopCalculationExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.StopCalculationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopCalculationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopCalculationExecutionResponse stopCalculationExecution(
            StopCalculationExecutionRequest stopCalculationExecutionRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopCalculationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopCalculationExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopCalculationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCalculationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StopCalculationExecutionRequest, StopCalculationExecutionResponse>()
                            .withOperationName("StopCalculationExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopCalculationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopCalculationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a query execution. Requires you to have access to the workgroup in which the query ran.
     * </p>
     *
     * @param stopQueryExecutionRequest
     * @return Result of the StopQueryExecution operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.StopQueryExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopQueryExecutionResponse stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopQueryExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopQueryExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopQueryExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQueryExecution");

            return clientHandler.execute(new ClientExecutionParams<StopQueryExecutionRequest, StopQueryExecutionResponse>()
                    .withOperationName("StopQueryExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopQueryExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopQueryExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of
     * a key and an optional value, both of which you define. For example, you can use tags to categorize Athena
     * workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of
     * tag keys to make it easier to search and filter the resources in your account. For best practices, see <a
     * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging
     * Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256
     * UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters:
     * + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify
     * more than one tag, separate them by commas.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Terminates an active session. A <code>TerminateSession</code> call on a session that is already inactive (for
     * example, in a <code>FAILED</code>, <code>TERMINATED</code> or <code>TERMINATING</code> state) succeeds but has no
     * effect. Calculations running in the session when <code>TerminateSession</code> is called are forcefully stopped,
     * but may display as <code>FAILED</code> instead of <code>STOPPED</code>.
     * </p>
     *
     * @param terminateSessionRequest
     * @return Result of the TerminateSession operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TerminateSessionResponse terminateSession(TerminateSessionRequest terminateSessionRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TerminateSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");

            return clientHandler.execute(new ClientExecutionParams<TerminateSessionRequest, TerminateSessionResponse>()
                    .withOperationName("TerminateSession").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(terminateSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TerminateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from an Athena resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the number of requested data processing units for the capacity reservation with the specified name.
     * </p>
     *
     * @param updateCapacityReservationRequest
     * @return Result of the UpdateCapacityReservation operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCapacityReservationResponse updateCapacityReservation(
            UpdateCapacityReservationRequest updateCapacityReservationRequest) throws InvalidRequestException,
            InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCapacityReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCapacityReservationRequest, UpdateCapacityReservationResponse>()
                            .withOperationName("UpdateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the data catalog that has the specified name.
     * </p>
     *
     * @param updateDataCatalogRequest
     * @return Result of the UpdateDataCatalog operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateDataCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateDataCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDataCatalogResponse updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataCatalogResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataCatalogRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataCatalogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCatalog");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataCatalogRequest, UpdateDataCatalogResponse>()
                    .withOperationName("UpdateDataCatalog").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDataCatalogRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataCatalogRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <a>NamedQuery</a> object. The database or workgroup cannot be updated.
     * </p>
     *
     * @param updateNamedQueryRequest
     * @return Result of the UpdateNamedQuery operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateNamedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNamedQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateNamedQueryResponse updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNamedQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNamedQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNamedQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamedQuery");

            return clientHandler.execute(new ClientExecutionParams<UpdateNamedQueryRequest, UpdateNamedQueryResponse>()
                    .withOperationName("UpdateNamedQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateNamedQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNamedQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the contents of a Spark notebook.
     * </p>
     *
     * @param updateNotebookRequest
     * @return Result of the UpdateNotebook operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateNotebook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateNotebookResponse updateNotebook(UpdateNotebookRequest updateNotebookRequest) throws InternalServerException,
            InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNotebookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNotebookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebook");

            return clientHandler.execute(new ClientExecutionParams<UpdateNotebookRequest, UpdateNotebookResponse>()
                    .withOperationName("UpdateNotebook").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateNotebookRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNotebookRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the metadata for a notebook.
     * </p>
     *
     * @param updateNotebookMetadataRequest
     * @return Result of the UpdateNotebookMetadata operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws TooManyRequestsException
     *         Indicates that the request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateNotebookMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateNotebookMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateNotebookMetadataResponse updateNotebookMetadata(UpdateNotebookMetadataRequest updateNotebookMetadataRequest)
            throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNotebookMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNotebookMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNotebookMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebookMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateNotebookMetadataRequest, UpdateNotebookMetadataResponse>()
                            .withOperationName("UpdateNotebookMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateNotebookMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateNotebookMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a prepared statement.
     * </p>
     *
     * @param updatePreparedStatementRequest
     * @return Result of the UpdatePreparedStatement operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws ResourceNotFoundException
     *         A resource, such as a workgroup, was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdatePreparedStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdatePreparedStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePreparedStatementResponse updatePreparedStatement(UpdatePreparedStatementRequest updatePreparedStatementRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePreparedStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePreparedStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePreparedStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreparedStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdatePreparedStatementRequest, UpdatePreparedStatementResponse>()
                            .withOperationName("UpdatePreparedStatement").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updatePreparedStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdatePreparedStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only
     * <code>ConfigurationUpdates</code> can be specified.
     * </p>
     *
     * @param updateWorkGroupRequest
     * @return Result of the UpdateWorkGroup operation returned by the service.
     * @throws InternalServerException
     *         Indicates a platform issue, which may be due to a transient condition or outage.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a required parameter may be
     *         missing or out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AthenaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AthenaClient.UpdateWorkGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWorkGroupResponse updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MetadataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MetadataException::builder).build());
            case "SessionAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkGroupRequest, UpdateWorkGroupResponse>()
                    .withOperationName("UpdateWorkGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateWorkGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AthenaServiceClientConfigurationBuilder serviceConfigBuilder = new AthenaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(AthenaException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final AthenaServiceClientConfiguration serviceClientConfiguration() {
        return new AthenaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
