/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for delivering logs to Amazon CloudWatch log groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLoggingConfiguration.Builder, CloudWatchLoggingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CloudWatchLoggingConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroup").getter(getter(CloudWatchLoggingConfiguration::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStreamNamePrefix").getter(getter(CloudWatchLoggingConfiguration::logStreamNamePrefix))
            .setter(setter(Builder::logStreamNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreamNamePrefix").build())
            .build();

    private static final SdkField<Map<String, List<String>>> LOG_TYPES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("LogTypes")
            .getter(getter(CloudWatchLoggingConfiguration::logTypes))
            .setter(setter(Builder::logTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LOG_GROUP_FIELD, LOG_STREAM_NAME_PREFIX_FIELD, LOG_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String logGroup;

    private final String logStreamNamePrefix;

    private final Map<String, List<String>> logTypes;

    private CloudWatchLoggingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroup = builder.logGroup;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.logTypes = builder.logTypes;
    }

    /**
     * <p>
     * Enables CloudWatch logging.
     * </p>
     * 
     * @return Enables CloudWatch logging.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
     * </p>
     * 
     * @return The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
     */
    public final String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * Prefix for the CloudWatch log stream name.
     * </p>
     * 
     * @return Prefix for the CloudWatch log stream name.
     */
    public final String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogTypes() {
        return logTypes != null && !(logTypes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The types of logs that you want to publish to CloudWatch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return The types of logs that you want to publish to CloudWatch.
     */
    public final Map<String, List<String>> logTypes() {
        return logTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypes() ? logTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingConfiguration)) {
            return false;
        }
        CloudWatchLoggingConfiguration other = (CloudWatchLoggingConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(logGroup(), other.logGroup())
                && Objects.equals(logStreamNamePrefix(), other.logStreamNamePrefix()) && hasLogTypes() == other.hasLogTypes()
                && Objects.equals(logTypes(), other.logTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLoggingConfiguration").add("Enabled", enabled()).add("LogGroup", logGroup())
                .add("LogStreamNamePrefix", logStreamNamePrefix()).add("LogTypes", hasLogTypes() ? logTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LogStreamNamePrefix":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefix()));
        case "LogTypes":
            return Optional.ofNullable(clazz.cast(logTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("LogGroup", LOG_GROUP_FIELD);
        map.put("LogStreamNamePrefix", LOG_STREAM_NAME_PREFIX_FIELD);
        map.put("LogTypes", LOG_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLoggingConfiguration, T> g) {
        return obj -> g.apply((CloudWatchLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLoggingConfiguration> {
        /**
         * <p>
         * Enables CloudWatch logging.
         * </p>
         * 
         * @param enabled
         *        Enables CloudWatch logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
         * </p>
         * 
         * @param logGroup
         *        The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * Prefix for the CloudWatch log stream name.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        Prefix for the CloudWatch log stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * The types of logs that you want to publish to CloudWatch.
         * </p>
         * 
         * @param logTypes
         *        The types of logs that you want to publish to CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(Map<String, ? extends Collection<String>> logTypes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String logGroup;

        private String logStreamNamePrefix;

        private Map<String, List<String>> logTypes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingConfiguration model) {
            enabled(model.enabled);
            logGroup(model.logGroup);
            logStreamNamePrefix(model.logStreamNamePrefix);
            logTypes(model.logTypes);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getLogTypes() {
            if (logTypes instanceof SdkAutoConstructMap) {
                return null;
            }
            return logTypes;
        }

        public final void setLogTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypesMapCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypes(Map<String, ? extends Collection<String>> logTypes) {
            this.logTypes = LogTypesMapCopier.copy(logTypes);
            return this;
        }

        @Override
        public CloudWatchLoggingConfiguration build() {
            return new CloudWatchLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
