/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains data processing unit (DPU) configuration settings and parameter mappings for a notebook engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EngineConfiguration.Builder, EngineConfiguration> {
    private static final SdkField<Integer> COORDINATOR_DPU_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoordinatorDpuSize").getter(getter(EngineConfiguration::coordinatorDpuSize))
            .setter(setter(Builder::coordinatorDpuSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoordinatorDpuSize").build())
            .build();

    private static final SdkField<Integer> MAX_CONCURRENT_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentDpus").getter(getter(EngineConfiguration::maxConcurrentDpus))
            .setter(setter(Builder::maxConcurrentDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentDpus").build()).build();

    private static final SdkField<Integer> DEFAULT_EXECUTOR_DPU_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultExecutorDpuSize").getter(getter(EngineConfiguration::defaultExecutorDpuSize))
            .setter(setter(Builder::defaultExecutorDpuSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExecutorDpuSize").build())
            .build();

    private static final SdkField<Map<String, String>> ADDITIONAL_CONFIGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalConfigs")
            .getter(getter(EngineConfiguration::additionalConfigs))
            .setter(setter(Builder::additionalConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalConfigs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SparkProperties")
            .getter(getter(EngineConfiguration::sparkProperties))
            .setter(setter(Builder::sparkProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Classification>> CLASSIFICATIONS_FIELD = SdkField
            .<List<Classification>> builder(MarshallingType.LIST)
            .memberName("Classifications")
            .getter(getter(EngineConfiguration::classifications))
            .setter(setter(Builder::classifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Classification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Classification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COORDINATOR_DPU_SIZE_FIELD,
            MAX_CONCURRENT_DPUS_FIELD, DEFAULT_EXECUTOR_DPU_SIZE_FIELD, ADDITIONAL_CONFIGS_FIELD, SPARK_PROPERTIES_FIELD,
            CLASSIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer coordinatorDpuSize;

    private final Integer maxConcurrentDpus;

    private final Integer defaultExecutorDpuSize;

    private final Map<String, String> additionalConfigs;

    private final Map<String, String> sparkProperties;

    private final List<Classification> classifications;

    private EngineConfiguration(BuilderImpl builder) {
        this.coordinatorDpuSize = builder.coordinatorDpuSize;
        this.maxConcurrentDpus = builder.maxConcurrentDpus;
        this.defaultExecutorDpuSize = builder.defaultExecutorDpuSize;
        this.additionalConfigs = builder.additionalConfigs;
        this.sparkProperties = builder.sparkProperties;
        this.classifications = builder.classifications;
    }

    /**
     * <p>
     * The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates processing
     * work and manages other executors in a notebook session. The default is 1.
     * </p>
     * 
     * @return The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates
     *         processing work and manages other executors in a notebook session. The default is 1.
     */
    public final Integer coordinatorDpuSize() {
        return coordinatorDpuSize;
    }

    /**
     * <p>
     * The maximum number of DPUs that can run concurrently.
     * </p>
     * 
     * @return The maximum number of DPUs that can run concurrently.
     */
    public final Integer maxConcurrentDpus() {
        return maxConcurrentDpus;
    }

    /**
     * <p>
     * The default number of DPUs to use for executors. An executor is the smallest unit of compute that a notebook
     * session can request from Athena. The default is 1.
     * </p>
     * 
     * @return The default number of DPUs to use for executors. An executor is the smallest unit of compute that a
     *         notebook session can request from Athena. The default is 1.
     */
    public final Integer defaultExecutorDpuSize() {
        return defaultExecutorDpuSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalConfigs() {
        return additionalConfigs != null && !(additionalConfigs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of
     * key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve, specify a value
     * for the <a>StartSessionRequest$NotebookVersion</a> field, and then add a key named <code>NotebookId</code> to
     * <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConfigs} method.
     * </p>
     * 
     * @return Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form
     *         of key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve,
     *         specify a value for the <a>StartSessionRequest$NotebookVersion</a> field, and then add a key named
     *         <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
     */
    public final Map<String, String> additionalConfigs() {
        return additionalConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSparkProperties() {
        return sparkProperties != null && !(sparkProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general
     * Spark tuning.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkProperties} method.
     * </p>
     * 
     * @return Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and
     *         general Spark tuning.
     */
    public final Map<String, String> sparkProperties() {
        return sparkProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Classifications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClassifications() {
        return classifications != null && !(classifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration classifications that can be specified for the engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassifications} method.
     * </p>
     * 
     * @return The configuration classifications that can be specified for the engine.
     */
    public final List<Classification> classifications() {
        return classifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coordinatorDpuSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentDpus());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExecutorDpuSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConfigs() ? additionalConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkProperties() ? sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClassifications() ? classifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineConfiguration)) {
            return false;
        }
        EngineConfiguration other = (EngineConfiguration) obj;
        return Objects.equals(coordinatorDpuSize(), other.coordinatorDpuSize())
                && Objects.equals(maxConcurrentDpus(), other.maxConcurrentDpus())
                && Objects.equals(defaultExecutorDpuSize(), other.defaultExecutorDpuSize())
                && hasAdditionalConfigs() == other.hasAdditionalConfigs()
                && Objects.equals(additionalConfigs(), other.additionalConfigs())
                && hasSparkProperties() == other.hasSparkProperties()
                && Objects.equals(sparkProperties(), other.sparkProperties())
                && hasClassifications() == other.hasClassifications()
                && Objects.equals(classifications(), other.classifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineConfiguration").add("CoordinatorDpuSize", coordinatorDpuSize())
                .add("MaxConcurrentDpus", maxConcurrentDpus()).add("DefaultExecutorDpuSize", defaultExecutorDpuSize())
                .add("AdditionalConfigs", hasAdditionalConfigs() ? additionalConfigs() : null)
                .add("SparkProperties", hasSparkProperties() ? sparkProperties() : null)
                .add("Classifications", hasClassifications() ? classifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoordinatorDpuSize":
            return Optional.ofNullable(clazz.cast(coordinatorDpuSize()));
        case "MaxConcurrentDpus":
            return Optional.ofNullable(clazz.cast(maxConcurrentDpus()));
        case "DefaultExecutorDpuSize":
            return Optional.ofNullable(clazz.cast(defaultExecutorDpuSize()));
        case "AdditionalConfigs":
            return Optional.ofNullable(clazz.cast(additionalConfigs()));
        case "SparkProperties":
            return Optional.ofNullable(clazz.cast(sparkProperties()));
        case "Classifications":
            return Optional.ofNullable(clazz.cast(classifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoordinatorDpuSize", COORDINATOR_DPU_SIZE_FIELD);
        map.put("MaxConcurrentDpus", MAX_CONCURRENT_DPUS_FIELD);
        map.put("DefaultExecutorDpuSize", DEFAULT_EXECUTOR_DPU_SIZE_FIELD);
        map.put("AdditionalConfigs", ADDITIONAL_CONFIGS_FIELD);
        map.put("SparkProperties", SPARK_PROPERTIES_FIELD);
        map.put("Classifications", CLASSIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngineConfiguration, T> g) {
        return obj -> g.apply((EngineConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineConfiguration> {
        /**
         * <p>
         * The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates
         * processing work and manages other executors in a notebook session. The default is 1.
         * </p>
         * 
         * @param coordinatorDpuSize
         *        The number of DPUs to use for the coordinator. A coordinator is a special executor that orchestrates
         *        processing work and manages other executors in a notebook session. The default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coordinatorDpuSize(Integer coordinatorDpuSize);

        /**
         * <p>
         * The maximum number of DPUs that can run concurrently.
         * </p>
         * 
         * @param maxConcurrentDpus
         *        The maximum number of DPUs that can run concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentDpus(Integer maxConcurrentDpus);

        /**
         * <p>
         * The default number of DPUs to use for executors. An executor is the smallest unit of compute that a notebook
         * session can request from Athena. The default is 1.
         * </p>
         * 
         * @param defaultExecutorDpuSize
         *        The default number of DPUs to use for executors. An executor is the smallest unit of compute that a
         *        notebook session can request from Athena. The default is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExecutorDpuSize(Integer defaultExecutorDpuSize);

        /**
         * <p>
         * Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of
         * key-value pairs. To specify an Athena notebook that the Jupyter server will download and serve, specify a
         * value for the <a>StartSessionRequest$NotebookVersion</a> field, and then add a key named
         * <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
         * </p>
         * 
         * @param additionalConfigs
         *        Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the
         *        form of key-value pairs. To specify an Athena notebook that the Jupyter server will download and
         *        serve, specify a value for the <a>StartSessionRequest$NotebookVersion</a> field, and then add a key
         *        named <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena
         *        notebook ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfigs(Map<String, String> additionalConfigs);

        /**
         * <p>
         * Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and
         * general Spark tuning.
         * </p>
         * 
         * @param sparkProperties
         *        Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats,
         *        and general Spark tuning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkProperties(Map<String, String> sparkProperties);

        /**
         * <p>
         * The configuration classifications that can be specified for the engine.
         * </p>
         * 
         * @param classifications
         *        The configuration classifications that can be specified for the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifications(Collection<Classification> classifications);

        /**
         * <p>
         * The configuration classifications that can be specified for the engine.
         * </p>
         * 
         * @param classifications
         *        The configuration classifications that can be specified for the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifications(Classification... classifications);

        /**
         * <p>
         * The configuration classifications that can be specified for the engine.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.Classification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.athena.model.Classification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.Classification.Builder#build()} is called immediately and
         * its result is passed to {@link #classifications(List<Classification>)}.
         * 
         * @param classifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.Classification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classifications(java.util.Collection<Classification>)
         */
        Builder classifications(Consumer<Classification.Builder>... classifications);
    }

    static final class BuilderImpl implements Builder {
        private Integer coordinatorDpuSize;

        private Integer maxConcurrentDpus;

        private Integer defaultExecutorDpuSize;

        private Map<String, String> additionalConfigs = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private List<Classification> classifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngineConfiguration model) {
            coordinatorDpuSize(model.coordinatorDpuSize);
            maxConcurrentDpus(model.maxConcurrentDpus);
            defaultExecutorDpuSize(model.defaultExecutorDpuSize);
            additionalConfigs(model.additionalConfigs);
            sparkProperties(model.sparkProperties);
            classifications(model.classifications);
        }

        public final Integer getCoordinatorDpuSize() {
            return coordinatorDpuSize;
        }

        public final void setCoordinatorDpuSize(Integer coordinatorDpuSize) {
            this.coordinatorDpuSize = coordinatorDpuSize;
        }

        @Override
        public final Builder coordinatorDpuSize(Integer coordinatorDpuSize) {
            this.coordinatorDpuSize = coordinatorDpuSize;
            return this;
        }

        public final Integer getMaxConcurrentDpus() {
            return maxConcurrentDpus;
        }

        public final void setMaxConcurrentDpus(Integer maxConcurrentDpus) {
            this.maxConcurrentDpus = maxConcurrentDpus;
        }

        @Override
        public final Builder maxConcurrentDpus(Integer maxConcurrentDpus) {
            this.maxConcurrentDpus = maxConcurrentDpus;
            return this;
        }

        public final Integer getDefaultExecutorDpuSize() {
            return defaultExecutorDpuSize;
        }

        public final void setDefaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
            this.defaultExecutorDpuSize = defaultExecutorDpuSize;
        }

        @Override
        public final Builder defaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
            this.defaultExecutorDpuSize = defaultExecutorDpuSize;
            return this;
        }

        public final Map<String, String> getAdditionalConfigs() {
            if (additionalConfigs instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalConfigs;
        }

        public final void setAdditionalConfigs(Map<String, String> additionalConfigs) {
            this.additionalConfigs = ParametersMapCopier.copy(additionalConfigs);
        }

        @Override
        public final Builder additionalConfigs(Map<String, String> additionalConfigs) {
            this.additionalConfigs = ParametersMapCopier.copy(additionalConfigs);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = ParametersMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = ParametersMapCopier.copy(sparkProperties);
            return this;
        }

        public final List<Classification.Builder> getClassifications() {
            List<Classification.Builder> result = ClassificationListCopier.copyToBuilder(this.classifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClassifications(Collection<Classification.BuilderImpl> classifications) {
            this.classifications = ClassificationListCopier.copyFromBuilder(classifications);
        }

        @Override
        public final Builder classifications(Collection<Classification> classifications) {
            this.classifications = ClassificationListCopier.copy(classifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifications(Classification... classifications) {
            classifications(Arrays.asList(classifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifications(Consumer<Classification.Builder>... classifications) {
            classifications(Stream.of(classifications).map(c -> Classification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EngineConfiguration build() {
            return new EngineConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
