/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionEndpointResponse extends AthenaResponse implements
        ToCopyableBuilder<GetSessionEndpointResponse.Builder, GetSessionEndpointResponse> {
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointUrl").getter(getter(GetSessionEndpointResponse::endpointUrl))
            .setter(setter(Builder::endpointUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(GetSessionEndpointResponse::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<Instant> AUTH_TOKEN_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AuthTokenExpirationTime").getter(getter(GetSessionEndpointResponse::authTokenExpirationTime))
            .setter(setter(Builder::authTokenExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenExpirationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_URL_FIELD,
            AUTH_TOKEN_FIELD, AUTH_TOKEN_EXPIRATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointUrl;

    private final String authToken;

    private final Instant authTokenExpirationTime;

    private GetSessionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointUrl = builder.endpointUrl;
        this.authToken = builder.authToken;
        this.authTokenExpirationTime = builder.authTokenExpirationTime;
    }

    /**
     * <p>
     * The endpoint for connecting to the session.
     * </p>
     * 
     * @return The endpoint for connecting to the session.
     */
    public final String endpointUrl() {
        return endpointUrl;
    }

    /**
     * <p>
     * Authentication token for the connection
     * </p>
     * 
     * @return Authentication token for the connection
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * Expiration time of the auth token.
     * </p>
     * 
     * @return Expiration time of the auth token.
     */
    public final Instant authTokenExpirationTime() {
        return authTokenExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionEndpointResponse)) {
            return false;
        }
        GetSessionEndpointResponse other = (GetSessionEndpointResponse) obj;
        return Objects.equals(endpointUrl(), other.endpointUrl()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(authTokenExpirationTime(), other.authTokenExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionEndpointResponse").add("EndpointUrl", endpointUrl()).add("AuthToken", authToken())
                .add("AuthTokenExpirationTime", authTokenExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointUrl":
            return Optional.ofNullable(clazz.cast(endpointUrl()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "AuthTokenExpirationTime":
            return Optional.ofNullable(clazz.cast(authTokenExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointUrl", ENDPOINT_URL_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        map.put("AuthTokenExpirationTime", AUTH_TOKEN_EXPIRATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionEndpointResponse, T> g) {
        return obj -> g.apply((GetSessionEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionEndpointResponse> {
        /**
         * <p>
         * The endpoint for connecting to the session.
         * </p>
         * 
         * @param endpointUrl
         *        The endpoint for connecting to the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUrl(String endpointUrl);

        /**
         * <p>
         * Authentication token for the connection
         * </p>
         * 
         * @param authToken
         *        Authentication token for the connection
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * Expiration time of the auth token.
         * </p>
         * 
         * @param authTokenExpirationTime
         *        Expiration time of the auth token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenExpirationTime(Instant authTokenExpirationTime);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String endpointUrl;

        private String authToken;

        private Instant authTokenExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionEndpointResponse model) {
            super(model);
            endpointUrl(model.endpointUrl);
            authToken(model.authToken);
            authTokenExpirationTime(model.authTokenExpirationTime);
        }

        public final String getEndpointUrl() {
            return endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Instant getAuthTokenExpirationTime() {
            return authTokenExpirationTime;
        }

        public final void setAuthTokenExpirationTime(Instant authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
        }

        @Override
        public final Builder authTokenExpirationTime(Instant authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
            return this;
        }

        @Override
        public GetSessionEndpointResponse build() {
            return new GetSessionEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
