/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon
 * CloudWatch log groups etc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfiguration.Builder, MonitoringConfiguration> {
    private static final SdkField<CloudWatchLoggingConfiguration> CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLoggingConfiguration")
            .getter(getter(MonitoringConfiguration::cloudWatchLoggingConfiguration))
            .setter(setter(Builder::cloudWatchLoggingConfiguration))
            .constructor(CloudWatchLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingConfiguration")
                    .build()).build();

    private static final SdkField<ManagedLoggingConfiguration> MANAGED_LOGGING_CONFIGURATION_FIELD = SdkField
            .<ManagedLoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ManagedLoggingConfiguration")
            .getter(getter(MonitoringConfiguration::managedLoggingConfiguration))
            .setter(setter(Builder::managedLoggingConfiguration))
            .constructor(ManagedLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedLoggingConfiguration")
                    .build()).build();

    private static final SdkField<S3LoggingConfiguration> S3_LOGGING_CONFIGURATION_FIELD = SdkField
            .<S3LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3LoggingConfiguration")
            .getter(getter(MonitoringConfiguration::s3LoggingConfiguration)).setter(setter(Builder::s3LoggingConfiguration))
            .constructor(S3LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3LoggingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD, MANAGED_LOGGING_CONFIGURATION_FIELD, S3_LOGGING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;

    private final ManagedLoggingConfiguration managedLoggingConfiguration;

    private final S3LoggingConfiguration s3LoggingConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
        this.managedLoggingConfiguration = builder.managedLoggingConfiguration;
        this.s3LoggingConfiguration = builder.s3LoggingConfiguration;
    }

    /**
     * <p>
     * Configuration settings for delivering logs to Amazon CloudWatch log groups.
     * </p>
     * 
     * @return Configuration settings for delivering logs to Amazon CloudWatch log groups.
     */
    public final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration() {
        return cloudWatchLoggingConfiguration;
    }

    /**
     * <p>
     * Configuration settings for managed log persistence.
     * </p>
     * 
     * @return Configuration settings for managed log persistence.
     */
    public final ManagedLoggingConfiguration managedLoggingConfiguration() {
        return managedLoggingConfiguration;
    }

    /**
     * <p>
     * Configuration settings for delivering logs to Amazon S3 buckets.
     * </p>
     * 
     * @return Configuration settings for delivering logs to Amazon S3 buckets.
     */
    public final S3LoggingConfiguration s3LoggingConfiguration() {
        return s3LoggingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(managedLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3LoggingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration) obj;
        return Objects.equals(cloudWatchLoggingConfiguration(), other.cloudWatchLoggingConfiguration())
                && Objects.equals(managedLoggingConfiguration(), other.managedLoggingConfiguration())
                && Objects.equals(s3LoggingConfiguration(), other.s3LoggingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfiguration")
                .add("CloudWatchLoggingConfiguration", cloudWatchLoggingConfiguration())
                .add("ManagedLoggingConfiguration", managedLoggingConfiguration())
                .add("S3LoggingConfiguration", s3LoggingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLoggingConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingConfiguration()));
        case "ManagedLoggingConfiguration":
            return Optional.ofNullable(clazz.cast(managedLoggingConfiguration()));
        case "S3LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(s3LoggingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLoggingConfiguration", CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD);
        map.put("ManagedLoggingConfiguration", MANAGED_LOGGING_CONFIGURATION_FIELD);
        map.put("S3LoggingConfiguration", S3_LOGGING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfiguration> {
        /**
         * <p>
         * Configuration settings for delivering logs to Amazon CloudWatch log groups.
         * </p>
         * 
         * @param cloudWatchLoggingConfiguration
         *        Configuration settings for delivering logs to Amazon CloudWatch log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration);

        /**
         * <p>
         * Configuration settings for delivering logs to Amazon CloudWatch log groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration)}.
         * 
         * @param cloudWatchLoggingConfiguration
         *        a consumer that will call methods on {@link CloudWatchLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration)
         */
        default Builder cloudWatchLoggingConfiguration(
                Consumer<CloudWatchLoggingConfiguration.Builder> cloudWatchLoggingConfiguration) {
            return cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration.builder()
                    .applyMutation(cloudWatchLoggingConfiguration).build());
        }

        /**
         * <p>
         * Configuration settings for managed log persistence.
         * </p>
         * 
         * @param managedLoggingConfiguration
         *        Configuration settings for managed log persistence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedLoggingConfiguration(ManagedLoggingConfiguration managedLoggingConfiguration);

        /**
         * <p>
         * Configuration settings for managed log persistence.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ManagedLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedLoggingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #managedLoggingConfiguration(ManagedLoggingConfiguration)}.
         * 
         * @param managedLoggingConfiguration
         *        a consumer that will call methods on {@link ManagedLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedLoggingConfiguration(ManagedLoggingConfiguration)
         */
        default Builder managedLoggingConfiguration(Consumer<ManagedLoggingConfiguration.Builder> managedLoggingConfiguration) {
            return managedLoggingConfiguration(ManagedLoggingConfiguration.builder().applyMutation(managedLoggingConfiguration)
                    .build());
        }

        /**
         * <p>
         * Configuration settings for delivering logs to Amazon S3 buckets.
         * </p>
         * 
         * @param s3LoggingConfiguration
         *        Configuration settings for delivering logs to Amazon S3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3LoggingConfiguration(S3LoggingConfiguration s3LoggingConfiguration);

        /**
         * <p>
         * Configuration settings for delivering logs to Amazon S3 buckets.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3LoggingConfiguration(S3LoggingConfiguration)}.
         * 
         * @param s3LoggingConfiguration
         *        a consumer that will call methods on {@link S3LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3LoggingConfiguration(S3LoggingConfiguration)
         */
        default Builder s3LoggingConfiguration(Consumer<S3LoggingConfiguration.Builder> s3LoggingConfiguration) {
            return s3LoggingConfiguration(S3LoggingConfiguration.builder().applyMutation(s3LoggingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;

        private ManagedLoggingConfiguration managedLoggingConfiguration;

        private S3LoggingConfiguration s3LoggingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            cloudWatchLoggingConfiguration(model.cloudWatchLoggingConfiguration);
            managedLoggingConfiguration(model.managedLoggingConfiguration);
            s3LoggingConfiguration(model.s3LoggingConfiguration);
        }

        public final CloudWatchLoggingConfiguration.Builder getCloudWatchLoggingConfiguration() {
            return cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLoggingConfiguration(
                CloudWatchLoggingConfiguration.BuilderImpl cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
            return this;
        }

        public final ManagedLoggingConfiguration.Builder getManagedLoggingConfiguration() {
            return managedLoggingConfiguration != null ? managedLoggingConfiguration.toBuilder() : null;
        }

        public final void setManagedLoggingConfiguration(ManagedLoggingConfiguration.BuilderImpl managedLoggingConfiguration) {
            this.managedLoggingConfiguration = managedLoggingConfiguration != null ? managedLoggingConfiguration.build() : null;
        }

        @Override
        public final Builder managedLoggingConfiguration(ManagedLoggingConfiguration managedLoggingConfiguration) {
            this.managedLoggingConfiguration = managedLoggingConfiguration;
            return this;
        }

        public final S3LoggingConfiguration.Builder getS3LoggingConfiguration() {
            return s3LoggingConfiguration != null ? s3LoggingConfiguration.toBuilder() : null;
        }

        public final void setS3LoggingConfiguration(S3LoggingConfiguration.BuilderImpl s3LoggingConfiguration) {
            this.s3LoggingConfiguration = s3LoggingConfiguration != null ? s3LoggingConfiguration.build() : null;
        }

        @Override
        public final Builder s3LoggingConfiguration(S3LoggingConfiguration s3LoggingConfiguration) {
            this.s3LoggingConfiguration = s3LoggingConfiguration;
            return this;
        }

        @Override
        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
