/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of data scanned during the query execution and the amount of time that it took to execute, and the type of
 * statement that was run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryExecutionStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryExecutionStatistics.Builder, QueryExecutionStatistics> {
    private static final SdkField<Long> ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EngineExecutionTimeInMillis")
            .getter(getter(QueryExecutionStatistics::engineExecutionTimeInMillis))
            .setter(setter(Builder::engineExecutionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineExecutionTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> DATA_SCANNED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataScannedInBytes").getter(getter(QueryExecutionStatistics::dataScannedInBytes))
            .setter(setter(Builder::dataScannedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedInBytes").build())
            .build();

    private static final SdkField<String> DATA_MANIFEST_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataManifestLocation").getter(getter(QueryExecutionStatistics::dataManifestLocation))
            .setter(setter(Builder::dataManifestLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataManifestLocation").build())
            .build();

    private static final SdkField<Long> TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalExecutionTimeInMillis")
            .getter(getter(QueryExecutionStatistics::totalExecutionTimeInMillis))
            .setter(setter(Builder::totalExecutionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExecutionTimeInMillis").build())
            .build();

    private static final SdkField<Long> QUERY_QUEUE_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryQueueTimeInMillis").getter(getter(QueryExecutionStatistics::queryQueueTimeInMillis))
            .setter(setter(Builder::queryQueueTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryQueueTimeInMillis").build())
            .build();

    private static final SdkField<Long> SERVICE_PRE_PROCESSING_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ServicePreProcessingTimeInMillis")
            .getter(getter(QueryExecutionStatistics::servicePreProcessingTimeInMillis))
            .setter(setter(Builder::servicePreProcessingTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePreProcessingTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> QUERY_PLANNING_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryPlanningTimeInMillis").getter(getter(QueryExecutionStatistics::queryPlanningTimeInMillis))
            .setter(setter(Builder::queryPlanningTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPlanningTimeInMillis").build())
            .build();

    private static final SdkField<Long> SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ServiceProcessingTimeInMillis")
            .getter(getter(QueryExecutionStatistics::serviceProcessingTimeInMillis))
            .setter(setter(Builder::serviceProcessingTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProcessingTimeInMillis")
                    .build()).build();

    private static final SdkField<ResultReuseInformation> RESULT_REUSE_INFORMATION_FIELD = SdkField
            .<ResultReuseInformation> builder(MarshallingType.SDK_POJO).memberName("ResultReuseInformation")
            .getter(getter(QueryExecutionStatistics::resultReuseInformation)).setter(setter(Builder::resultReuseInformation))
            .constructor(ResultReuseInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultReuseInformation").build())
            .build();

    private static final SdkField<Double> DPU_COUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DpuCount").getter(getter(QueryExecutionStatistics::dpuCount)).setter(setter(Builder::dpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpuCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD, DATA_SCANNED_IN_BYTES_FIELD, DATA_MANIFEST_LOCATION_FIELD,
            TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD, QUERY_QUEUE_TIME_IN_MILLIS_FIELD, SERVICE_PRE_PROCESSING_TIME_IN_MILLIS_FIELD,
            QUERY_PLANNING_TIME_IN_MILLIS_FIELD, SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD, RESULT_REUSE_INFORMATION_FIELD,
            DPU_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long engineExecutionTimeInMillis;

    private final Long dataScannedInBytes;

    private final String dataManifestLocation;

    private final Long totalExecutionTimeInMillis;

    private final Long queryQueueTimeInMillis;

    private final Long servicePreProcessingTimeInMillis;

    private final Long queryPlanningTimeInMillis;

    private final Long serviceProcessingTimeInMillis;

    private final ResultReuseInformation resultReuseInformation;

    private final Double dpuCount;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
        this.dataManifestLocation = builder.dataManifestLocation;
        this.totalExecutionTimeInMillis = builder.totalExecutionTimeInMillis;
        this.queryQueueTimeInMillis = builder.queryQueueTimeInMillis;
        this.servicePreProcessingTimeInMillis = builder.servicePreProcessingTimeInMillis;
        this.queryPlanningTimeInMillis = builder.queryPlanningTimeInMillis;
        this.serviceProcessingTimeInMillis = builder.serviceProcessingTimeInMillis;
        this.resultReuseInformation = builder.resultReuseInformation;
        this.dpuCount = builder.dpuCount;
    }

    /**
     * <p>
     * The number of milliseconds that the query took to execute.
     * </p>
     * 
     * @return The number of milliseconds that the query took to execute.
     */
    public final Long engineExecutionTimeInMillis() {
        return engineExecutionTimeInMillis;
    }

    /**
     * <p>
     * The number of bytes in the data that was queried.
     * </p>
     * 
     * @return The number of bytes in the data that was queried.
     */
    public final Long dataScannedInBytes() {
        return dataScannedInBytes;
    }

    /**
     * <p>
     * The location and file name of a data manifest file. The manifest file is saved to the Athena query results
     * location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails, the
     * manifest file also tracks files that the query intended to write. The manifest is useful for identifying orphaned
     * files resulting from a failed query. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files, and
     * Query History</a> in the <i>Amazon Athena User Guide</i>.
     * </p>
     * 
     * @return The location and file name of a data manifest file. The manifest file is saved to the Athena query
     *         results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the
     *         query fails, the manifest file also tracks files that the query intended to write. The manifest is useful
     *         for identifying orphaned files resulting from a failed query. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output
     *         Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.
     */
    public final String dataManifestLocation() {
        return dataManifestLocation;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to run the query.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to run the query.
     */
    public final Long totalExecutionTimeInMillis() {
        return totalExecutionTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient
     * errors occur, Athena might automatically add the query back to the queue.
     * </p>
     * 
     * @return The number of milliseconds that the query was in your query queue waiting for resources. Note that if
     *         transient errors occur, Athena might automatically add the query back to the queue.
     */
    public final Long queryQueueTimeInMillis() {
        return queryQueueTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to preprocess the query before submitting the query to the query
     * engine.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to preprocess the query before submitting the query to the
     *         query engine.
     */
    public final Long servicePreProcessingTimeInMillis() {
        return servicePreProcessingTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent
     * retrieving table partitions from the data source. Note that because the query engine performs the query planning,
     * query planning time is a subset of engine processing time.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to plan the query processing flow. This includes the time
     *         spent retrieving table partitions from the data source. Note that because the query engine performs the
     *         query planning, query planning time is a subset of engine processing time.
     */
    public final Long queryPlanningTimeInMillis() {
        return queryPlanningTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to finalize and publish the query results after the query engine
     * finished running the query.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to finalize and publish the query results after the query
     *         engine finished running the query.
     */
    public final Long serviceProcessingTimeInMillis() {
        return serviceProcessingTimeInMillis;
    }

    /**
     * <p>
     * Contains information about whether previous query results were reused for the query.
     * </p>
     * 
     * @return Contains information about whether previous query results were reused for the query.
     */
    public final ResultReuseInformation resultReuseInformation() {
        return resultReuseInformation;
    }

    /**
     * <p>
     * The number of Data Processing Units (DPUs) that Athena used to run the query.
     * </p>
     * 
     * @return The number of Data Processing Units (DPUs) that Athena used to run the query.
     */
    public final Double dpuCount() {
        return dpuCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(dataScannedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(dataManifestLocation());
        hashCode = 31 * hashCode + Objects.hashCode(totalExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(queryQueueTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(servicePreProcessingTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(queryPlanningTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProcessingTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(resultReuseInformation());
        hashCode = 31 * hashCode + Objects.hashCode(dpuCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics) obj;
        return Objects.equals(engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis())
                && Objects.equals(dataScannedInBytes(), other.dataScannedInBytes())
                && Objects.equals(dataManifestLocation(), other.dataManifestLocation())
                && Objects.equals(totalExecutionTimeInMillis(), other.totalExecutionTimeInMillis())
                && Objects.equals(queryQueueTimeInMillis(), other.queryQueueTimeInMillis())
                && Objects.equals(servicePreProcessingTimeInMillis(), other.servicePreProcessingTimeInMillis())
                && Objects.equals(queryPlanningTimeInMillis(), other.queryPlanningTimeInMillis())
                && Objects.equals(serviceProcessingTimeInMillis(), other.serviceProcessingTimeInMillis())
                && Objects.equals(resultReuseInformation(), other.resultReuseInformation())
                && Objects.equals(dpuCount(), other.dpuCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryExecutionStatistics").add("EngineExecutionTimeInMillis", engineExecutionTimeInMillis())
                .add("DataScannedInBytes", dataScannedInBytes()).add("DataManifestLocation", dataManifestLocation())
                .add("TotalExecutionTimeInMillis", totalExecutionTimeInMillis())
                .add("QueryQueueTimeInMillis", queryQueueTimeInMillis())
                .add("ServicePreProcessingTimeInMillis", servicePreProcessingTimeInMillis())
                .add("QueryPlanningTimeInMillis", queryPlanningTimeInMillis())
                .add("ServiceProcessingTimeInMillis", serviceProcessingTimeInMillis())
                .add("ResultReuseInformation", resultReuseInformation()).add("DpuCount", dpuCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(engineExecutionTimeInMillis()));
        case "DataScannedInBytes":
            return Optional.ofNullable(clazz.cast(dataScannedInBytes()));
        case "DataManifestLocation":
            return Optional.ofNullable(clazz.cast(dataManifestLocation()));
        case "TotalExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(totalExecutionTimeInMillis()));
        case "QueryQueueTimeInMillis":
            return Optional.ofNullable(clazz.cast(queryQueueTimeInMillis()));
        case "ServicePreProcessingTimeInMillis":
            return Optional.ofNullable(clazz.cast(servicePreProcessingTimeInMillis()));
        case "QueryPlanningTimeInMillis":
            return Optional.ofNullable(clazz.cast(queryPlanningTimeInMillis()));
        case "ServiceProcessingTimeInMillis":
            return Optional.ofNullable(clazz.cast(serviceProcessingTimeInMillis()));
        case "ResultReuseInformation":
            return Optional.ofNullable(clazz.cast(resultReuseInformation()));
        case "DpuCount":
            return Optional.ofNullable(clazz.cast(dpuCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngineExecutionTimeInMillis", ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD);
        map.put("DataScannedInBytes", DATA_SCANNED_IN_BYTES_FIELD);
        map.put("DataManifestLocation", DATA_MANIFEST_LOCATION_FIELD);
        map.put("TotalExecutionTimeInMillis", TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD);
        map.put("QueryQueueTimeInMillis", QUERY_QUEUE_TIME_IN_MILLIS_FIELD);
        map.put("ServicePreProcessingTimeInMillis", SERVICE_PRE_PROCESSING_TIME_IN_MILLIS_FIELD);
        map.put("QueryPlanningTimeInMillis", QUERY_PLANNING_TIME_IN_MILLIS_FIELD);
        map.put("ServiceProcessingTimeInMillis", SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD);
        map.put("ResultReuseInformation", RESULT_REUSE_INFORMATION_FIELD);
        map.put("DpuCount", DPU_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatistics, T> g) {
        return obj -> g.apply((QueryExecutionStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryExecutionStatistics> {
        /**
         * <p>
         * The number of milliseconds that the query took to execute.
         * </p>
         * 
         * @param engineExecutionTimeInMillis
         *        The number of milliseconds that the query took to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis);

        /**
         * <p>
         * The number of bytes in the data that was queried.
         * </p>
         * 
         * @param dataScannedInBytes
         *        The number of bytes in the data that was queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataScannedInBytes(Long dataScannedInBytes);

        /**
         * <p>
         * The location and file name of a data manifest file. The manifest file is saved to the Athena query results
         * location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If the query fails,
         * the manifest file also tracks files that the query intended to write. The manifest is useful for identifying
         * orphaned files resulting from a failed query. For more information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output Files,
         * and Query History</a> in the <i>Amazon Athena User Guide</i>.
         * </p>
         * 
         * @param dataManifestLocation
         *        The location and file name of a data manifest file. The manifest file is saved to the Athena query
         *        results location in Amazon S3. The manifest file tracks files that the query wrote to Amazon S3. If
         *        the query fails, the manifest file also tracks files that the query intended to write. The manifest is
         *        useful for identifying orphaned files resulting from a failed query. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query Results, Output
         *        Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataManifestLocation(String dataManifestLocation);

        /**
         * <p>
         * The number of milliseconds that Athena took to run the query.
         * </p>
         * 
         * @param totalExecutionTimeInMillis
         *        The number of milliseconds that Athena took to run the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalExecutionTimeInMillis(Long totalExecutionTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that the query was in your query queue waiting for resources. Note that if
         * transient errors occur, Athena might automatically add the query back to the queue.
         * </p>
         * 
         * @param queryQueueTimeInMillis
         *        The number of milliseconds that the query was in your query queue waiting for resources. Note that if
         *        transient errors occur, Athena might automatically add the query back to the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryQueueTimeInMillis(Long queryQueueTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to preprocess the query before submitting the query to the query
         * engine.
         * </p>
         * 
         * @param servicePreProcessingTimeInMillis
         *        The number of milliseconds that Athena took to preprocess the query before submitting the query to the
         *        query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent
         * retrieving table partitions from the data source. Note that because the query engine performs the query
         * planning, query planning time is a subset of engine processing time.
         * </p>
         * 
         * @param queryPlanningTimeInMillis
         *        The number of milliseconds that Athena took to plan the query processing flow. This includes the time
         *        spent retrieving table partitions from the data source. Note that because the query engine performs
         *        the query planning, query planning time is a subset of engine processing time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryPlanningTimeInMillis(Long queryPlanningTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to finalize and publish the query results after the query engine
         * finished running the query.
         * </p>
         * 
         * @param serviceProcessingTimeInMillis
         *        The number of milliseconds that Athena took to finalize and publish the query results after the query
         *        engine finished running the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProcessingTimeInMillis(Long serviceProcessingTimeInMillis);

        /**
         * <p>
         * Contains information about whether previous query results were reused for the query.
         * </p>
         * 
         * @param resultReuseInformation
         *        Contains information about whether previous query results were reused for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultReuseInformation(ResultReuseInformation resultReuseInformation);

        /**
         * <p>
         * Contains information about whether previous query results were reused for the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultReuseInformation.Builder} avoiding
         * the need to create one manually via {@link ResultReuseInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultReuseInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #resultReuseInformation(ResultReuseInformation)}.
         * 
         * @param resultReuseInformation
         *        a consumer that will call methods on {@link ResultReuseInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultReuseInformation(ResultReuseInformation)
         */
        default Builder resultReuseInformation(Consumer<ResultReuseInformation.Builder> resultReuseInformation) {
            return resultReuseInformation(ResultReuseInformation.builder().applyMutation(resultReuseInformation).build());
        }

        /**
         * <p>
         * The number of Data Processing Units (DPUs) that Athena used to run the query.
         * </p>
         * 
         * @param dpuCount
         *        The number of Data Processing Units (DPUs) that Athena used to run the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuCount(Double dpuCount);
    }

    static final class BuilderImpl implements Builder {
        private Long engineExecutionTimeInMillis;

        private Long dataScannedInBytes;

        private String dataManifestLocation;

        private Long totalExecutionTimeInMillis;

        private Long queryQueueTimeInMillis;

        private Long servicePreProcessingTimeInMillis;

        private Long queryPlanningTimeInMillis;

        private Long serviceProcessingTimeInMillis;

        private ResultReuseInformation resultReuseInformation;

        private Double dpuCount;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            dataScannedInBytes(model.dataScannedInBytes);
            dataManifestLocation(model.dataManifestLocation);
            totalExecutionTimeInMillis(model.totalExecutionTimeInMillis);
            queryQueueTimeInMillis(model.queryQueueTimeInMillis);
            servicePreProcessingTimeInMillis(model.servicePreProcessingTimeInMillis);
            queryPlanningTimeInMillis(model.queryPlanningTimeInMillis);
            serviceProcessingTimeInMillis(model.serviceProcessingTimeInMillis);
            resultReuseInformation(model.resultReuseInformation);
            dpuCount(model.dpuCount);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return engineExecutionTimeInMillis;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final Long getDataScannedInBytes() {
            return dataScannedInBytes;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final String getDataManifestLocation() {
            return dataManifestLocation;
        }

        public final void setDataManifestLocation(String dataManifestLocation) {
            this.dataManifestLocation = dataManifestLocation;
        }

        @Override
        public final Builder dataManifestLocation(String dataManifestLocation) {
            this.dataManifestLocation = dataManifestLocation;
            return this;
        }

        public final Long getTotalExecutionTimeInMillis() {
            return totalExecutionTimeInMillis;
        }

        public final void setTotalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
        }

        @Override
        public final Builder totalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
            return this;
        }

        public final Long getQueryQueueTimeInMillis() {
            return queryQueueTimeInMillis;
        }

        public final void setQueryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
        }

        @Override
        public final Builder queryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
            return this;
        }

        public final Long getServicePreProcessingTimeInMillis() {
            return servicePreProcessingTimeInMillis;
        }

        public final void setServicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis) {
            this.servicePreProcessingTimeInMillis = servicePreProcessingTimeInMillis;
        }

        @Override
        public final Builder servicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis) {
            this.servicePreProcessingTimeInMillis = servicePreProcessingTimeInMillis;
            return this;
        }

        public final Long getQueryPlanningTimeInMillis() {
            return queryPlanningTimeInMillis;
        }

        public final void setQueryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
        }

        @Override
        public final Builder queryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
            return this;
        }

        public final Long getServiceProcessingTimeInMillis() {
            return serviceProcessingTimeInMillis;
        }

        public final void setServiceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
        }

        @Override
        public final Builder serviceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
            return this;
        }

        public final ResultReuseInformation.Builder getResultReuseInformation() {
            return resultReuseInformation != null ? resultReuseInformation.toBuilder() : null;
        }

        public final void setResultReuseInformation(ResultReuseInformation.BuilderImpl resultReuseInformation) {
            this.resultReuseInformation = resultReuseInformation != null ? resultReuseInformation.build() : null;
        }

        @Override
        public final Builder resultReuseInformation(ResultReuseInformation resultReuseInformation) {
            this.resultReuseInformation = resultReuseInformation;
            return this;
        }

        public final Double getDpuCount() {
            return dpuCount;
        }

        public final void setDpuCount(Double dpuCount) {
            this.dpuCount = dpuCount;
        }

        @Override
        public final Builder dpuCount(Double dpuCount) {
            this.dpuCount = dpuCount;
            return this;
        }

        @Override
        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
