/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The completion date, current state, submission time, and state change reason (if applicable) for the query execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryExecutionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryExecutionStatus.Builder, QueryExecutionStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(QueryExecutionStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_CHANGE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateChangeReason").getter(getter(QueryExecutionStatus::stateChangeReason))
            .setter(setter(Builder::stateChangeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<Instant> SUBMISSION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmissionDateTime").getter(getter(QueryExecutionStatus::submissionDateTime))
            .setter(setter(Builder::submissionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionDateTime").build())
            .build();

    private static final SdkField<Instant> COMPLETION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDateTime").getter(getter(QueryExecutionStatus::completionDateTime))
            .setter(setter(Builder::completionDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDateTime").build())
            .build();

    private static final SdkField<AthenaError> ATHENA_ERROR_FIELD = SdkField.<AthenaError> builder(MarshallingType.SDK_POJO)
            .memberName("AthenaError").getter(getter(QueryExecutionStatus::athenaError)).setter(setter(Builder::athenaError))
            .constructor(AthenaError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, SUBMISSION_DATE_TIME_FIELD, COMPLETION_DATE_TIME_FIELD, ATHENA_ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String stateChangeReason;

    private final Instant submissionDateTime;

    private final Instant completionDateTime;

    private final AthenaError athenaError;

    private QueryExecutionStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.submissionDateTime = builder.submissionDateTime;
        this.completionDateTime = builder.completionDateTime;
        this.athenaError = builder.athenaError;
    }

    /**
     * <p>
     * The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service, and
     * Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the query
     * is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
     * <code>FAILED</code> indicates that the query experienced an error and did not complete processing.
     * <code>CANCELLED</code> indicates that a user input interrupted query execution.
     * </p>
     * <note>
     * <p>
     * For queries that experience certain transient errors, the state transitions from <code>RUNNING</code> back to
     * <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the
     *         service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code>
     *         indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed
     *         without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete
     *         processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.</p> <note>
     *         <p>
     *         For queries that experience certain transient errors, the state transitions from <code>RUNNING</code>
     *         back to <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
     *         </p>
     * @see QueryExecutionState
     */
    public final QueryExecutionState state() {
        return QueryExecutionState.fromValue(state);
    }

    /**
     * <p>
     * The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service, and
     * Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the query
     * is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
     * <code>FAILED</code> indicates that the query experienced an error and did not complete processing.
     * <code>CANCELLED</code> indicates that a user input interrupted query execution.
     * </p>
     * <note>
     * <p>
     * For queries that experience certain transient errors, the state transitions from <code>RUNNING</code> back to
     * <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the
     *         service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code>
     *         indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed
     *         without errors. <code>FAILED</code> indicates that the query experienced an error and did not complete
     *         processing. <code>CANCELLED</code> indicates that a user input interrupted query execution.</p> <note>
     *         <p>
     *         For queries that experience certain transient errors, the state transitions from <code>RUNNING</code>
     *         back to <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
     *         </p>
     * @see QueryExecutionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Further detail about the status of the query.
     * </p>
     * 
     * @return Further detail about the status of the query.
     */
    public final String stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The date and time that the query was submitted.
     * </p>
     * 
     * @return The date and time that the query was submitted.
     */
    public final Instant submissionDateTime() {
        return submissionDateTime;
    }

    /**
     * <p>
     * The date and time that the query completed.
     * </p>
     * 
     * @return The date and time that the query completed.
     */
    public final Instant completionDateTime() {
        return completionDateTime;
    }

    /**
     * <p>
     * Provides information about an Athena query error.
     * </p>
     * 
     * @return Provides information about an Athena query error.
     */
    public final AthenaError athenaError() {
        return athenaError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(submissionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(athenaError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatus)) {
            return false;
        }
        QueryExecutionStatus other = (QueryExecutionStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason())
                && Objects.equals(submissionDateTime(), other.submissionDateTime())
                && Objects.equals(completionDateTime(), other.completionDateTime())
                && Objects.equals(athenaError(), other.athenaError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryExecutionStatus").add("State", stateAsString())
                .add("StateChangeReason", stateChangeReason()).add("SubmissionDateTime", submissionDateTime())
                .add("CompletionDateTime", completionDateTime()).add("AthenaError", athenaError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "SubmissionDateTime":
            return Optional.ofNullable(clazz.cast(submissionDateTime()));
        case "CompletionDateTime":
            return Optional.ofNullable(clazz.cast(completionDateTime()));
        case "AthenaError":
            return Optional.ofNullable(clazz.cast(athenaError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("SubmissionDateTime", SUBMISSION_DATE_TIME_FIELD);
        map.put("CompletionDateTime", COMPLETION_DATE_TIME_FIELD);
        map.put("AthenaError", ATHENA_ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryExecutionStatus, T> g) {
        return obj -> g.apply((QueryExecutionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryExecutionStatus> {
        /**
         * <p>
         * The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service,
         * and Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the
         * query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
         * <code>FAILED</code> indicates that the query experienced an error and did not complete processing.
         * <code>CANCELLED</code> indicates that a user input interrupted query execution.
         * </p>
         * <note>
         * <p>
         * For queries that experience certain transient errors, the state transitions from <code>RUNNING</code> back to
         * <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
         * </p>
         * </note>
         * 
         * @param state
         *        The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the
         *        service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code>
         *        indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query
         *        completed without errors. <code>FAILED</code> indicates that the query experienced an error and did
         *        not complete processing. <code>CANCELLED</code> indicates that a user input interrupted query
         *        execution.</p> <note>
         *        <p>
         *        For queries that experience certain transient errors, the state transitions from <code>RUNNING</code>
         *        back to <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
         *        </p>
         * @see QueryExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the service,
         * and Athena will execute the query as soon as resources are available. <code>RUNNING</code> indicates that the
         * query is in execution phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
         * <code>FAILED</code> indicates that the query experienced an error and did not complete processing.
         * <code>CANCELLED</code> indicates that a user input interrupted query execution.
         * </p>
         * <note>
         * <p>
         * For queries that experience certain transient errors, the state transitions from <code>RUNNING</code> back to
         * <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
         * </p>
         * </note>
         * 
         * @param state
         *        The state of query execution. <code>QUEUED</code> indicates that the query has been submitted to the
         *        service, and Athena will execute the query as soon as resources are available. <code>RUNNING</code>
         *        indicates that the query is in execution phase. <code>SUCCEEDED</code> indicates that the query
         *        completed without errors. <code>FAILED</code> indicates that the query experienced an error and did
         *        not complete processing. <code>CANCELLED</code> indicates that a user input interrupted query
         *        execution.</p> <note>
         *        <p>
         *        For queries that experience certain transient errors, the state transitions from <code>RUNNING</code>
         *        back to <code>QUEUED</code>. The <code>FAILED</code> state is always terminal with no automatic retry.
         *        </p>
         * @see QueryExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryExecutionState
         */
        Builder state(QueryExecutionState state);

        /**
         * <p>
         * Further detail about the status of the query.
         * </p>
         * 
         * @param stateChangeReason
         *        Further detail about the status of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(String stateChangeReason);

        /**
         * <p>
         * The date and time that the query was submitted.
         * </p>
         * 
         * @param submissionDateTime
         *        The date and time that the query was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionDateTime(Instant submissionDateTime);

        /**
         * <p>
         * The date and time that the query completed.
         * </p>
         * 
         * @param completionDateTime
         *        The date and time that the query completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDateTime(Instant completionDateTime);

        /**
         * <p>
         * Provides information about an Athena query error.
         * </p>
         * 
         * @param athenaError
         *        Provides information about an Athena query error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaError(AthenaError athenaError);

        /**
         * <p>
         * Provides information about an Athena query error.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaError.Builder} avoiding the need to
         * create one manually via {@link AthenaError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaError.Builder#build()} is called immediately and its result
         * is passed to {@link #athenaError(AthenaError)}.
         * 
         * @param athenaError
         *        a consumer that will call methods on {@link AthenaError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaError(AthenaError)
         */
        default Builder athenaError(Consumer<AthenaError.Builder> athenaError) {
            return athenaError(AthenaError.builder().applyMutation(athenaError).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String stateChangeReason;

        private Instant submissionDateTime;

        private Instant completionDateTime;

        private AthenaError athenaError;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            submissionDateTime(model.submissionDateTime);
            completionDateTime(model.completionDateTime);
            athenaError(model.athenaError);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateChangeReason() {
            return stateChangeReason;
        }

        public final void setStateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(String stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final Instant getSubmissionDateTime() {
            return submissionDateTime;
        }

        public final void setSubmissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
        }

        @Override
        public final Builder submissionDateTime(Instant submissionDateTime) {
            this.submissionDateTime = submissionDateTime;
            return this;
        }

        public final Instant getCompletionDateTime() {
            return completionDateTime;
        }

        public final void setCompletionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
        }

        @Override
        public final Builder completionDateTime(Instant completionDateTime) {
            this.completionDateTime = completionDateTime;
            return this;
        }

        public final AthenaError.Builder getAthenaError() {
            return athenaError != null ? athenaError.toBuilder() : null;
        }

        public final void setAthenaError(AthenaError.BuilderImpl athenaError) {
            this.athenaError = athenaError != null ? athenaError.build() : null;
        }

        @Override
        public final Builder athenaError(AthenaError athenaError) {
            this.athenaError = athenaError;
            return this;
        }

        @Override
        public QueryExecutionStatus build() {
            return new QueryExecutionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
