/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for delivering logs to Amazon S3 buckets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3LoggingConfiguration.Builder, S3LoggingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(S3LoggingConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsKey")
            .getter(getter(S3LoggingConfiguration::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()).build();

    private static final SdkField<String> LOG_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLocation").getter(getter(S3LoggingConfiguration::logLocation)).setter(setter(Builder::logLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, KMS_KEY_FIELD,
            LOG_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String kmsKey;

    private final String logLocation;

    private S3LoggingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.kmsKey = builder.kmsKey;
        this.logLocation = builder.logLocation;
    }

    /**
     * <p>
     * Enables S3 log delivery.
     * </p>
     * 
     * @return Enables S3 log delivery.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
     * </p>
     * 
     * @return The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The Amazon S3 destination URI for log publishing.
     * </p>
     * 
     * @return The Amazon S3 destination URI for log publishing.
     */
    public final String logLocation() {
        return logLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(logLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LoggingConfiguration)) {
            return false;
        }
        S3LoggingConfiguration other = (S3LoggingConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(logLocation(), other.logLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LoggingConfiguration").add("Enabled", enabled()).add("KmsKey", kmsKey())
                .add("LogLocation", logLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "KmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "LogLocation":
            return Optional.ofNullable(clazz.cast(logLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("LogLocation", LOG_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3LoggingConfiguration, T> g) {
        return obj -> g.apply((S3LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LoggingConfiguration> {
        /**
         * <p>
         * Enables S3 log delivery.
         * </p>
         * 
         * @param enabled
         *        Enables S3 log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The Amazon S3 destination URI for log publishing.
         * </p>
         * 
         * @param logLocation
         *        The Amazon S3 destination URI for log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logLocation(String logLocation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String kmsKey;

        private String logLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LoggingConfiguration model) {
            enabled(model.enabled);
            kmsKey(model.kmsKey);
            logLocation(model.logLocation);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getLogLocation() {
            return logLocation;
        }

        public final void setLogLocation(String logLocation) {
            this.logLocation = logLocation;
        }

        @Override
        public final Builder logLocation(String logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        @Override
        public S3LoggingConfiguration build() {
            return new S3LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
