/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains session configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionConfiguration.Builder, SessionConfiguration> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(SessionConfiguration::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkingDirectory").getter(getter(SessionConfiguration::workingDirectory))
            .setter(setter(Builder::workingDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()).build();

    private static final SdkField<Long> IDLE_TIMEOUT_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("IdleTimeoutSeconds").getter(getter(SessionConfiguration::idleTimeoutSeconds))
            .setter(setter(Builder::idleTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionIdleTimeoutInMinutes")
            .getter(getter(SessionConfiguration::sessionIdleTimeoutInMinutes))
            .setter(setter(Builder::sessionIdleTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionIdleTimeoutInMinutes")
                    .build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfiguration")
            .getter(getter(SessionConfiguration::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD,
            WORKING_DIRECTORY_FIELD, IDLE_TIMEOUT_SECONDS_FIELD, SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionRole;

    private final String workingDirectory;

    private final Long idleTimeoutSeconds;

    private final Integer sessionIdleTimeoutInMinutes;

    private final EncryptionConfiguration encryptionConfiguration;

    private SessionConfiguration(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.workingDirectory = builder.workingDirectory;
        this.idleTimeoutSeconds = builder.idleTimeoutSeconds;
        this.sessionIdleTimeoutInMinutes = builder.sessionIdleTimeoutInMinutes;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled
     * workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
     * </p>
     * 
     * @return The ARN of the execution role used to access user resources for Spark sessions and Identity Center
     *         enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled
     *         workgroups.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The Amazon S3 location that stores information for the notebook.
     * </p>
     * 
     * @return The Amazon S3 location that stores information for the notebook.
     */
    public final String workingDirectory() {
        return workingDirectory;
    }

    /**
     * <p>
     * The idle timeout in seconds for the session.
     * </p>
     * 
     * @return The idle timeout in seconds for the session.
     */
    public final Long idleTimeoutSeconds() {
        return idleTimeoutSeconds;
    }

    /**
     * <p>
     * The idle timeout in seconds for the session.
     * </p>
     * 
     * @return The idle timeout in seconds for the session.
     */
    public final Integer sessionIdleTimeoutInMinutes() {
        return sessionIdleTimeoutInMinutes;
    }

    /**
     * Returns the value of the EncryptionConfiguration property for this object.
     * 
     * @return The value of the EncryptionConfiguration property for this object.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdleTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionConfiguration)) {
            return false;
        }
        SessionConfiguration other = (SessionConfiguration) obj;
        return Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(workingDirectory(), other.workingDirectory())
                && Objects.equals(idleTimeoutSeconds(), other.idleTimeoutSeconds())
                && Objects.equals(sessionIdleTimeoutInMinutes(), other.sessionIdleTimeoutInMinutes())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionConfiguration").add("ExecutionRole", executionRole())
                .add("WorkingDirectory", workingDirectory()).add("IdleTimeoutSeconds", idleTimeoutSeconds())
                .add("SessionIdleTimeoutInMinutes", sessionIdleTimeoutInMinutes())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "WorkingDirectory":
            return Optional.ofNullable(clazz.cast(workingDirectory()));
        case "IdleTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(idleTimeoutSeconds()));
        case "SessionIdleTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(sessionIdleTimeoutInMinutes()));
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("IdleTimeoutSeconds", IDLE_TIMEOUT_SECONDS_FIELD);
        map.put("SessionIdleTimeoutInMinutes", SESSION_IDLE_TIMEOUT_IN_MINUTES_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionConfiguration, T> g) {
        return obj -> g.apply((SessionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionConfiguration> {
        /**
         * <p>
         * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled
         * workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
         * </p>
         * 
         * @param executionRole
         *        The ARN of the execution role used to access user resources for Spark sessions and Identity Center
         *        enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled
         *        workgroups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The Amazon S3 location that stores information for the notebook.
         * </p>
         * 
         * @param workingDirectory
         *        The Amazon S3 location that stores information for the notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workingDirectory(String workingDirectory);

        /**
         * <p>
         * The idle timeout in seconds for the session.
         * </p>
         * 
         * @param idleTimeoutSeconds
         *        The idle timeout in seconds for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeoutSeconds(Long idleTimeoutSeconds);

        /**
         * <p>
         * The idle timeout in seconds for the session.
         * </p>
         * 
         * @param sessionIdleTimeoutInMinutes
         *        The idle timeout in seconds for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * @param encryptionConfiguration
         *        The new value for the EncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * Sets the value of the EncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionRole;

        private String workingDirectory;

        private Long idleTimeoutSeconds;

        private Integer sessionIdleTimeoutInMinutes;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionConfiguration model) {
            executionRole(model.executionRole);
            workingDirectory(model.workingDirectory);
            idleTimeoutSeconds(model.idleTimeoutSeconds);
            sessionIdleTimeoutInMinutes(model.sessionIdleTimeoutInMinutes);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getWorkingDirectory() {
            return workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final Long getIdleTimeoutSeconds() {
            return idleTimeoutSeconds;
        }

        public final void setIdleTimeoutSeconds(Long idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
        }

        @Override
        public final Builder idleTimeoutSeconds(Long idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
            return this;
        }

        public final Integer getSessionIdleTimeoutInMinutes() {
            return sessionIdleTimeoutInMinutes;
        }

        public final void setSessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
        }

        @Override
        public final Builder sessionIdleTimeoutInMinutes(Integer sessionIdleTimeoutInMinutes) {
            this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public SessionConfiguration build() {
            return new SessionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
