/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where
 * query and calculation results are stored, the encryption option, if any, used for query results, whether the Amazon
 * CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings,
 * and the data usage limit for the amount of bytes scanned per query, if it is specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkGroupConfigurationUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkGroupConfigurationUpdates.Builder, WorkGroupConfigurationUpdates> {
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceWorkGroupConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::enforceWorkGroupConfiguration))
            .setter(setter(Builder::enforceWorkGroupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration")
                    .build()).build();

    private static final SdkField<ResultConfigurationUpdates> RESULT_CONFIGURATION_UPDATES_FIELD = SdkField
            .<ResultConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("ResultConfigurationUpdates")
            .getter(getter(WorkGroupConfigurationUpdates::resultConfigurationUpdates))
            .setter(setter(Builder::resultConfigurationUpdates))
            .constructor(ResultConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfigurationUpdates").build())
            .build();

    private static final SdkField<ManagedQueryResultsConfigurationUpdates> MANAGED_QUERY_RESULTS_CONFIGURATION_UPDATES_FIELD = SdkField
            .<ManagedQueryResultsConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("ManagedQueryResultsConfigurationUpdates")
            .getter(getter(WorkGroupConfigurationUpdates::managedQueryResultsConfigurationUpdates))
            .setter(setter(Builder::managedQueryResultsConfigurationUpdates))
            .constructor(ManagedQueryResultsConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ManagedQueryResultsConfigurationUpdates").build()).build();

    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublishCloudWatchMetricsEnabled")
            .getter(getter(WorkGroupConfigurationUpdates::publishCloudWatchMetricsEnabled))
            .setter(setter(Builder::publishCloudWatchMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled")
                    .build()).build();

    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("BytesScannedCutoffPerQuery")
            .getter(getter(WorkGroupConfigurationUpdates::bytesScannedCutoffPerQuery))
            .setter(setter(Builder::bytesScannedCutoffPerQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build())
            .build();

    private static final SdkField<Boolean> REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveBytesScannedCutoffPerQuery")
            .getter(getter(WorkGroupConfigurationUpdates::removeBytesScannedCutoffPerQuery))
            .setter(setter(Builder::removeBytesScannedCutoffPerQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveBytesScannedCutoffPerQuery")
                    .build()).build();

    private static final SdkField<Boolean> REQUESTER_PAYS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterPaysEnabled").getter(getter(WorkGroupConfigurationUpdates::requesterPaysEnabled))
            .setter(setter(Builder::requesterPaysEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPaysEnabled").build())
            .build();

    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField
            .<EngineVersion> builder(MarshallingType.SDK_POJO).memberName("EngineVersion")
            .getter(getter(WorkGroupConfigurationUpdates::engineVersion)).setter(setter(Builder::engineVersion))
            .constructor(EngineVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> REMOVE_CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveCustomerContentEncryptionConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::removeCustomerContentEncryptionConfiguration))
            .setter(setter(Builder::removeCustomerContentEncryptionConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RemoveCustomerContentEncryptionConfiguration").build()).build();

    private static final SdkField<String> ADDITIONAL_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalConfiguration").getter(getter(WorkGroupConfigurationUpdates::additionalConfiguration))
            .setter(setter(Builder::additionalConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalConfiguration").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(WorkGroupConfigurationUpdates::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<CustomerContentEncryptionConfiguration> CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<CustomerContentEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerContentEncryptionConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::customerContentEncryptionConfiguration))
            .setter(setter(Builder::customerContentEncryptionConfiguration))
            .constructor(CustomerContentEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomerContentEncryptionConfiguration").build()).build();

    private static final SdkField<Boolean> ENABLE_MINIMUM_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMinimumEncryptionConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::enableMinimumEncryptionConfiguration))
            .setter(setter(Builder::enableMinimumEncryptionConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableMinimumEncryptionConfiguration").build()).build();

    private static final SdkField<QueryResultsS3AccessGrantsConfiguration> QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD = SdkField
            .<QueryResultsS3AccessGrantsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("QueryResultsS3AccessGrantsConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::queryResultsS3AccessGrantsConfiguration))
            .setter(setter(Builder::queryResultsS3AccessGrantsConfiguration))
            .constructor(QueryResultsS3AccessGrantsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("QueryResultsS3AccessGrantsConfiguration").build()).build();

    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("MonitoringConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::monitoringConfiguration))
            .setter(setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build())
            .build();

    private static final SdkField<EngineConfiguration> ENGINE_CONFIGURATION_FIELD = SdkField
            .<EngineConfiguration> builder(MarshallingType.SDK_POJO).memberName("EngineConfiguration")
            .getter(getter(WorkGroupConfigurationUpdates::engineConfiguration)).setter(setter(Builder::engineConfiguration))
            .constructor(EngineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, RESULT_CONFIGURATION_UPDATES_FIELD,
            MANAGED_QUERY_RESULTS_CONFIGURATION_UPDATES_FIELD, PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD,
            BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REQUESTER_PAYS_ENABLED_FIELD,
            ENGINE_VERSION_FIELD, REMOVE_CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD, ADDITIONAL_CONFIGURATION_FIELD,
            EXECUTION_ROLE_FIELD, CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD, ENABLE_MINIMUM_ENCRYPTION_CONFIGURATION_FIELD,
            QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD, ENGINE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enforceWorkGroupConfiguration;

    private final ResultConfigurationUpdates resultConfigurationUpdates;

    private final ManagedQueryResultsConfigurationUpdates managedQueryResultsConfigurationUpdates;

    private final Boolean publishCloudWatchMetricsEnabled;

    private final Long bytesScannedCutoffPerQuery;

    private final Boolean removeBytesScannedCutoffPerQuery;

    private final Boolean requesterPaysEnabled;

    private final EngineVersion engineVersion;

    private final Boolean removeCustomerContentEncryptionConfiguration;

    private final String additionalConfiguration;

    private final String executionRole;

    private final CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration;

    private final Boolean enableMinimumEncryptionConfiguration;

    private final QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration;

    private final MonitoringConfiguration monitoringConfiguration;

    private final EngineConfiguration engineConfiguration;

    private WorkGroupConfigurationUpdates(BuilderImpl builder) {
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
        this.managedQueryResultsConfigurationUpdates = builder.managedQueryResultsConfigurationUpdates;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
        this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
        this.requesterPaysEnabled = builder.requesterPaysEnabled;
        this.engineVersion = builder.engineVersion;
        this.removeCustomerContentEncryptionConfiguration = builder.removeCustomerContentEncryptionConfiguration;
        this.additionalConfiguration = builder.additionalConfiguration;
        this.executionRole = builder.executionRole;
        this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
        this.enableMinimumEncryptionConfiguration = builder.enableMinimumEncryptionConfiguration;
        this.queryResultsS3AccessGrantsConfiguration = builder.queryResultsS3AccessGrantsConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.engineConfiguration = builder.engineConfiguration;
    }

    /**
     * <p>
     * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
     * settings are used. For more information, see <a
     * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
     * Client-Side Settings</a>.
     * </p>
     * 
     * @return If set to "true", the settings for the workgroup override client-side settings. If set to "false"
     *         client-side settings are used. For more information, see <a
     *         href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
     *         Override Client-Side Settings</a>.
     */
    public final Boolean enforceWorkGroupConfiguration() {
        return enforceWorkGroupConfiguration;
    }

    /**
     * <p>
     * The result configuration information about the queries in this workgroup that will be updated. Includes the
     * updated results location and an updated option for encrypting query results.
     * </p>
     * 
     * @return The result configuration information about the queries in this workgroup that will be updated. Includes
     *         the updated results location and an updated option for encrypting query results.
     */
    public final ResultConfigurationUpdates resultConfigurationUpdates() {
        return resultConfigurationUpdates;
    }

    /**
     * <p>
     * Updates configuration information for managed query results in the workgroup.
     * </p>
     * 
     * @return Updates configuration information for managed query results in the workgroup.
     */
    public final ManagedQueryResultsConfigurationUpdates managedQueryResultsConfigurationUpdates() {
        return managedQueryResultsConfigurationUpdates;
    }

    /**
     * <p>
     * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     * </p>
     * 
     * @return Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
     */
    public final Boolean publishCloudWatchMetricsEnabled() {
        return publishCloudWatchMetricsEnabled;
    }

    /**
     * <p>
     * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     * </p>
     * 
     * @return The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
     */
    public final Long bytesScannedCutoffPerQuery() {
        return bytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * Indicates that the data usage control limit per query is removed.
     * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     * </p>
     * 
     * @return Indicates that the data usage control limit per query is removed.
     *         <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
     */
    public final Boolean removeBytesScannedCutoffPerQuery() {
        return removeBytesScannedCutoffPerQuery;
    }

    /**
     * <p>
     * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets
     * in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays buckets, and
     * queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code>. For
     * more information about Requester Pays buckets, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in
     * the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * 
     * @return If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
     *         buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
     *         buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
     *         <code>false</code>. For more information about Requester Pays buckets, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
     *         Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
     */
    public final Boolean requesterPaysEnabled() {
        return requesterPaysEnabled;
    }

    /**
     * <p>
     * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run on
     * the requested engine version. If no value was previously set, the default is Auto. Queries on the
     * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
     * </p>
     * 
     * @return The engine version requested when a workgroup is updated. After the update, all queries on the workgroup
     *         run on the requested engine version. If no value was previously set, the default is Auto. Queries on the
     *         <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this
     *         setting.
     */
    public final EngineVersion engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
     * </p>
     * 
     * @return Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
     */
    public final Boolean removeCustomerContentEncryptionConfiguration() {
        return removeCustomerContentEncryptionConfiguration;
    }

    /**
     * <p>
     * Contains a user defined string in JSON format for a Spark-enabled workgroup.
     * </p>
     * 
     * @return Contains a user defined string in JSON format for a Spark-enabled workgroup.
     */
    public final String additionalConfiguration() {
        return additionalConfiguration;
    }

    /**
     * <p>
     * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled
     * workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
     * </p>
     * 
     * @return The ARN of the execution role used to access user resources for Spark sessions and Identity Center
     *         enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled
     *         workgroups.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * Returns the value of the CustomerContentEncryptionConfiguration property for this object.
     * 
     * @return The value of the CustomerContentEncryptionConfiguration property for this object.
     */
    public final CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration() {
        return customerContentEncryptionConfiguration;
    }

    /**
     * <p>
     * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written to
     * Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the administrator or
     * higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
     * </p>
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code> flag is
     * ignored, and the workgroup configuration for encryption is used.
     * </p>
     * 
     * @return Enforces a minimal level of encryption for the workgroup for query and calculation results that are
     *         written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by
     *         the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
     *         workgroups.</p>
     *         <p>
     *         The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
     *         <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
     *         <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
     *         flag is ignored, and the workgroup configuration for encryption is used.
     */
    public final Boolean enableMinimumEncryptionConfiguration() {
        return enableMinimumEncryptionConfiguration;
    }

    /**
     * <p>
     * Specifies whether Amazon S3 access grants are enabled for query results.
     * </p>
     * 
     * @return Specifies whether Amazon S3 access grants are enabled for query results.
     */
    public final QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration() {
        return queryResultsS3AccessGrantsConfiguration;
    }

    /**
     * <p>
     * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon
     * CloudWatch log groups etc.
     * </p>
     * 
     * @return Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets,
     *         Amazon CloudWatch log groups etc.
     */
    public final MonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    /**
     * Returns the value of the EngineConfiguration property for this object.
     * 
     * @return The value of the EngineConfiguration property for this object.
     */
    public final EngineConfiguration engineConfiguration() {
        return engineConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfigurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(managedQueryResultsConfigurationUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(removeBytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPaysEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(removeCustomerContentEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(additionalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(customerContentEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enableMinimumEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(queryResultsS3AccessGrantsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfigurationUpdates)) {
            return false;
        }
        WorkGroupConfigurationUpdates other = (WorkGroupConfigurationUpdates) obj;
        return Objects.equals(enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration())
                && Objects.equals(resultConfigurationUpdates(), other.resultConfigurationUpdates())
                && Objects.equals(managedQueryResultsConfigurationUpdates(), other.managedQueryResultsConfigurationUpdates())
                && Objects.equals(publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled())
                && Objects.equals(bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery())
                && Objects.equals(removeBytesScannedCutoffPerQuery(), other.removeBytesScannedCutoffPerQuery())
                && Objects.equals(requesterPaysEnabled(), other.requesterPaysEnabled())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(removeCustomerContentEncryptionConfiguration(),
                        other.removeCustomerContentEncryptionConfiguration())
                && Objects.equals(additionalConfiguration(), other.additionalConfiguration())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(customerContentEncryptionConfiguration(), other.customerContentEncryptionConfiguration())
                && Objects.equals(enableMinimumEncryptionConfiguration(), other.enableMinimumEncryptionConfiguration())
                && Objects.equals(queryResultsS3AccessGrantsConfiguration(), other.queryResultsS3AccessGrantsConfiguration())
                && Objects.equals(monitoringConfiguration(), other.monitoringConfiguration())
                && Objects.equals(engineConfiguration(), other.engineConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkGroupConfigurationUpdates")
                .add("EnforceWorkGroupConfiguration", enforceWorkGroupConfiguration())
                .add("ResultConfigurationUpdates", resultConfigurationUpdates())
                .add("ManagedQueryResultsConfigurationUpdates", managedQueryResultsConfigurationUpdates())
                .add("PublishCloudWatchMetricsEnabled", publishCloudWatchMetricsEnabled())
                .add("BytesScannedCutoffPerQuery", bytesScannedCutoffPerQuery())
                .add("RemoveBytesScannedCutoffPerQuery", removeBytesScannedCutoffPerQuery())
                .add("RequesterPaysEnabled", requesterPaysEnabled()).add("EngineVersion", engineVersion())
                .add("RemoveCustomerContentEncryptionConfiguration", removeCustomerContentEncryptionConfiguration())
                .add("AdditionalConfiguration", additionalConfiguration()).add("ExecutionRole", executionRole())
                .add("CustomerContentEncryptionConfiguration", customerContentEncryptionConfiguration())
                .add("EnableMinimumEncryptionConfiguration", enableMinimumEncryptionConfiguration())
                .add("QueryResultsS3AccessGrantsConfiguration", queryResultsS3AccessGrantsConfiguration())
                .add("MonitoringConfiguration", monitoringConfiguration()).add("EngineConfiguration", engineConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnforceWorkGroupConfiguration":
            return Optional.ofNullable(clazz.cast(enforceWorkGroupConfiguration()));
        case "ResultConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(resultConfigurationUpdates()));
        case "ManagedQueryResultsConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(managedQueryResultsConfigurationUpdates()));
        case "PublishCloudWatchMetricsEnabled":
            return Optional.ofNullable(clazz.cast(publishCloudWatchMetricsEnabled()));
        case "BytesScannedCutoffPerQuery":
            return Optional.ofNullable(clazz.cast(bytesScannedCutoffPerQuery()));
        case "RemoveBytesScannedCutoffPerQuery":
            return Optional.ofNullable(clazz.cast(removeBytesScannedCutoffPerQuery()));
        case "RequesterPaysEnabled":
            return Optional.ofNullable(clazz.cast(requesterPaysEnabled()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "RemoveCustomerContentEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(removeCustomerContentEncryptionConfiguration()));
        case "AdditionalConfiguration":
            return Optional.ofNullable(clazz.cast(additionalConfiguration()));
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "CustomerContentEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(customerContentEncryptionConfiguration()));
        case "EnableMinimumEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(enableMinimumEncryptionConfiguration()));
        case "QueryResultsS3AccessGrantsConfiguration":
            return Optional.ofNullable(clazz.cast(queryResultsS3AccessGrantsConfiguration()));
        case "MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        case "EngineConfiguration":
            return Optional.ofNullable(clazz.cast(engineConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnforceWorkGroupConfiguration", ENFORCE_WORK_GROUP_CONFIGURATION_FIELD);
        map.put("ResultConfigurationUpdates", RESULT_CONFIGURATION_UPDATES_FIELD);
        map.put("ManagedQueryResultsConfigurationUpdates", MANAGED_QUERY_RESULTS_CONFIGURATION_UPDATES_FIELD);
        map.put("PublishCloudWatchMetricsEnabled", PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD);
        map.put("BytesScannedCutoffPerQuery", BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD);
        map.put("RemoveBytesScannedCutoffPerQuery", REMOVE_BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD);
        map.put("RequesterPaysEnabled", REQUESTER_PAYS_ENABLED_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("RemoveCustomerContentEncryptionConfiguration", REMOVE_CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("AdditionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("CustomerContentEncryptionConfiguration", CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("EnableMinimumEncryptionConfiguration", ENABLE_MINIMUM_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("QueryResultsS3AccessGrantsConfiguration", QUERY_RESULTS_S3_ACCESS_GRANTS_CONFIGURATION_FIELD);
        map.put("MonitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        map.put("EngineConfiguration", ENGINE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfigurationUpdates, T> g) {
        return obj -> g.apply((WorkGroupConfigurationUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkGroupConfigurationUpdates> {
        /**
         * <p>
         * If set to "true", the settings for the workgroup override client-side settings. If set to "false" client-side
         * settings are used. For more information, see <a
         * href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings
         * Override Client-Side Settings</a>.
         * </p>
         * 
         * @param enforceWorkGroupConfiguration
         *        If set to "true", the settings for the workgroup override client-side settings. If set to "false"
         *        client-side settings are used. For more information, see <a
         *        href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup
         *        Settings Override Client-Side Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration);

        /**
         * <p>
         * The result configuration information about the queries in this workgroup that will be updated. Includes the
         * updated results location and an updated option for encrypting query results.
         * </p>
         * 
         * @param resultConfigurationUpdates
         *        The result configuration information about the queries in this workgroup that will be updated.
         *        Includes the updated results location and an updated option for encrypting query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates);

        /**
         * <p>
         * The result configuration information about the queries in this workgroup that will be updated. Includes the
         * updated results location and an updated option for encrypting query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultConfigurationUpdates.Builder}
         * avoiding the need to create one manually via {@link ResultConfigurationUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultConfigurationUpdates.Builder#build()} is called immediately
         * and its result is passed to {@link #resultConfigurationUpdates(ResultConfigurationUpdates)}.
         * 
         * @param resultConfigurationUpdates
         *        a consumer that will call methods on {@link ResultConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfigurationUpdates(ResultConfigurationUpdates)
         */
        default Builder resultConfigurationUpdates(Consumer<ResultConfigurationUpdates.Builder> resultConfigurationUpdates) {
            return resultConfigurationUpdates(ResultConfigurationUpdates.builder().applyMutation(resultConfigurationUpdates)
                    .build());
        }

        /**
         * <p>
         * Updates configuration information for managed query results in the workgroup.
         * </p>
         * 
         * @param managedQueryResultsConfigurationUpdates
         *        Updates configuration information for managed query results in the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedQueryResultsConfigurationUpdates(
                ManagedQueryResultsConfigurationUpdates managedQueryResultsConfigurationUpdates);

        /**
         * <p>
         * Updates configuration information for managed query results in the workgroup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedQueryResultsConfigurationUpdates.Builder} avoiding the need to create one manually via
         * {@link ManagedQueryResultsConfigurationUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedQueryResultsConfigurationUpdates.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #managedQueryResultsConfigurationUpdates(ManagedQueryResultsConfigurationUpdates)}.
         * 
         * @param managedQueryResultsConfigurationUpdates
         *        a consumer that will call methods on {@link ManagedQueryResultsConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedQueryResultsConfigurationUpdates(ManagedQueryResultsConfigurationUpdates)
         */
        default Builder managedQueryResultsConfigurationUpdates(
                Consumer<ManagedQueryResultsConfigurationUpdates.Builder> managedQueryResultsConfigurationUpdates) {
            return managedQueryResultsConfigurationUpdates(ManagedQueryResultsConfigurationUpdates.builder()
                    .applyMutation(managedQueryResultsConfigurationUpdates).build());
        }

        /**
         * <p>
         * Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         * </p>
         * 
         * @param publishCloudWatchMetricsEnabled
         *        Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled);

        /**
         * <p>
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * </p>
         * 
         * @param bytesScannedCutoffPerQuery
         *        The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery);

        /**
         * <p>
         * Indicates that the data usage control limit per query is removed.
         * <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
         * </p>
         * 
         * @param removeBytesScannedCutoffPerQuery
         *        Indicates that the data usage control limit per query is removed.
         *        <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery);

        /**
         * <p>
         * If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays
         * buckets in queries. If set to <code>false</code>, workgroup members cannot query data from Requester Pays
         * buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is
         * <code>false</code>. For more information about Requester Pays buckets, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>
         * in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * 
         * @param requesterPaysEnabled
         *        If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester
         *        Pays buckets in queries. If set to <code>false</code>, workgroup members cannot query data from
         *        Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The
         *        default is <code>false</code>. For more information about Requester Pays buckets, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays
         *        Buckets</a> in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPaysEnabled(Boolean requesterPaysEnabled);

        /**
         * <p>
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run
         * on the requested engine version. If no value was previously set, the default is Auto. Queries on the
         * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
         * </p>
         * 
         * @param engineVersion
         *        The engine version requested when a workgroup is updated. After the update, all queries on the
         *        workgroup run on the requested engine version. If no value was previously set, the default is Auto.
         *        Queries on the <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
         *        regardless of this setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(EngineVersion engineVersion);

        /**
         * <p>
         * The engine version requested when a workgroup is updated. After the update, all queries on the workgroup run
         * on the requested engine version. If no value was previously set, the default is Auto. Queries on the
         * <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine regardless of this setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineVersion.Builder} avoiding the need
         * to create one manually via {@link EngineVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #engineVersion(EngineVersion)}.
         * 
         * @param engineVersion
         *        a consumer that will call methods on {@link EngineVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersion(EngineVersion)
         */
        default Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return engineVersion(EngineVersion.builder().applyMutation(engineVersion).build());
        }

        /**
         * <p>
         * Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
         * </p>
         * 
         * @param removeCustomerContentEncryptionConfiguration
         *        Removes content encryption configuration from an Apache Spark-enabled Athena workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeCustomerContentEncryptionConfiguration(Boolean removeCustomerContentEncryptionConfiguration);

        /**
         * <p>
         * Contains a user defined string in JSON format for a Spark-enabled workgroup.
         * </p>
         * 
         * @param additionalConfiguration
         *        Contains a user defined string in JSON format for a Spark-enabled workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(String additionalConfiguration);

        /**
         * <p>
         * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled
         * workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
         * </p>
         * 
         * @param executionRole
         *        The ARN of the execution role used to access user resources for Spark sessions and Identity Center
         *        enabled workgroups. This property applies only to Spark enabled workgroups and Identity Center enabled
         *        workgroups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * Sets the value of the CustomerContentEncryptionConfiguration property for this object.
         *
         * @param customerContentEncryptionConfiguration
         *        The new value for the CustomerContentEncryptionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerContentEncryptionConfiguration(
                CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration);

        /**
         * Sets the value of the CustomerContentEncryptionConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CustomerContentEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomerContentEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerContentEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration)}.
         * 
         * @param customerContentEncryptionConfiguration
         *        a consumer that will call methods on {@link CustomerContentEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration)
         */
        default Builder customerContentEncryptionConfiguration(
                Consumer<CustomerContentEncryptionConfiguration.Builder> customerContentEncryptionConfiguration) {
            return customerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration.builder()
                    .applyMutation(customerContentEncryptionConfiguration).build());
        }

        /**
         * <p>
         * Enforces a minimal level of encryption for the workgroup for query and calculation results that are written
         * to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set by the
         * administrator or higher when they submit queries. This setting does not apply to Spark-enabled workgroups.
         * </p>
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
         * <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
         * <code>EnforceWorkGroupConfiguration</code> is true, the <code>EnableMinimumEncryptionConfiguration</code>
         * flag is ignored, and the workgroup configuration for encryption is used.
         * </p>
         * 
         * @param enableMinimumEncryptionConfiguration
         *        Enforces a minimal level of encryption for the workgroup for query and calculation results that are
         *        written to Amazon S3. When enabled, workgroup users can set encryption only to the minimum level set
         *        by the administrator or higher when they submit queries. This setting does not apply to Spark-enabled
         *        workgroups.</p>
         *        <p>
         *        The <code>EnforceWorkGroupConfiguration</code> setting takes precedence over the
         *        <code>EnableMinimumEncryptionConfiguration</code> flag. This means that if
         *        <code>EnforceWorkGroupConfiguration</code> is true, the
         *        <code>EnableMinimumEncryptionConfiguration</code> flag is ignored, and the workgroup configuration for
         *        encryption is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration);

        /**
         * <p>
         * Specifies whether Amazon S3 access grants are enabled for query results.
         * </p>
         * 
         * @param queryResultsS3AccessGrantsConfiguration
         *        Specifies whether Amazon S3 access grants are enabled for query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryResultsS3AccessGrantsConfiguration(
                QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration);

        /**
         * <p>
         * Specifies whether Amazon S3 access grants are enabled for query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link QueryResultsS3AccessGrantsConfiguration.Builder} avoiding the need to create one manually via
         * {@link QueryResultsS3AccessGrantsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryResultsS3AccessGrantsConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #queryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration)}.
         * 
         * @param queryResultsS3AccessGrantsConfiguration
         *        a consumer that will call methods on {@link QueryResultsS3AccessGrantsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration)
         */
        default Builder queryResultsS3AccessGrantsConfiguration(
                Consumer<QueryResultsS3AccessGrantsConfiguration.Builder> queryResultsS3AccessGrantsConfiguration) {
            return queryResultsS3AccessGrantsConfiguration(QueryResultsS3AccessGrantsConfiguration.builder()
                    .applyMutation(queryResultsS3AccessGrantsConfiguration).build());
        }

        /**
         * <p>
         * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon
         * CloudWatch log groups etc.
         * </p>
         * 
         * @param monitoringConfiguration
         *        Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets,
         *        Amazon CloudWatch log groups etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon
         * CloudWatch log groups etc.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringConfiguration.Builder} avoiding
         * the need to create one manually via {@link MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringConfiguration(MonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(MonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(MonitoringConfiguration.builder().applyMutation(monitoringConfiguration).build());
        }

        /**
         * Sets the value of the EngineConfiguration property for this object.
         *
         * @param engineConfiguration
         *        The new value for the EngineConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineConfiguration(EngineConfiguration engineConfiguration);

        /**
         * Sets the value of the EngineConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EngineConfiguration.Builder} avoiding the
         * need to create one manually via {@link EngineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #engineConfiguration(EngineConfiguration)}.
         * 
         * @param engineConfiguration
         *        a consumer that will call methods on {@link EngineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineConfiguration(EngineConfiguration)
         */
        default Builder engineConfiguration(Consumer<EngineConfiguration.Builder> engineConfiguration) {
            return engineConfiguration(EngineConfiguration.builder().applyMutation(engineConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforceWorkGroupConfiguration;

        private ResultConfigurationUpdates resultConfigurationUpdates;

        private ManagedQueryResultsConfigurationUpdates managedQueryResultsConfigurationUpdates;

        private Boolean publishCloudWatchMetricsEnabled;

        private Long bytesScannedCutoffPerQuery;

        private Boolean removeBytesScannedCutoffPerQuery;

        private Boolean requesterPaysEnabled;

        private EngineVersion engineVersion;

        private Boolean removeCustomerContentEncryptionConfiguration;

        private String additionalConfiguration;

        private String executionRole;

        private CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration;

        private Boolean enableMinimumEncryptionConfiguration;

        private QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration;

        private MonitoringConfiguration monitoringConfiguration;

        private EngineConfiguration engineConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfigurationUpdates model) {
            enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            resultConfigurationUpdates(model.resultConfigurationUpdates);
            managedQueryResultsConfigurationUpdates(model.managedQueryResultsConfigurationUpdates);
            publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
            removeBytesScannedCutoffPerQuery(model.removeBytesScannedCutoffPerQuery);
            requesterPaysEnabled(model.requesterPaysEnabled);
            engineVersion(model.engineVersion);
            removeCustomerContentEncryptionConfiguration(model.removeCustomerContentEncryptionConfiguration);
            additionalConfiguration(model.additionalConfiguration);
            executionRole(model.executionRole);
            customerContentEncryptionConfiguration(model.customerContentEncryptionConfiguration);
            enableMinimumEncryptionConfiguration(model.enableMinimumEncryptionConfiguration);
            queryResultsS3AccessGrantsConfiguration(model.queryResultsS3AccessGrantsConfiguration);
            monitoringConfiguration(model.monitoringConfiguration);
            engineConfiguration(model.engineConfiguration);
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return enforceWorkGroupConfiguration;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        @Override
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final ResultConfigurationUpdates.Builder getResultConfigurationUpdates() {
            return resultConfigurationUpdates != null ? resultConfigurationUpdates.toBuilder() : null;
        }

        public final void setResultConfigurationUpdates(ResultConfigurationUpdates.BuilderImpl resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates != null ? resultConfigurationUpdates.build() : null;
        }

        @Override
        public final Builder resultConfigurationUpdates(ResultConfigurationUpdates resultConfigurationUpdates) {
            this.resultConfigurationUpdates = resultConfigurationUpdates;
            return this;
        }

        public final ManagedQueryResultsConfigurationUpdates.Builder getManagedQueryResultsConfigurationUpdates() {
            return managedQueryResultsConfigurationUpdates != null ? managedQueryResultsConfigurationUpdates.toBuilder() : null;
        }

        public final void setManagedQueryResultsConfigurationUpdates(
                ManagedQueryResultsConfigurationUpdates.BuilderImpl managedQueryResultsConfigurationUpdates) {
            this.managedQueryResultsConfigurationUpdates = managedQueryResultsConfigurationUpdates != null ? managedQueryResultsConfigurationUpdates
                    .build() : null;
        }

        @Override
        public final Builder managedQueryResultsConfigurationUpdates(
                ManagedQueryResultsConfigurationUpdates managedQueryResultsConfigurationUpdates) {
            this.managedQueryResultsConfigurationUpdates = managedQueryResultsConfigurationUpdates;
            return this;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return publishCloudWatchMetricsEnabled;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        @Override
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return bytesScannedCutoffPerQuery;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRemoveBytesScannedCutoffPerQuery() {
            return removeBytesScannedCutoffPerQuery;
        }

        public final void setRemoveBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder removeBytesScannedCutoffPerQuery(Boolean removeBytesScannedCutoffPerQuery) {
            this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRequesterPaysEnabled() {
            return requesterPaysEnabled;
        }

        public final void setRequesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
        }

        @Override
        public final Builder requesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return engineVersion != null ? engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getRemoveCustomerContentEncryptionConfiguration() {
            return removeCustomerContentEncryptionConfiguration;
        }

        public final void setRemoveCustomerContentEncryptionConfiguration(Boolean removeCustomerContentEncryptionConfiguration) {
            this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
        }

        @Override
        public final Builder removeCustomerContentEncryptionConfiguration(Boolean removeCustomerContentEncryptionConfiguration) {
            this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
            return this;
        }

        public final String getAdditionalConfiguration() {
            return additionalConfiguration;
        }

        public final void setAdditionalConfiguration(String additionalConfiguration) {
            this.additionalConfiguration = additionalConfiguration;
        }

        @Override
        public final Builder additionalConfiguration(String additionalConfiguration) {
            this.additionalConfiguration = additionalConfiguration;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final CustomerContentEncryptionConfiguration.Builder getCustomerContentEncryptionConfiguration() {
            return customerContentEncryptionConfiguration != null ? customerContentEncryptionConfiguration.toBuilder() : null;
        }

        public final void setCustomerContentEncryptionConfiguration(
                CustomerContentEncryptionConfiguration.BuilderImpl customerContentEncryptionConfiguration) {
            this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration != null ? customerContentEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder customerContentEncryptionConfiguration(
                CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration) {
            this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
            return this;
        }

        public final Boolean getEnableMinimumEncryptionConfiguration() {
            return enableMinimumEncryptionConfiguration;
        }

        public final void setEnableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
            this.enableMinimumEncryptionConfiguration = enableMinimumEncryptionConfiguration;
        }

        @Override
        public final Builder enableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
            this.enableMinimumEncryptionConfiguration = enableMinimumEncryptionConfiguration;
            return this;
        }

        public final QueryResultsS3AccessGrantsConfiguration.Builder getQueryResultsS3AccessGrantsConfiguration() {
            return queryResultsS3AccessGrantsConfiguration != null ? queryResultsS3AccessGrantsConfiguration.toBuilder() : null;
        }

        public final void setQueryResultsS3AccessGrantsConfiguration(
                QueryResultsS3AccessGrantsConfiguration.BuilderImpl queryResultsS3AccessGrantsConfiguration) {
            this.queryResultsS3AccessGrantsConfiguration = queryResultsS3AccessGrantsConfiguration != null ? queryResultsS3AccessGrantsConfiguration
                    .build() : null;
        }

        @Override
        public final Builder queryResultsS3AccessGrantsConfiguration(
                QueryResultsS3AccessGrantsConfiguration queryResultsS3AccessGrantsConfiguration) {
            this.queryResultsS3AccessGrantsConfiguration = queryResultsS3AccessGrantsConfiguration;
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final EngineConfiguration.Builder getEngineConfiguration() {
            return engineConfiguration != null ? engineConfiguration.toBuilder() : null;
        }

        public final void setEngineConfiguration(EngineConfiguration.BuilderImpl engineConfiguration) {
            this.engineConfiguration = engineConfiguration != null ? engineConfiguration.build() : null;
        }

        @Override
        public final Builder engineConfiguration(EngineConfiguration engineConfiguration) {
            this.engineConfiguration = engineConfiguration;
            return this;
        }

        @Override
        public WorkGroupConfigurationUpdates build() {
            return new WorkGroupConfigurationUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
