/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServicesInScopeResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetServicesInScopeResponse.Builder, GetServicesInScopeResponse> {
    private static final SdkField<List<ServiceMetadata>> SERVICE_METADATA_FIELD = SdkField
            .<List<ServiceMetadata>> builder(MarshallingType.LIST)
            .memberName("serviceMetadata")
            .getter(getter(GetServicesInScopeResponse::serviceMetadata))
            .setter(setter(Builder::serviceMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_METADATA_FIELD));

    private final List<ServiceMetadata> serviceMetadata;

    private GetServicesInScopeResponse(BuilderImpl builder) {
        super(builder);
        this.serviceMetadata = builder.serviceMetadata;
    }

    /**
     * Returns true if the ServiceMetadata property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceMetadata() {
        return serviceMetadata != null && !(serviceMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata associated with the aAWS service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata associated with the aAWS service.
     */
    public List<ServiceMetadata> serviceMetadata() {
        return serviceMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceMetadata() ? serviceMetadata() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServicesInScopeResponse)) {
            return false;
        }
        GetServicesInScopeResponse other = (GetServicesInScopeResponse) obj;
        return hasServiceMetadata() == other.hasServiceMetadata() && Objects.equals(serviceMetadata(), other.serviceMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServicesInScopeResponse")
                .add("ServiceMetadata", hasServiceMetadata() ? serviceMetadata() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceMetadata":
            return Optional.ofNullable(clazz.cast(serviceMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServicesInScopeResponse, T> g) {
        return obj -> g.apply((GetServicesInScopeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServicesInScopeResponse> {
        /**
         * <p>
         * The metadata associated with the aAWS service.
         * </p>
         * 
         * @param serviceMetadata
         *        The metadata associated with the aAWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceMetadata(Collection<ServiceMetadata> serviceMetadata);

        /**
         * <p>
         * The metadata associated with the aAWS service.
         * </p>
         * 
         * @param serviceMetadata
         *        The metadata associated with the aAWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceMetadata(ServiceMetadata... serviceMetadata);

        /**
         * <p>
         * The metadata associated with the aAWS service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceMetadata(List<ServiceMetadata>)}.
         * 
         * @param serviceMetadata
         *        a consumer that will call methods on {@link List<ServiceMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceMetadata(List<ServiceMetadata>)
         */
        Builder serviceMetadata(Consumer<ServiceMetadata.Builder>... serviceMetadata);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<ServiceMetadata> serviceMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServicesInScopeResponse model) {
            super(model);
            serviceMetadata(model.serviceMetadata);
        }

        public final Collection<ServiceMetadata.Builder> getServiceMetadata() {
            if (serviceMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceMetadata != null ? serviceMetadata.stream().map(ServiceMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceMetadata(Collection<ServiceMetadata> serviceMetadata) {
            this.serviceMetadata = ServiceMetadataListCopier.copy(serviceMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceMetadata(ServiceMetadata... serviceMetadata) {
            serviceMetadata(Arrays.asList(serviceMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceMetadata(Consumer<ServiceMetadata.Builder>... serviceMetadata) {
            serviceMetadata(Stream.of(serviceMetadata).map(c -> ServiceMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceMetadata(Collection<ServiceMetadata.BuilderImpl> serviceMetadata) {
            this.serviceMetadata = ServiceMetadataListCopier.copyFromBuilder(serviceMetadata);
        }

        @Override
        public GetServicesInScopeResponse build() {
            return new GetServicesInScopeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
