/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata associated with a standard or custom framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentFrameworkMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentFrameworkMetadata.Builder, AssessmentFrameworkMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentFrameworkMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssessmentFrameworkMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentFrameworkMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssessmentFrameworkMetadata::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> LOGO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logo")
            .getter(getter(AssessmentFrameworkMetadata::logo)).setter(setter(Builder::logo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(AssessmentFrameworkMetadata::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final SdkField<Integer> CONTROLS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("controlsCount").getter(getter(AssessmentFrameworkMetadata::controlsCount))
            .setter(setter(Builder::controlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlsCount").build()).build();

    private static final SdkField<Integer> CONTROL_SETS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("controlSetsCount").getter(getter(AssessmentFrameworkMetadata::controlSetsCount))
            .setter(setter(Builder::controlSetsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetsCount").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssessmentFrameworkMetadata::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(AssessmentFrameworkMetadata::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, COMPLIANCE_TYPE_FIELD, CONTROLS_COUNT_FIELD, CONTROL_SETS_COUNT_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String name;

    private final String description;

    private final String logo;

    private final String complianceType;

    private final Integer controlsCount;

    private final Integer controlSetsCount;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private AssessmentFrameworkMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.logo = builder.logo;
        this.complianceType = builder.complianceType;
        this.controlsCount = builder.controlsCount;
        this.controlSetsCount = builder.controlSetsCount;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The unique identified for the specified framework.
     * </p>
     * 
     * @return The unique identified for the specified framework.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The framework type, such as standard or custom.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as standard or custom.
     * @see FrameworkType
     */
    public FrameworkType type() {
        return FrameworkType.fromValue(type);
    }

    /**
     * <p>
     * The framework type, such as standard or custom.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as standard or custom.
     * @see FrameworkType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the specified framework.
     * </p>
     * 
     * @return The name of the specified framework.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the specified framework.
     * </p>
     * 
     * @return The description of the specified framework.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The logo associated with the framework.
     * </p>
     * 
     * @return The logo associated with the framework.
     */
    public String logo() {
        return logo;
    }

    /**
     * <p>
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The number of controls associated with the specified framework.
     * </p>
     * 
     * @return The number of controls associated with the specified framework.
     */
    public Integer controlsCount() {
        return controlsCount;
    }

    /**
     * <p>
     * The number of control sets associated with the specified framework.
     * </p>
     * 
     * @return The number of control sets associated with the specified framework.
     */
    public Integer controlSetsCount() {
        return controlSetsCount;
    }

    /**
     * <p>
     * Specifies when the framework was created.
     * </p>
     * 
     * @return Specifies when the framework was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the framework was most recently updated.
     * </p>
     * 
     * @return Specifies when the framework was most recently updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(controlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetsCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFrameworkMetadata)) {
            return false;
        }
        AssessmentFrameworkMetadata other = (AssessmentFrameworkMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(logo(), other.logo()) && Objects.equals(complianceType(), other.complianceType())
                && Objects.equals(controlsCount(), other.controlsCount())
                && Objects.equals(controlSetsCount(), other.controlSetsCount()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssessmentFrameworkMetadata").add("Id", id()).add("Type", typeAsString()).add("Name", name())
                .add("Description", description()).add("Logo", logo()).add("ComplianceType", complianceType())
                .add("ControlsCount", controlsCount()).add("ControlSetsCount", controlSetsCount()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "logo":
            return Optional.ofNullable(clazz.cast(logo()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "controlsCount":
            return Optional.ofNullable(clazz.cast(controlsCount()));
        case "controlSetsCount":
            return Optional.ofNullable(clazz.cast(controlSetsCount()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFrameworkMetadata, T> g) {
        return obj -> g.apply((AssessmentFrameworkMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentFrameworkMetadata> {
        /**
         * <p>
         * The unique identified for the specified framework.
         * </p>
         * 
         * @param id
         *        The unique identified for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The framework type, such as standard or custom.
         * </p>
         * 
         * @param type
         *        The framework type, such as standard or custom.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(String type);

        /**
         * <p>
         * The framework type, such as standard or custom.
         * </p>
         * 
         * @param type
         *        The framework type, such as standard or custom.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(FrameworkType type);

        /**
         * <p>
         * The name of the specified framework.
         * </p>
         * 
         * @param name
         *        The name of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the specified framework.
         * </p>
         * 
         * @param description
         *        The description of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The logo associated with the framework.
         * </p>
         * 
         * @param logo
         *        The logo associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(String logo);

        /**
         * <p>
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The number of controls associated with the specified framework.
         * </p>
         * 
         * @param controlsCount
         *        The number of controls associated with the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlsCount(Integer controlsCount);

        /**
         * <p>
         * The number of control sets associated with the specified framework.
         * </p>
         * 
         * @param controlSetsCount
         *        The number of control sets associated with the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetsCount(Integer controlSetsCount);

        /**
         * <p>
         * Specifies when the framework was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the framework was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the framework was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the framework was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String name;

        private String description;

        private String logo;

        private String complianceType;

        private Integer controlsCount;

        private Integer controlSetsCount;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFrameworkMetadata model) {
            id(model.id);
            type(model.type);
            name(model.name);
            description(model.description);
            logo(model.logo);
            complianceType(model.complianceType);
            controlsCount(model.controlsCount);
            controlSetsCount(model.controlSetsCount);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FrameworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogo() {
            return logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Integer getControlsCount() {
            return controlsCount;
        }

        @Override
        public final Builder controlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
            return this;
        }

        public final void setControlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
        }

        public final Integer getControlSetsCount() {
            return controlSetsCount;
        }

        @Override
        public final Builder controlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
            return this;
        }

        public final void setControlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public AssessmentFrameworkMetadata build() {
            return new AssessmentFrameworkMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
