/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata associated with the specified delegation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelegationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DelegationMetadata.Builder, DelegationMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DelegationMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(DelegationMetadata::assessmentName))
            .setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(DelegationMetadata::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DelegationMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DelegationMetadata::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DelegationMetadata::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> CONTROL_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetName").getter(getter(DelegationMetadata::controlSetName))
            .setter(setter(Builder::controlSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_ID_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD,
                    CONTROL_SET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String assessmentName;

    private final String assessmentId;

    private final String status;

    private final String roleArn;

    private final Instant creationTime;

    private final String controlSetName;

    private DelegationMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentName = builder.assessmentName;
        this.assessmentId = builder.assessmentId;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.controlSetName = builder.controlSetName;
    }

    /**
     * <p>
     * The unique identifier for the delegation.
     * </p>
     * 
     * @return The unique identifier for the delegation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the associated assessment.
     * </p>
     * 
     * @return The name of the associated assessment.
     */
    public String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The unique identifier for the specified assessment.
     * </p>
     * 
     * @return The unique identifier for the specified assessment.
     */
    public String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The current status of the delgation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DelegationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the delgation.
     * @see DelegationStatus
     */
    public DelegationStatus status() {
        return DelegationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the delgation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DelegationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the delgation.
     * @see DelegationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies when the delegation was created.
     * </p>
     * 
     * @return Specifies when the delegation was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Specifies the name of the control set delegated for review.
     * </p>
     * 
     * @return Specifies the name of the control set delegated for review.
     */
    public String controlSetName() {
        return controlSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationMetadata)) {
            return false;
        }
        DelegationMetadata other = (DelegationMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(controlSetName(), other.controlSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DelegationMetadata").add("Id", id()).add("AssessmentName", assessmentName())
                .add("AssessmentId", assessmentId()).add("Status", statusAsString()).add("RoleArn", roleArn())
                .add("CreationTime", creationTime()).add("ControlSetName", controlSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "controlSetName":
            return Optional.ofNullable(clazz.cast(controlSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelegationMetadata, T> g) {
        return obj -> g.apply((DelegationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelegationMetadata> {
        /**
         * <p>
         * The unique identifier for the delegation.
         * </p>
         * 
         * @param id
         *        The unique identifier for the delegation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the associated assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name of the associated assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The unique identifier for the specified assessment.
         * </p>
         * 
         * @param assessmentId
         *        The unique identifier for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The current status of the delgation.
         * </p>
         * 
         * @param status
         *        The current status of the delgation.
         * @see DelegationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DelegationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the delgation.
         * </p>
         * 
         * @param status
         *        The current status of the delgation.
         * @see DelegationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DelegationStatus
         */
        Builder status(DelegationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies when the delegation was created.
         * </p>
         * 
         * @param creationTime
         *        Specifies when the delegation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Specifies the name of the control set delegated for review.
         * </p>
         * 
         * @param controlSetName
         *        Specifies the name of the control set delegated for review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetName(String controlSetName);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String assessmentName;

        private String assessmentId;

        private String status;

        private String roleArn;

        private Instant creationTime;

        private String controlSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationMetadata model) {
            id(model.id);
            assessmentName(model.assessmentName);
            assessmentId(model.assessmentId);
            status(model.status);
            roleArn(model.roleArn);
            creationTime(model.creationTime);
            controlSetName(model.controlSetName);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DelegationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getControlSetName() {
            return controlSetName;
        }

        @Override
        public final Builder controlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
            return this;
        }

        public final void setControlSetName(String controlSetName) {
            this.controlSetName = controlSetName;
        }

        @Override
        public DelegationMetadata build() {
            return new DelegationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
