/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateAssessmentReportIntegrityResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ValidateAssessmentReportIntegrityResponse.Builder, ValidateAssessmentReportIntegrityResponse> {
    private static final SdkField<Boolean> SIGNATURE_VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("signatureValid").getter(getter(ValidateAssessmentReportIntegrityResponse::signatureValid))
            .setter(setter(Builder::signatureValid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValid").build()).build();

    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signatureAlgorithm").getter(getter(ValidateAssessmentReportIntegrityResponse::signatureAlgorithm))
            .setter(setter(Builder::signatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build())
            .build();

    private static final SdkField<String> SIGNATURE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signatureDateTime").getter(getter(ValidateAssessmentReportIntegrityResponse::signatureDateTime))
            .setter(setter(Builder::signatureDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureDateTime").build()).build();

    private static final SdkField<String> SIGNATURE_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signatureKeyId").getter(getter(ValidateAssessmentReportIntegrityResponse::signatureKeyId))
            .setter(setter(Builder::signatureKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureKeyId").build()).build();

    private static final SdkField<List<String>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("validationErrors")
            .getter(getter(ValidateAssessmentReportIntegrityResponse::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_VALID_FIELD,
            SIGNATURE_ALGORITHM_FIELD, SIGNATURE_DATE_TIME_FIELD, SIGNATURE_KEY_ID_FIELD, VALIDATION_ERRORS_FIELD));

    private final Boolean signatureValid;

    private final String signatureAlgorithm;

    private final String signatureDateTime;

    private final String signatureKeyId;

    private final List<String> validationErrors;

    private ValidateAssessmentReportIntegrityResponse(BuilderImpl builder) {
        super(builder);
        this.signatureValid = builder.signatureValid;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.signatureDateTime = builder.signatureDateTime;
        this.signatureKeyId = builder.signatureKeyId;
        this.validationErrors = builder.validationErrors;
    }

    /**
     * <p>
     * Specifies whether the signature key is valid.
     * </p>
     * 
     * @return Specifies whether the signature key is valid.
     */
    public Boolean signatureValid() {
        return signatureValid;
    }

    /**
     * <p>
     * The signature algorithm used to code sign the assessment report file.
     * </p>
     * 
     * @return The signature algorithm used to code sign the assessment report file.
     */
    public String signatureAlgorithm() {
        return signatureAlgorithm;
    }

    /**
     * <p>
     * The date and time signature that specifies when the assessment report was created.
     * </p>
     * 
     * @return The date and time signature that specifies when the assessment report was created.
     */
    public String signatureDateTime() {
        return signatureDateTime;
    }

    /**
     * <p>
     * The unique identifier for the validation signature key.
     * </p>
     * 
     * @return The unique identifier for the validation signature key.
     */
    public String signatureKeyId() {
        return signatureKeyId;
    }

    /**
     * Returns true if the ValidationErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationErrors() {
        return validationErrors != null && !(validationErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents any errors that occurred when validating the assessment report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents any errors that occurred when validating the assessment report.
     */
    public List<String> validationErrors() {
        return validationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signatureValid());
        hashCode = 31 * hashCode + Objects.hashCode(signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(signatureDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(signatureKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationErrors() ? validationErrors() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateAssessmentReportIntegrityResponse)) {
            return false;
        }
        ValidateAssessmentReportIntegrityResponse other = (ValidateAssessmentReportIntegrityResponse) obj;
        return Objects.equals(signatureValid(), other.signatureValid())
                && Objects.equals(signatureAlgorithm(), other.signatureAlgorithm())
                && Objects.equals(signatureDateTime(), other.signatureDateTime())
                && Objects.equals(signatureKeyId(), other.signatureKeyId())
                && hasValidationErrors() == other.hasValidationErrors()
                && Objects.equals(validationErrors(), other.validationErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ValidateAssessmentReportIntegrityResponse").add("SignatureValid", signatureValid())
                .add("SignatureAlgorithm", signatureAlgorithm()).add("SignatureDateTime", signatureDateTime())
                .add("SignatureKeyId", signatureKeyId())
                .add("ValidationErrors", hasValidationErrors() ? validationErrors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signatureValid":
            return Optional.ofNullable(clazz.cast(signatureValid()));
        case "signatureAlgorithm":
            return Optional.ofNullable(clazz.cast(signatureAlgorithm()));
        case "signatureDateTime":
            return Optional.ofNullable(clazz.cast(signatureDateTime()));
        case "signatureKeyId":
            return Optional.ofNullable(clazz.cast(signatureKeyId()));
        case "validationErrors":
            return Optional.ofNullable(clazz.cast(validationErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateAssessmentReportIntegrityResponse, T> g) {
        return obj -> g.apply((ValidateAssessmentReportIntegrityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateAssessmentReportIntegrityResponse> {
        /**
         * <p>
         * Specifies whether the signature key is valid.
         * </p>
         * 
         * @param signatureValid
         *        Specifies whether the signature key is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureValid(Boolean signatureValid);

        /**
         * <p>
         * The signature algorithm used to code sign the assessment report file.
         * </p>
         * 
         * @param signatureAlgorithm
         *        The signature algorithm used to code sign the assessment report file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureAlgorithm(String signatureAlgorithm);

        /**
         * <p>
         * The date and time signature that specifies when the assessment report was created.
         * </p>
         * 
         * @param signatureDateTime
         *        The date and time signature that specifies when the assessment report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureDateTime(String signatureDateTime);

        /**
         * <p>
         * The unique identifier for the validation signature key.
         * </p>
         * 
         * @param signatureKeyId
         *        The unique identifier for the validation signature key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureKeyId(String signatureKeyId);

        /**
         * <p>
         * Represents any errors that occurred when validating the assessment report.
         * </p>
         * 
         * @param validationErrors
         *        Represents any errors that occurred when validating the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<String> validationErrors);

        /**
         * <p>
         * Represents any errors that occurred when validating the assessment report.
         * </p>
         * 
         * @param validationErrors
         *        Represents any errors that occurred when validating the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(String... validationErrors);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private Boolean signatureValid;

        private String signatureAlgorithm;

        private String signatureDateTime;

        private String signatureKeyId;

        private List<String> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateAssessmentReportIntegrityResponse model) {
            super(model);
            signatureValid(model.signatureValid);
            signatureAlgorithm(model.signatureAlgorithm);
            signatureDateTime(model.signatureDateTime);
            signatureKeyId(model.signatureKeyId);
            validationErrors(model.validationErrors);
        }

        public final Boolean getSignatureValid() {
            return signatureValid;
        }

        @Override
        public final Builder signatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
            return this;
        }

        public final void setSignatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
        }

        public final String getSignatureAlgorithm() {
            return signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final String getSignatureDateTime() {
            return signatureDateTime;
        }

        @Override
        public final Builder signatureDateTime(String signatureDateTime) {
            this.signatureDateTime = signatureDateTime;
            return this;
        }

        public final void setSignatureDateTime(String signatureDateTime) {
            this.signatureDateTime = signatureDateTime;
        }

        public final String getSignatureKeyId() {
            return signatureKeyId;
        }

        @Override
        public final Builder signatureKeyId(String signatureKeyId) {
            this.signatureKeyId = signatureKeyId;
            return this;
        }

        public final void setSignatureKeyId(String signatureKeyId) {
            this.signatureKeyId = signatureKeyId;
        }

        public final Collection<String> getValidationErrors() {
            if (validationErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return validationErrors;
        }

        @Override
        public final Builder validationErrors(Collection<String> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(String... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        public final void setValidationErrors(Collection<String> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
        }

        @Override
        public ValidateAssessmentReportIntegrityResponse build() {
            return new ValidateAssessmentReportIntegrityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
