/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameworkMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameworkMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FrameworkMetadata.getter(FrameworkMetadata::name)).setter(FrameworkMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(FrameworkMetadata.getter(FrameworkMetadata::description)).setter(FrameworkMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logo").getter(FrameworkMetadata.getter(FrameworkMetadata::logo)).setter(FrameworkMetadata.setter(Builder::logo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(FrameworkMetadata.getter(FrameworkMetadata::complianceType)).setter(FrameworkMetadata.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, COMPLIANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String logo;
    private final String complianceType;

    private FrameworkMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.logo = builder.logo;
        this.complianceType = builder.complianceType;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String logo() {
        return this.logo;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameworkMetadata)) {
            return false;
        }
        FrameworkMetadata other = (FrameworkMetadata)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.logo(), other.logo()) && Objects.equals(this.complianceType(), other.complianceType());
    }

    public String toString() {
        return ToString.builder((String)"FrameworkMetadata").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Logo", (Object)this.logo()).add("ComplianceType", (Object)this.complianceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameworkMetadata, T> g) {
        return obj -> g.apply((FrameworkMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String logo;
        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameworkMetadata model) {
            this.name(model.name);
            this.description(model.description);
            this.logo(model.logo);
            this.complianceType(model.complianceType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogo() {
            return this.logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public FrameworkMetadata build() {
            return new FrameworkMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameworkMetadata> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder logo(String var1);

        public Builder complianceType(String var1);
    }
}

