/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.Notification;
import software.amazon.awssdk.services.auditmanager.model.NotificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListNotificationsResponse> {
    private static final SdkField<List<Notification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notifications").getter(ListNotificationsResponse.getter(ListNotificationsResponse::notifications)).setter(ListNotificationsResponse.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationsResponse.getter(ListNotificationsResponse::nextToken)).setter(ListNotificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Notification> notifications;
    private final String nextToken;

    private ListNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    public boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsResponse)) {
            return false;
        }
        ListNotificationsResponse other = (ListNotificationsResponse)((Object)obj);
        return this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNotificationsResponse").add("Notifications", this.hasNotifications() ? this.notifications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsResponse, T> g) {
        return obj -> g.apply((ListNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<Notification> notifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsResponse model) {
            super(model);
            this.notifications(model.notifications);
            this.nextToken(model.nextToken);
        }

        public final Collection<Notification.Builder> getNotifications() {
            if (this.notifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notifications != null ? (Collection)this.notifications.stream().map(Notification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<Notification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (Notification)((Notification.Builder)Notification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotifications(Collection<Notification.BuilderImpl> notifications) {
            this.notifications = NotificationsCopier.copyFromBuilder(notifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNotificationsResponse build() {
            return new ListNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationsResponse> {
        public Builder notifications(Collection<Notification> var1);

        public Builder notifications(Notification ... var1);

        public Builder notifications(Consumer<Notification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

