/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error entity for the <code>BatchCreateDelegationByAssessment</code> API. This is used to provide more meaningful
 * errors than a simple string message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateDelegationByAssessmentError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateDelegationByAssessmentError.Builder, BatchCreateDelegationByAssessmentError> {
    private static final SdkField<CreateDelegationRequest> CREATE_DELEGATION_REQUEST_FIELD = SdkField
            .<CreateDelegationRequest> builder(MarshallingType.SDK_POJO).memberName("createDelegationRequest")
            .getter(getter(BatchCreateDelegationByAssessmentError::createDelegationRequest))
            .setter(setter(Builder::createDelegationRequest)).constructor(CreateDelegationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDelegationRequest").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchCreateDelegationByAssessmentError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchCreateDelegationByAssessmentError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CREATE_DELEGATION_REQUEST_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateDelegationRequest createDelegationRequest;

    private final String errorCode;

    private final String errorMessage;

    private BatchCreateDelegationByAssessmentError(BuilderImpl builder) {
        this.createDelegationRequest = builder.createDelegationRequest;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The API request to batch create delegations in AWS Audit Manager.
     * </p>
     * 
     * @return The API request to batch create delegations in AWS Audit Manager.
     */
    public CreateDelegationRequest createDelegationRequest() {
        return createDelegationRequest;
    }

    /**
     * <p>
     * The error code returned by the <code>BatchCreateDelegationByAssessment</code> API.
     * </p>
     * 
     * @return The error code returned by the <code>BatchCreateDelegationByAssessment</code> API.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message returned by the <code>BatchCreateDelegationByAssessment</code> API.
     * </p>
     * 
     * @return The error message returned by the <code>BatchCreateDelegationByAssessment</code> API.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createDelegationRequest());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentError)) {
            return false;
        }
        BatchCreateDelegationByAssessmentError other = (BatchCreateDelegationByAssessmentError) obj;
        return Objects.equals(createDelegationRequest(), other.createDelegationRequest())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchCreateDelegationByAssessmentError")
                .add("CreateDelegationRequest", createDelegationRequest()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createDelegationRequest":
            return Optional.ofNullable(clazz.cast(createDelegationRequest()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentError, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateDelegationByAssessmentError> {
        /**
         * <p>
         * The API request to batch create delegations in AWS Audit Manager.
         * </p>
         * 
         * @param createDelegationRequest
         *        The API request to batch create delegations in AWS Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDelegationRequest(CreateDelegationRequest createDelegationRequest);

        /**
         * <p>
         * The API request to batch create delegations in AWS Audit Manager.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateDelegationRequest.Builder} avoiding the
         * need to create one manually via {@link CreateDelegationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateDelegationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #createDelegationRequest(CreateDelegationRequest)}.
         * 
         * @param createDelegationRequest
         *        a consumer that will call methods on {@link CreateDelegationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDelegationRequest(CreateDelegationRequest)
         */
        default Builder createDelegationRequest(Consumer<CreateDelegationRequest.Builder> createDelegationRequest) {
            return createDelegationRequest(CreateDelegationRequest.builder().applyMutation(createDelegationRequest).build());
        }

        /**
         * <p>
         * The error code returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errorCode
         *        The error code returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned by the <code>BatchCreateDelegationByAssessment</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private CreateDelegationRequest createDelegationRequest;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentError model) {
            createDelegationRequest(model.createDelegationRequest);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final CreateDelegationRequest.Builder getCreateDelegationRequest() {
            return createDelegationRequest != null ? createDelegationRequest.toBuilder() : null;
        }

        @Override
        public final Builder createDelegationRequest(CreateDelegationRequest createDelegationRequest) {
            this.createDelegationRequest = createDelegationRequest;
            return this;
        }

        public final void setCreateDelegationRequest(CreateDelegationRequest.BuilderImpl createDelegationRequest) {
            this.createDelegationRequest = createDelegationRequest != null ? createDelegationRequest.build() : null;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchCreateDelegationByAssessmentError build() {
            return new BatchCreateDelegationByAssessmentError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
