/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.FrameworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentFrameworkMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentFrameworkMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::id)).setter(AssessmentFrameworkMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::typeAsString)).setter(AssessmentFrameworkMetadata.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::name)).setter(AssessmentFrameworkMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::description)).setter(AssessmentFrameworkMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logo").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::logo)).setter(AssessmentFrameworkMetadata.setter(Builder::logo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::complianceType)).setter(AssessmentFrameworkMetadata.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final SdkField<Integer> CONTROLS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("controlsCount").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::controlsCount)).setter(AssessmentFrameworkMetadata.setter(Builder::controlsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlsCount").build()}).build();
    private static final SdkField<Integer> CONTROL_SETS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("controlSetsCount").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::controlSetsCount)).setter(AssessmentFrameworkMetadata.setter(Builder::controlSetsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetsCount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::createdAt)).setter(AssessmentFrameworkMetadata.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(AssessmentFrameworkMetadata.getter(AssessmentFrameworkMetadata::lastUpdatedAt)).setter(AssessmentFrameworkMetadata.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, COMPLIANCE_TYPE_FIELD, CONTROLS_COUNT_FIELD, CONTROL_SETS_COUNT_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String name;
    private final String description;
    private final String logo;
    private final String complianceType;
    private final Integer controlsCount;
    private final Integer controlSetsCount;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private AssessmentFrameworkMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.logo = builder.logo;
        this.complianceType = builder.complianceType;
        this.controlsCount = builder.controlsCount;
        this.controlSetsCount = builder.controlSetsCount;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public String id() {
        return this.id;
    }

    public FrameworkType type() {
        return FrameworkType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String logo() {
        return this.logo;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public Integer controlsCount() {
        return this.controlsCount;
    }

    public Integer controlSetsCount() {
        return this.controlSetsCount;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFrameworkMetadata)) {
            return false;
        }
        AssessmentFrameworkMetadata other = (AssessmentFrameworkMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.logo(), other.logo()) && Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.controlsCount(), other.controlsCount()) && Objects.equals(this.controlSetsCount(), other.controlSetsCount()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public String toString() {
        return ToString.builder((String)"AssessmentFrameworkMetadata").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Logo", (Object)this.logo()).add("ComplianceType", (Object)this.complianceType()).add("ControlsCount", (Object)this.controlsCount()).add("ControlSetsCount", (Object)this.controlSetsCount()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "controlsCount": {
                return Optional.ofNullable(clazz.cast(this.controlsCount()));
            }
            case "controlSetsCount": {
                return Optional.ofNullable(clazz.cast(this.controlSetsCount()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFrameworkMetadata, T> g) {
        return obj -> g.apply((AssessmentFrameworkMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String name;
        private String description;
        private String logo;
        private String complianceType;
        private Integer controlsCount;
        private Integer controlSetsCount;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFrameworkMetadata model) {
            this.id(model.id);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.logo(model.logo);
            this.complianceType(model.complianceType);
            this.controlsCount(model.controlsCount);
            this.controlSetsCount(model.controlSetsCount);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FrameworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogo() {
            return this.logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final Integer getControlsCount() {
            return this.controlsCount;
        }

        @Override
        public final Builder controlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
            return this;
        }

        public final void setControlsCount(Integer controlsCount) {
            this.controlsCount = controlsCount;
        }

        public final Integer getControlSetsCount() {
            return this.controlSetsCount;
        }

        @Override
        public final Builder controlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
            return this;
        }

        public final void setControlSetsCount(Integer controlSetsCount) {
            this.controlSetsCount = controlSetsCount;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public AssessmentFrameworkMetadata build() {
            return new AssessmentFrameworkMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentFrameworkMetadata> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(FrameworkType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder logo(String var1);

        public Builder complianceType(String var1);

        public Builder controlsCount(Integer var1);

        public Builder controlSetsCount(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

