/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error entity for the <code>BatchImportEvidenceToAssessmentControl</code> API. This is used to provide more
 * meaningful errors than a simple string message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchImportEvidenceToAssessmentControlError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchImportEvidenceToAssessmentControlError.Builder, BatchImportEvidenceToAssessmentControlError> {
    private static final SdkField<ManualEvidence> MANUAL_EVIDENCE_FIELD = SdkField
            .<ManualEvidence> builder(MarshallingType.SDK_POJO).memberName("manualEvidence")
            .getter(getter(BatchImportEvidenceToAssessmentControlError::manualEvidence)).setter(setter(Builder::manualEvidence))
            .constructor(ManualEvidence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualEvidence").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchImportEvidenceToAssessmentControlError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchImportEvidenceToAssessmentControlError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANUAL_EVIDENCE_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ManualEvidence manualEvidence;

    private final String errorCode;

    private final String errorMessage;

    private BatchImportEvidenceToAssessmentControlError(BuilderImpl builder) {
        this.manualEvidence = builder.manualEvidence;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Manual evidence that cannot be collected automatically by AWS Audit Manager.
     * </p>
     * 
     * @return Manual evidence that cannot be collected automatically by AWS Audit Manager.
     */
    public ManualEvidence manualEvidence() {
        return manualEvidence;
    }

    /**
     * <p>
     * The error code returned by the <code>BatchImportEvidenceToAssessmentControl</code> API.
     * </p>
     * 
     * @return The error code returned by the <code>BatchImportEvidenceToAssessmentControl</code> API.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message returned by the <code>BatchImportEvidenceToAssessmentControlError</code> API.
     * </p>
     * 
     * @return The error message returned by the <code>BatchImportEvidenceToAssessmentControlError</code> API.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manualEvidence());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportEvidenceToAssessmentControlError)) {
            return false;
        }
        BatchImportEvidenceToAssessmentControlError other = (BatchImportEvidenceToAssessmentControlError) obj;
        return Objects.equals(manualEvidence(), other.manualEvidence()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchImportEvidenceToAssessmentControlError").add("ManualEvidence", manualEvidence())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "manualEvidence":
            return Optional.ofNullable(clazz.cast(manualEvidence()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImportEvidenceToAssessmentControlError, T> g) {
        return obj -> g.apply((BatchImportEvidenceToAssessmentControlError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchImportEvidenceToAssessmentControlError> {
        /**
         * <p>
         * Manual evidence that cannot be collected automatically by AWS Audit Manager.
         * </p>
         * 
         * @param manualEvidence
         *        Manual evidence that cannot be collected automatically by AWS Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualEvidence(ManualEvidence manualEvidence);

        /**
         * <p>
         * Manual evidence that cannot be collected automatically by AWS Audit Manager.
         * </p>
         * This is a convenience that creates an instance of the {@link ManualEvidence.Builder} avoiding the need to
         * create one manually via {@link ManualEvidence#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManualEvidence.Builder#build()} is called immediately and its
         * result is passed to {@link #manualEvidence(ManualEvidence)}.
         * 
         * @param manualEvidence
         *        a consumer that will call methods on {@link ManualEvidence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manualEvidence(ManualEvidence)
         */
        default Builder manualEvidence(Consumer<ManualEvidence.Builder> manualEvidence) {
            return manualEvidence(ManualEvidence.builder().applyMutation(manualEvidence).build());
        }

        /**
         * <p>
         * The error code returned by the <code>BatchImportEvidenceToAssessmentControl</code> API.
         * </p>
         * 
         * @param errorCode
         *        The error code returned by the <code>BatchImportEvidenceToAssessmentControl</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message returned by the <code>BatchImportEvidenceToAssessmentControlError</code> API.
         * </p>
         * 
         * @param errorMessage
         *        The error message returned by the <code>BatchImportEvidenceToAssessmentControlError</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private ManualEvidence manualEvidence;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportEvidenceToAssessmentControlError model) {
            manualEvidence(model.manualEvidence);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final ManualEvidence.Builder getManualEvidence() {
            return manualEvidence != null ? manualEvidence.toBuilder() : null;
        }

        @Override
        public final Builder manualEvidence(ManualEvidence manualEvidence) {
            this.manualEvidence = manualEvidence;
            return this;
        }

        public final void setManualEvidence(ManualEvidence.BuilderImpl manualEvidence) {
            this.manualEvidence = manualEvidence != null ? manualEvidence.build() : null;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchImportEvidenceToAssessmentControlError build() {
            return new BatchImportEvidenceToAssessmentControlError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
