/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control in AWS Audit Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Control implements SdkPojo, Serializable, ToCopyableBuilder<Control.Builder, Control> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Control::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Control::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Control::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Control::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Control::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testingInformation").getter(getter(Control::testingInformation))
            .setter(setter(Builder::testingInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build())
            .build();

    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanTitle").getter(getter(Control::actionPlanTitle)).setter(setter(Builder::actionPlanTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()).build();

    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanInstructions").getter(getter(Control::actionPlanInstructions))
            .setter(setter(Builder::actionPlanInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build())
            .build();

    private static final SdkField<String> CONTROL_SOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSources").getter(getter(Control::controlSources)).setter(setter(Builder::controlSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSources").build()).build();

    private static final SdkField<List<ControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField
            .<List<ControlMappingSource>> builder(MarshallingType.LIST)
            .memberName("controlMappingSources")
            .getter(getter(Control::controlMappingSources))
            .setter(setter(Builder::controlMappingSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlMappingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlMappingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Control::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(Control::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(Control::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(Control::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Control::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD,
            ACTION_PLAN_INSTRUCTIONS_FIELD, CONTROL_SOURCES_FIELD, CONTROL_MAPPING_SOURCES_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String type;

    private final String name;

    private final String description;

    private final String testingInformation;

    private final String actionPlanTitle;

    private final String actionPlanInstructions;

    private final String controlSources;

    private final List<ControlMappingSource> controlMappingSources;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String createdBy;

    private final String lastUpdatedBy;

    private final Map<String, String> tags;

    private Control(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlSources = builder.controlSources;
        this.controlMappingSources = builder.controlMappingSources;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified control.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the control.
     * </p>
     * 
     * @return The unique identifier for the control.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The type of control, such as custom or standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of control, such as custom or standard.
     * @see ControlType
     */
    public ControlType type() {
        return ControlType.fromValue(type);
    }

    /**
     * <p>
     * The type of control, such as custom or standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of control, such as custom or standard.
     * @see ControlType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the specified control.
     * </p>
     * 
     * @return The name of the specified control.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the specified control.
     * </p>
     * 
     * @return The description of the specified control.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The steps to follow to determine if the control has been satisfied.
     * </p>
     * 
     * @return The steps to follow to determine if the control has been satisfied.
     */
    public String testingInformation() {
        return testingInformation;
    }

    /**
     * <p>
     * The title of the action plan for remediating the control.
     * </p>
     * 
     * @return The title of the action plan for remediating the control.
     */
    public String actionPlanTitle() {
        return actionPlanTitle;
    }

    /**
     * <p>
     * The recommended actions to carry out if the control is not fulfilled.
     * </p>
     * 
     * @return The recommended actions to carry out if the control is not fulfilled.
     */
    public String actionPlanInstructions() {
        return actionPlanInstructions;
    }

    /**
     * <p>
     * The data mapping sources for the specified control.
     * </p>
     * 
     * @return The data mapping sources for the specified control.
     */
    public String controlSources() {
        return controlSources;
    }

    /**
     * Returns true if the ControlMappingSources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasControlMappingSources() {
        return controlMappingSources != null && !(controlMappingSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data mapping sources for the specified control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControlMappingSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data mapping sources for the specified control.
     */
    public List<ControlMappingSource> controlMappingSources() {
        return controlMappingSources;
    }

    /**
     * <p>
     * Specifies when the control was created.
     * </p>
     * 
     * @return Specifies when the control was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the control was most recently updated.
     * </p>
     * 
     * @return Specifies when the control was most recently updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The IAM user or role that created the control.
     * </p>
     * 
     * @return The IAM user or role that created the control.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The IAM user or role that most recently updated the control.
     * </p>
     * 
     * @return The IAM user or role that most recently updated the control.
     */
    public String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the control.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(controlSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlMappingSources() ? controlMappingSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Control)) {
            return false;
        }
        Control other = (Control) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(testingInformation(), other.testingInformation())
                && Objects.equals(actionPlanTitle(), other.actionPlanTitle())
                && Objects.equals(actionPlanInstructions(), other.actionPlanInstructions())
                && Objects.equals(controlSources(), other.controlSources())
                && hasControlMappingSources() == other.hasControlMappingSources()
                && Objects.equals(controlMappingSources(), other.controlMappingSources())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Control").add("Arn", arn()).add("Id", id()).add("Type", typeAsString()).add("Name", name())
                .add("Description", description()).add("TestingInformation", testingInformation())
                .add("ActionPlanTitle", actionPlanTitle()).add("ActionPlanInstructions", actionPlanInstructions())
                .add("ControlSources", controlSources())
                .add("ControlMappingSources", hasControlMappingSources() ? controlMappingSources() : null)
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("CreatedBy", createdBy())
                .add("LastUpdatedBy", lastUpdatedBy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "testingInformation":
            return Optional.ofNullable(clazz.cast(testingInformation()));
        case "actionPlanTitle":
            return Optional.ofNullable(clazz.cast(actionPlanTitle()));
        case "actionPlanInstructions":
            return Optional.ofNullable(clazz.cast(actionPlanInstructions()));
        case "controlSources":
            return Optional.ofNullable(clazz.cast(controlSources()));
        case "controlMappingSources":
            return Optional.ofNullable(clazz.cast(controlMappingSources()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Control, T> g) {
        return obj -> g.apply((Control) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Control> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified control.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the control.
         * </p>
         * 
         * @param id
         *        The unique identifier for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of control, such as custom or standard.
         * </p>
         * 
         * @param type
         *        The type of control, such as custom or standard.
         * @see ControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of control, such as custom or standard.
         * </p>
         * 
         * @param type
         *        The type of control, such as custom or standard.
         * @see ControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ControlType
         */
        Builder type(ControlType type);

        /**
         * <p>
         * The name of the specified control.
         * </p>
         * 
         * @param name
         *        The name of the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the specified control.
         * </p>
         * 
         * @param description
         *        The description of the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The steps to follow to determine if the control has been satisfied.
         * </p>
         * 
         * @param testingInformation
         *        The steps to follow to determine if the control has been satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingInformation(String testingInformation);

        /**
         * <p>
         * The title of the action plan for remediating the control.
         * </p>
         * 
         * @param actionPlanTitle
         *        The title of the action plan for remediating the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanTitle(String actionPlanTitle);

        /**
         * <p>
         * The recommended actions to carry out if the control is not fulfilled.
         * </p>
         * 
         * @param actionPlanInstructions
         *        The recommended actions to carry out if the control is not fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanInstructions(String actionPlanInstructions);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * 
         * @param controlSources
         *        The data mapping sources for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSources(String controlSources);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(ControlMappingSource... controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ControlMappingSource>.Builder} avoiding the
         * need to create one manually via {@link List<ControlMappingSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ControlMappingSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #controlMappingSources(List<ControlMappingSource>)}.
         * 
         * @param controlMappingSources
         *        a consumer that will call methods on {@link List<ControlMappingSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlMappingSources(List<ControlMappingSource>)
         */
        Builder controlMappingSources(Consumer<ControlMappingSource.Builder>... controlMappingSources);

        /**
         * <p>
         * Specifies when the control was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the control was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the control was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the control was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The IAM user or role that created the control.
         * </p>
         * 
         * @param createdBy
         *        The IAM user or role that created the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The IAM user or role that most recently updated the control.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The IAM user or role that most recently updated the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The tags associated with the control.
         * </p>
         * 
         * @param tags
         *        The tags associated with the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String type;

        private String name;

        private String description;

        private String testingInformation;

        private String actionPlanTitle;

        private String actionPlanInstructions;

        private String controlSources;

        private List<ControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String createdBy;

        private String lastUpdatedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Control model) {
            arn(model.arn);
            id(model.id);
            type(model.type);
            name(model.name);
            description(model.description);
            testingInformation(model.testingInformation);
            actionPlanTitle(model.actionPlanTitle);
            actionPlanInstructions(model.actionPlanInstructions);
            controlSources(model.controlSources);
            controlMappingSources(model.controlMappingSources);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            createdBy(model.createdBy);
            lastUpdatedBy(model.lastUpdatedBy);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ControlType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTestingInformation() {
            return testingInformation;
        }

        @Override
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        public final String getActionPlanTitle() {
            return actionPlanTitle;
        }

        @Override
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        public final String getActionPlanInstructions() {
            return actionPlanInstructions;
        }

        @Override
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        public final String getControlSources() {
            return controlSources;
        }

        @Override
        public final Builder controlSources(String controlSources) {
            this.controlSources = controlSources;
            return this;
        }

        public final void setControlSources(String controlSources) {
            this.controlSources = controlSources;
        }

        public final Collection<ControlMappingSource.Builder> getControlMappingSources() {
            if (controlMappingSources instanceof SdkAutoConstructList) {
                return null;
            }
            return controlMappingSources != null ? controlMappingSources.stream().map(ControlMappingSource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(ControlMappingSource... controlMappingSources) {
            controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<ControlMappingSource.Builder>... controlMappingSources) {
            controlMappingSources(Stream.of(controlMappingSources)
                    .map(c -> ControlMappingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControlMappingSources(Collection<ControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Control build() {
            return new Control(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
