/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.ControlMappingSource;
import software.amazon.awssdk.services.auditmanager.model.ControlMappingSourcesCopier;
import software.amazon.awssdk.services.auditmanager.model.ControlType;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Control
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Control> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Control.getter(Control::arn)).setter(Control.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Control.getter(Control::id)).setter(Control.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Control.getter(Control::typeAsString)).setter(Control.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Control.getter(Control::name)).setter(Control.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Control.getter(Control::description)).setter(Control.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testingInformation").getter(Control.getter(Control::testingInformation)).setter(Control.setter(Builder::testingInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build()}).build();
    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanTitle").getter(Control.getter(Control::actionPlanTitle)).setter(Control.setter(Builder::actionPlanTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()}).build();
    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanInstructions").getter(Control.getter(Control::actionPlanInstructions)).setter(Control.setter(Builder::actionPlanInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build()}).build();
    private static final SdkField<String> CONTROL_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSources").getter(Control.getter(Control::controlSources)).setter(Control.setter(Builder::controlSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSources").build()}).build();
    private static final SdkField<List<ControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlMappingSources").getter(Control.getter(Control::controlMappingSources)).setter(Control.setter(Builder::controlMappingSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlMappingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Control.getter(Control::createdAt)).setter(Control.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(Control.getter(Control::lastUpdatedAt)).setter(Control.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(Control.getter(Control::createdBy)).setter(Control.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(Control.getter(Control::lastUpdatedBy)).setter(Control.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Control.getter(Control::tags)).setter(Control.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD, ACTION_PLAN_INSTRUCTIONS_FIELD, CONTROL_SOURCES_FIELD, CONTROL_MAPPING_SOURCES_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String type;
    private final String name;
    private final String description;
    private final String testingInformation;
    private final String actionPlanTitle;
    private final String actionPlanInstructions;
    private final String controlSources;
    private final List<ControlMappingSource> controlMappingSources;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String createdBy;
    private final String lastUpdatedBy;
    private final Map<String, String> tags;

    private Control(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlSources = builder.controlSources;
        this.controlMappingSources = builder.controlMappingSources;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String id() {
        return this.id;
    }

    public ControlType type() {
        return ControlType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String testingInformation() {
        return this.testingInformation;
    }

    public String actionPlanTitle() {
        return this.actionPlanTitle;
    }

    public String actionPlanInstructions() {
        return this.actionPlanInstructions;
    }

    public String controlSources() {
        return this.controlSources;
    }

    public boolean hasControlMappingSources() {
        return this.controlMappingSources != null && !(this.controlMappingSources instanceof SdkAutoConstructList);
    }

    public List<ControlMappingSource> controlMappingSources() {
        return this.controlMappingSources;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlMappingSources() ? this.controlMappingSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Control)) {
            return false;
        }
        Control other = (Control)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.testingInformation(), other.testingInformation()) && Objects.equals(this.actionPlanTitle(), other.actionPlanTitle()) && Objects.equals(this.actionPlanInstructions(), other.actionPlanInstructions()) && Objects.equals(this.controlSources(), other.controlSources()) && this.hasControlMappingSources() == other.hasControlMappingSources() && Objects.equals(this.controlMappingSources(), other.controlMappingSources()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Control").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TestingInformation", (Object)this.testingInformation()).add("ActionPlanTitle", (Object)this.actionPlanTitle()).add("ActionPlanInstructions", (Object)this.actionPlanInstructions()).add("ControlSources", (Object)this.controlSources()).add("ControlMappingSources", this.hasControlMappingSources() ? this.controlMappingSources() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("CreatedBy", (Object)this.createdBy()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "testingInformation": {
                return Optional.ofNullable(clazz.cast(this.testingInformation()));
            }
            case "actionPlanTitle": {
                return Optional.ofNullable(clazz.cast(this.actionPlanTitle()));
            }
            case "actionPlanInstructions": {
                return Optional.ofNullable(clazz.cast(this.actionPlanInstructions()));
            }
            case "controlSources": {
                return Optional.ofNullable(clazz.cast(this.controlSources()));
            }
            case "controlMappingSources": {
                return Optional.ofNullable(clazz.cast(this.controlMappingSources()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Control, T> g) {
        return obj -> g.apply((Control)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String type;
        private String name;
        private String description;
        private String testingInformation;
        private String actionPlanTitle;
        private String actionPlanInstructions;
        private String controlSources;
        private List<ControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String createdBy;
        private String lastUpdatedBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Control model) {
            this.arn(model.arn);
            this.id(model.id);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.testingInformation(model.testingInformation);
            this.actionPlanTitle(model.actionPlanTitle);
            this.actionPlanInstructions(model.actionPlanInstructions);
            this.controlSources(model.controlSources);
            this.controlMappingSources(model.controlMappingSources);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.createdBy(model.createdBy);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ControlType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTestingInformation() {
            return this.testingInformation;
        }

        @Override
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        public final String getActionPlanTitle() {
            return this.actionPlanTitle;
        }

        @Override
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        public final String getActionPlanInstructions() {
            return this.actionPlanInstructions;
        }

        @Override
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        public final String getControlSources() {
            return this.controlSources;
        }

        @Override
        public final Builder controlSources(String controlSources) {
            this.controlSources = controlSources;
            return this;
        }

        public final void setControlSources(String controlSources) {
            this.controlSources = controlSources;
        }

        public final Collection<ControlMappingSource.Builder> getControlMappingSources() {
            if (this.controlMappingSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlMappingSources != null ? (Collection)this.controlMappingSources.stream().map(ControlMappingSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(ControlMappingSource ... controlMappingSources) {
            this.controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<ControlMappingSource.Builder> ... controlMappingSources) {
            this.controlMappingSources(Stream.of(controlMappingSources).map(c -> (ControlMappingSource)((ControlMappingSource.Builder)ControlMappingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControlMappingSources(Collection<ControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public Control build() {
            return new Control(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Control> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ControlType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder testingInformation(String var1);

        public Builder actionPlanTitle(String var1);

        public Builder actionPlanInstructions(String var1);

        public Builder controlSources(String var1);

        public Builder controlMappingSources(Collection<ControlMappingSource> var1);

        public Builder controlMappingSources(ControlMappingSource ... var1);

        public Builder controlMappingSources(Consumer<ControlMappingSource.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

