/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.SourceFrequency;
import software.amazon.awssdk.services.auditmanager.model.SourceKeyword;
import software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption;
import software.amazon.awssdk.services.auditmanager.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlMappingSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlMappingSource> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceId").getter(ControlMappingSource.getter(ControlMappingSource::sourceId)).setter(ControlMappingSource.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(ControlMappingSource.getter(ControlMappingSource::sourceName)).setter(ControlMappingSource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<String> SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceDescription").getter(ControlMappingSource.getter(ControlMappingSource::sourceDescription)).setter(ControlMappingSource.setter(Builder::sourceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDescription").build()}).build();
    private static final SdkField<String> SOURCE_SET_UP_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSetUpOption").getter(ControlMappingSource.getter(ControlMappingSource::sourceSetUpOptionAsString)).setter(ControlMappingSource.setter(Builder::sourceSetUpOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSetUpOption").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(ControlMappingSource.getter(ControlMappingSource::sourceTypeAsString)).setter(ControlMappingSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<SourceKeyword> SOURCE_KEYWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceKeyword").getter(ControlMappingSource.getter(ControlMappingSource::sourceKeyword)).setter(ControlMappingSource.setter(Builder::sourceKeyword)).constructor(SourceKeyword::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKeyword").build()}).build();
    private static final SdkField<String> SOURCE_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFrequency").getter(ControlMappingSource.getter(ControlMappingSource::sourceFrequencyAsString)).setter(ControlMappingSource.setter(Builder::sourceFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFrequency").build()}).build();
    private static final SdkField<String> TROUBLESHOOTING_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("troubleshootingText").getter(ControlMappingSource.getter(ControlMappingSource::troubleshootingText)).setter(ControlMappingSource.setter(Builder::troubleshootingText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("troubleshootingText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD, SOURCE_NAME_FIELD, SOURCE_DESCRIPTION_FIELD, SOURCE_SET_UP_OPTION_FIELD, SOURCE_TYPE_FIELD, SOURCE_KEYWORD_FIELD, SOURCE_FREQUENCY_FIELD, TROUBLESHOOTING_TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceId;
    private final String sourceName;
    private final String sourceDescription;
    private final String sourceSetUpOption;
    private final String sourceType;
    private final SourceKeyword sourceKeyword;
    private final String sourceFrequency;
    private final String troubleshootingText;

    private ControlMappingSource(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.sourceName = builder.sourceName;
        this.sourceDescription = builder.sourceDescription;
        this.sourceSetUpOption = builder.sourceSetUpOption;
        this.sourceType = builder.sourceType;
        this.sourceKeyword = builder.sourceKeyword;
        this.sourceFrequency = builder.sourceFrequency;
        this.troubleshootingText = builder.troubleshootingText;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String sourceDescription() {
        return this.sourceDescription;
    }

    public SourceSetUpOption sourceSetUpOption() {
        return SourceSetUpOption.fromValue(this.sourceSetUpOption);
    }

    public String sourceSetUpOptionAsString() {
        return this.sourceSetUpOption;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public SourceKeyword sourceKeyword() {
        return this.sourceKeyword;
    }

    public SourceFrequency sourceFrequency() {
        return SourceFrequency.fromValue(this.sourceFrequency);
    }

    public String sourceFrequencyAsString() {
        return this.sourceFrequency;
    }

    public String troubleshootingText() {
        return this.troubleshootingText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSetUpOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyword());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.troubleshootingText());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlMappingSource)) {
            return false;
        }
        ControlMappingSource other = (ControlMappingSource)obj;
        return Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceDescription(), other.sourceDescription()) && Objects.equals(this.sourceSetUpOptionAsString(), other.sourceSetUpOptionAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceKeyword(), other.sourceKeyword()) && Objects.equals(this.sourceFrequencyAsString(), other.sourceFrequencyAsString()) && Objects.equals(this.troubleshootingText(), other.troubleshootingText());
    }

    public String toString() {
        return ToString.builder((String)"ControlMappingSource").add("SourceId", (Object)this.sourceId()).add("SourceName", (Object)this.sourceName()).add("SourceDescription", (Object)this.sourceDescription()).add("SourceSetUpOption", (Object)this.sourceSetUpOptionAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("SourceKeyword", (Object)this.sourceKeyword()).add("SourceFrequency", (Object)this.sourceFrequencyAsString()).add("TroubleshootingText", (Object)this.troubleshootingText()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "sourceDescription": {
                return Optional.ofNullable(clazz.cast(this.sourceDescription()));
            }
            case "sourceSetUpOption": {
                return Optional.ofNullable(clazz.cast(this.sourceSetUpOptionAsString()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "sourceKeyword": {
                return Optional.ofNullable(clazz.cast(this.sourceKeyword()));
            }
            case "sourceFrequency": {
                return Optional.ofNullable(clazz.cast(this.sourceFrequencyAsString()));
            }
            case "troubleshootingText": {
                return Optional.ofNullable(clazz.cast(this.troubleshootingText()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlMappingSource, T> g) {
        return obj -> g.apply((ControlMappingSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceId;
        private String sourceName;
        private String sourceDescription;
        private String sourceSetUpOption;
        private String sourceType;
        private SourceKeyword sourceKeyword;
        private String sourceFrequency;
        private String troubleshootingText;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlMappingSource model) {
            this.sourceId(model.sourceId);
            this.sourceName(model.sourceName);
            this.sourceDescription(model.sourceDescription);
            this.sourceSetUpOption(model.sourceSetUpOption);
            this.sourceType(model.sourceType);
            this.sourceKeyword(model.sourceKeyword);
            this.sourceFrequency(model.sourceFrequency);
            this.troubleshootingText(model.troubleshootingText);
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getSourceDescription() {
            return this.sourceDescription;
        }

        @Override
        public final Builder sourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
            return this;
        }

        public final void setSourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
        }

        public final String getSourceSetUpOption() {
            return this.sourceSetUpOption;
        }

        @Override
        public final Builder sourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
            return this;
        }

        @Override
        public final Builder sourceSetUpOption(SourceSetUpOption sourceSetUpOption) {
            this.sourceSetUpOption(sourceSetUpOption == null ? null : sourceSetUpOption.toString());
            return this;
        }

        public final void setSourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final SourceKeyword.Builder getSourceKeyword() {
            return this.sourceKeyword != null ? this.sourceKeyword.toBuilder() : null;
        }

        @Override
        public final Builder sourceKeyword(SourceKeyword sourceKeyword) {
            this.sourceKeyword = sourceKeyword;
            return this;
        }

        public final void setSourceKeyword(SourceKeyword.BuilderImpl sourceKeyword) {
            this.sourceKeyword = sourceKeyword != null ? sourceKeyword.build() : null;
        }

        public final String getSourceFrequency() {
            return this.sourceFrequency;
        }

        @Override
        public final Builder sourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
            return this;
        }

        @Override
        public final Builder sourceFrequency(SourceFrequency sourceFrequency) {
            this.sourceFrequency(sourceFrequency == null ? null : sourceFrequency.toString());
            return this;
        }

        public final void setSourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
        }

        public final String getTroubleshootingText() {
            return this.troubleshootingText;
        }

        @Override
        public final Builder troubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
            return this;
        }

        public final void setTroubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
        }

        public ControlMappingSource build() {
            return new ControlMappingSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlMappingSource> {
        public Builder sourceId(String var1);

        public Builder sourceName(String var1);

        public Builder sourceDescription(String var1);

        public Builder sourceSetUpOption(String var1);

        public Builder sourceSetUpOption(SourceSetUpOption var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceKeyword(SourceKeyword var1);

        default public Builder sourceKeyword(Consumer<SourceKeyword.Builder> sourceKeyword) {
            return this.sourceKeyword((SourceKeyword)((SourceKeyword.Builder)SourceKeyword.builder().applyMutation(sourceKeyword)).build());
        }

        public Builder sourceFrequency(String var1);

        public Builder sourceFrequency(SourceFrequency var1);

        public Builder troubleshootingText(String var1);
    }
}

