/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.services.auditmanager.model.Scope;
import software.amazon.awssdk.services.auditmanager.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssessmentRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, CreateAssessmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::name)).setter(CreateAssessmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::description)).setter(CreateAssessmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AssessmentReportsDestination> ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assessmentReportsDestination").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::assessmentReportsDestination)).setter(CreateAssessmentRequest.setter(Builder::assessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportsDestination").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::scope)).setter(CreateAssessmentRequest.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<List<Role>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roles").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::roles)).setter(CreateAssessmentRequest.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkId").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::frameworkId)).setter(CreateAssessmentRequest.setter(Builder::frameworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAssessmentRequest.getter(CreateAssessmentRequest::tags)).setter(CreateAssessmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ASSESSMENT_REPORTS_DESTINATION_FIELD, SCOPE_FIELD, ROLES_FIELD, FRAMEWORK_ID_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final AssessmentReportsDestination assessmentReportsDestination;
    private final Scope scope;
    private final List<Role> roles;
    private final String frameworkId;
    private final Map<String, String> tags;

    private CreateAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.assessmentReportsDestination = builder.assessmentReportsDestination;
        this.scope = builder.scope;
        this.roles = builder.roles;
        this.frameworkId = builder.frameworkId;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public AssessmentReportsDestination assessmentReportsDestination() {
        return this.assessmentReportsDestination;
    }

    public Scope scope() {
        return this.scope;
    }

    public boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public List<Role> roles() {
        return this.roles;
    }

    public String frameworkId() {
        return this.frameworkId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentRequest)) {
            return false;
        }
        CreateAssessmentRequest other = (CreateAssessmentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.assessmentReportsDestination(), other.assessmentReportsDestination()) && Objects.equals(this.scope(), other.scope()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && Objects.equals(this.frameworkId(), other.frameworkId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssessmentRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AssessmentReportsDestination", (Object)this.assessmentReportsDestination()).add("Scope", (Object)this.scope()).add("Roles", this.hasRoles() ? this.roles() : null).add("FrameworkId", (Object)this.frameworkId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "assessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportsDestination()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "frameworkId": {
                return Optional.ofNullable(clazz.cast(this.frameworkId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentRequest, T> g) {
        return obj -> g.apply((CreateAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private AssessmentReportsDestination assessmentReportsDestination;
        private Scope scope;
        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();
        private String frameworkId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.assessmentReportsDestination(model.assessmentReportsDestination);
            this.scope(model.scope);
            this.roles(model.roles);
            this.frameworkId(model.frameworkId);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AssessmentReportsDestination.Builder getAssessmentReportsDestination() {
            return this.assessmentReportsDestination != null ? this.assessmentReportsDestination.toBuilder() : null;
        }

        @Override
        public final Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        public final void setAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination != null ? assessmentReportsDestination.build() : null;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        public final Collection<Role.Builder> getRoles() {
            if (this.roles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roles != null ? (Collection)this.roles.stream().map(Role::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        public final String getFrameworkId() {
            return this.frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentRequest build() {
            return new CreateAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssessmentRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder assessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder assessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> assessmentReportsDestination) {
            return this.assessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(assessmentReportsDestination)).build());
        }

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder frameworkId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

