/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The keyword to search for in AWS CloudTrail logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceKeyword implements SdkPojo, Serializable, ToCopyableBuilder<SourceKeyword.Builder, SourceKeyword> {
    private static final SdkField<String> KEYWORD_INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keywordInputType").getter(getter(SourceKeyword::keywordInputTypeAsString))
            .setter(setter(Builder::keywordInputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywordInputType").build()).build();

    private static final SdkField<String> KEYWORD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keywordValue").getter(getter(SourceKeyword::keywordValue)).setter(setter(Builder::keywordValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywordValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYWORD_INPUT_TYPE_FIELD,
            KEYWORD_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keywordInputType;

    private final String keywordValue;

    private SourceKeyword(BuilderImpl builder) {
        this.keywordInputType = builder.keywordInputType;
        this.keywordValue = builder.keywordValue;
    }

    /**
     * <p>
     * The method of input for the specified keyword.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordInputType}
     * will return {@link KeywordInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keywordInputTypeAsString}.
     * </p>
     * 
     * @return The method of input for the specified keyword.
     * @see KeywordInputType
     */
    public final KeywordInputType keywordInputType() {
        return KeywordInputType.fromValue(keywordInputType);
    }

    /**
     * <p>
     * The method of input for the specified keyword.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keywordInputType}
     * will return {@link KeywordInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keywordInputTypeAsString}.
     * </p>
     * 
     * @return The method of input for the specified keyword.
     * @see KeywordInputType
     */
    public final String keywordInputTypeAsString() {
        return keywordInputType;
    }

    /**
     * <p>
     * The value of the keyword used to search AWS CloudTrail logs when mapping a control data source.
     * </p>
     * 
     * @return The value of the keyword used to search AWS CloudTrail logs when mapping a control data source.
     */
    public final String keywordValue() {
        return keywordValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keywordInputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keywordValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceKeyword)) {
            return false;
        }
        SourceKeyword other = (SourceKeyword) obj;
        return Objects.equals(keywordInputTypeAsString(), other.keywordInputTypeAsString())
                && Objects.equals(keywordValue(), other.keywordValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceKeyword").add("KeywordInputType", keywordInputTypeAsString())
                .add("KeywordValue", keywordValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keywordInputType":
            return Optional.ofNullable(clazz.cast(keywordInputTypeAsString()));
        case "keywordValue":
            return Optional.ofNullable(clazz.cast(keywordValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceKeyword, T> g) {
        return obj -> g.apply((SourceKeyword) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceKeyword> {
        /**
         * <p>
         * The method of input for the specified keyword.
         * </p>
         * 
         * @param keywordInputType
         *        The method of input for the specified keyword.
         * @see KeywordInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordInputType
         */
        Builder keywordInputType(String keywordInputType);

        /**
         * <p>
         * The method of input for the specified keyword.
         * </p>
         * 
         * @param keywordInputType
         *        The method of input for the specified keyword.
         * @see KeywordInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeywordInputType
         */
        Builder keywordInputType(KeywordInputType keywordInputType);

        /**
         * <p>
         * The value of the keyword used to search AWS CloudTrail logs when mapping a control data source.
         * </p>
         * 
         * @param keywordValue
         *        The value of the keyword used to search AWS CloudTrail logs when mapping a control data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywordValue(String keywordValue);
    }

    static final class BuilderImpl implements Builder {
        private String keywordInputType;

        private String keywordValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceKeyword model) {
            keywordInputType(model.keywordInputType);
            keywordValue(model.keywordValue);
        }

        public final String getKeywordInputType() {
            return keywordInputType;
        }

        @Override
        public final Builder keywordInputType(String keywordInputType) {
            this.keywordInputType = keywordInputType;
            return this;
        }

        @Override
        public final Builder keywordInputType(KeywordInputType keywordInputType) {
            this.keywordInputType(keywordInputType == null ? null : keywordInputType.toString());
            return this;
        }

        public final void setKeywordInputType(String keywordInputType) {
            this.keywordInputType = keywordInputType;
        }

        public final String getKeywordValue() {
            return keywordValue;
        }

        @Override
        public final Builder keywordValue(String keywordValue) {
            this.keywordValue = keywordValue;
            return this;
        }

        public final void setKeywordValue(String keywordValue) {
            this.keywordValue = keywordValue;
        }

        @Override
        public SourceKeyword build() {
            return new SourceKeyword(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
