/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ControlSetStatus {
    ACTIVE("ACTIVE"),
    UNDER_REVIEW("UNDER_REVIEW"),
    REVIEWED("REVIEWED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ControlSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ControlSetStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlSetStatus> knownValues() {
        return Stream.of(ControlSetStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

