/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSettingsRequest extends AuditManagerRequest implements
        ToCopyableBuilder<UpdateSettingsRequest.Builder, UpdateSettingsRequest> {
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snsTopic").getter(getter(UpdateSettingsRequest::snsTopic)).setter(setter(Builder::snsTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()).build();

    private static final SdkField<AssessmentReportsDestination> DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField
            .<AssessmentReportsDestination> builder(MarshallingType.SDK_POJO)
            .memberName("defaultAssessmentReportsDestination")
            .getter(getter(UpdateSettingsRequest::defaultAssessmentReportsDestination))
            .setter(setter(Builder::defaultAssessmentReportsDestination))
            .constructor(AssessmentReportsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("defaultAssessmentReportsDestination").build()).build();

    private static final SdkField<List<Role>> DEFAULT_PROCESS_OWNERS_FIELD = SdkField
            .<List<Role>> builder(MarshallingType.LIST)
            .memberName("defaultProcessOwners")
            .getter(getter(UpdateSettingsRequest::defaultProcessOwners))
            .setter(setter(Builder::defaultProcessOwners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultProcessOwners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Role> builder(MarshallingType.SDK_POJO)
                                            .constructor(Role::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsKey")
            .getter(getter(UpdateSettingsRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_FIELD,
            DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD, DEFAULT_PROCESS_OWNERS_FIELD, KMS_KEY_FIELD));

    private final String snsTopic;

    private final AssessmentReportsDestination defaultAssessmentReportsDestination;

    private final List<Role> defaultProcessOwners;

    private final String kmsKey;

    private UpdateSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.snsTopic = builder.snsTopic;
        this.defaultAssessmentReportsDestination = builder.defaultAssessmentReportsDestination;
        this.defaultProcessOwners = builder.defaultProcessOwners;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
     */
    public final String snsTopic() {
        return snsTopic;
    }

    /**
     * <p>
     * The default storage destination for assessment reports.
     * </p>
     * 
     * @return The default storage destination for assessment reports.
     */
    public final AssessmentReportsDestination defaultAssessmentReportsDestination() {
        return defaultAssessmentReportsDestination;
    }

    /**
     * Returns true if the DefaultProcessOwners property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDefaultProcessOwners() {
        return defaultProcessOwners != null && !(defaultProcessOwners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the default audit owners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultProcessOwners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the default audit owners.
     */
    public final List<Role> defaultProcessOwners() {
        return defaultProcessOwners;
    }

    /**
     * <p>
     * The KMS key details.
     * </p>
     * 
     * @return The KMS key details.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAssessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultProcessOwners() ? defaultProcessOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettingsRequest)) {
            return false;
        }
        UpdateSettingsRequest other = (UpdateSettingsRequest) obj;
        return Objects.equals(snsTopic(), other.snsTopic())
                && Objects.equals(defaultAssessmentReportsDestination(), other.defaultAssessmentReportsDestination())
                && hasDefaultProcessOwners() == other.hasDefaultProcessOwners()
                && Objects.equals(defaultProcessOwners(), other.defaultProcessOwners())
                && Objects.equals(kmsKey(), other.kmsKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSettingsRequest").add("SnsTopic", snsTopic())
                .add("DefaultAssessmentReportsDestination", defaultAssessmentReportsDestination())
                .add("DefaultProcessOwners", hasDefaultProcessOwners() ? defaultProcessOwners() : null).add("KmsKey", kmsKey())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snsTopic":
            return Optional.ofNullable(clazz.cast(snsTopic()));
        case "defaultAssessmentReportsDestination":
            return Optional.ofNullable(clazz.cast(defaultAssessmentReportsDestination()));
        case "defaultProcessOwners":
            return Optional.ofNullable(clazz.cast(defaultProcessOwners()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettingsRequest, T> g) {
        return obj -> g.apply((UpdateSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSettingsRequest> {
        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
         * </p>
         * 
         * @param snsTopic
         *        The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopic(String snsTopic);

        /**
         * <p>
         * The default storage destination for assessment reports.
         * </p>
         * 
         * @param defaultAssessmentReportsDestination
         *        The default storage destination for assessment reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination);

        /**
         * <p>
         * The default storage destination for assessment reports.
         * </p>
         * This is a convenience that creates an instance of the {@link AssessmentReportsDestination.Builder} avoiding
         * the need to create one manually via {@link AssessmentReportsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentReportsDestination.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultAssessmentReportsDestination(AssessmentReportsDestination)}.
         * 
         * @param defaultAssessmentReportsDestination
         *        a consumer that will call methods on {@link AssessmentReportsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAssessmentReportsDestination(AssessmentReportsDestination)
         */
        default Builder defaultAssessmentReportsDestination(
                Consumer<AssessmentReportsDestination.Builder> defaultAssessmentReportsDestination) {
            return defaultAssessmentReportsDestination(AssessmentReportsDestination.builder()
                    .applyMutation(defaultAssessmentReportsDestination).build());
        }

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * 
         * @param defaultProcessOwners
         *        A list of the default audit owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProcessOwners(Collection<Role> defaultProcessOwners);

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * 
         * @param defaultProcessOwners
         *        A list of the default audit owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultProcessOwners(Role... defaultProcessOwners);

        /**
         * <p>
         * A list of the default audit owners.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Role>.Builder} avoiding the need to create
         * one manually via {@link List<Role>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Role>.Builder#build()} is called immediately and its result
         * is passed to {@link #defaultProcessOwners(List<Role>)}.
         * 
         * @param defaultProcessOwners
         *        a consumer that will call methods on {@link List<Role>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultProcessOwners(List<Role>)
         */
        Builder defaultProcessOwners(Consumer<Role.Builder>... defaultProcessOwners);

        /**
         * <p>
         * The KMS key details.
         * </p>
         * 
         * @param kmsKey
         *        The KMS key details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String snsTopic;

        private AssessmentReportsDestination defaultAssessmentReportsDestination;

        private List<Role> defaultProcessOwners = DefaultSdkAutoConstructList.getInstance();

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettingsRequest model) {
            super(model);
            snsTopic(model.snsTopic);
            defaultAssessmentReportsDestination(model.defaultAssessmentReportsDestination);
            defaultProcessOwners(model.defaultProcessOwners);
            kmsKey(model.kmsKey);
        }

        public final String getSnsTopic() {
            return snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final AssessmentReportsDestination.Builder getDefaultAssessmentReportsDestination() {
            return defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination.toBuilder() : null;
        }

        @Override
        public final Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination;
            return this;
        }

        public final void setDefaultAssessmentReportsDestination(
                AssessmentReportsDestination.BuilderImpl defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination
                    .build() : null;
        }

        public final List<Role.Builder> getDefaultProcessOwners() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.defaultProcessOwners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder defaultProcessOwners(Collection<Role> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copy(defaultProcessOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Role... defaultProcessOwners) {
            defaultProcessOwners(Arrays.asList(defaultProcessOwners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Consumer<Role.Builder>... defaultProcessOwners) {
            defaultProcessOwners(Stream.of(defaultProcessOwners).map(c -> Role.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultProcessOwners(Collection<Role.BuilderImpl> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copyFromBuilder(defaultProcessOwners);
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            return new UpdateSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
