/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ObjectTypeEnum {
    ASSESSMENT("ASSESSMENT"),
    CONTROL_SET("CONTROL_SET"),
    CONTROL("CONTROL"),
    DELEGATION("DELEGATION"),
    ASSESSMENT_REPORT("ASSESSMENT_REPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ObjectTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ObjectTypeEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectTypeEnum> knownValues() {
        return Stream.of(ObjectTypeEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

