/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ControlMappingSource;
import software.amazon.awssdk.services.auditmanager.model.ControlMappingSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateControlRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateControlRequest> {
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlId").getter(UpdateControlRequest.getter(UpdateControlRequest::controlId)).setter(UpdateControlRequest.setter(Builder::controlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateControlRequest.getter(UpdateControlRequest::name)).setter(UpdateControlRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateControlRequest.getter(UpdateControlRequest::description)).setter(UpdateControlRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testingInformation").getter(UpdateControlRequest.getter(UpdateControlRequest::testingInformation)).setter(UpdateControlRequest.setter(Builder::testingInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build()}).build();
    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanTitle").getter(UpdateControlRequest.getter(UpdateControlRequest::actionPlanTitle)).setter(UpdateControlRequest.setter(Builder::actionPlanTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()}).build();
    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionPlanInstructions").getter(UpdateControlRequest.getter(UpdateControlRequest::actionPlanInstructions)).setter(UpdateControlRequest.setter(Builder::actionPlanInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build()}).build();
    private static final SdkField<List<ControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlMappingSources").getter(UpdateControlRequest.getter(UpdateControlRequest::controlMappingSources)).setter(UpdateControlRequest.setter(Builder::controlMappingSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlMappingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD, ACTION_PLAN_INSTRUCTIONS_FIELD, CONTROL_MAPPING_SOURCES_FIELD));
    private final String controlId;
    private final String name;
    private final String description;
    private final String testingInformation;
    private final String actionPlanTitle;
    private final String actionPlanInstructions;
    private final List<ControlMappingSource> controlMappingSources;

    private UpdateControlRequest(BuilderImpl builder) {
        super(builder);
        this.controlId = builder.controlId;
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlMappingSources = builder.controlMappingSources;
    }

    public final String controlId() {
        return this.controlId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String testingInformation() {
        return this.testingInformation;
    }

    public final String actionPlanTitle() {
        return this.actionPlanTitle;
    }

    public final String actionPlanInstructions() {
        return this.actionPlanInstructions;
    }

    public final boolean hasControlMappingSources() {
        return this.controlMappingSources != null && !(this.controlMappingSources instanceof SdkAutoConstructList);
    }

    public final List<ControlMappingSource> controlMappingSources() {
        return this.controlMappingSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.controlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlMappingSources() ? this.controlMappingSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateControlRequest)) {
            return false;
        }
        UpdateControlRequest other = (UpdateControlRequest)((Object)obj);
        return Objects.equals(this.controlId(), other.controlId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.testingInformation(), other.testingInformation()) && Objects.equals(this.actionPlanTitle(), other.actionPlanTitle()) && Objects.equals(this.actionPlanInstructions(), other.actionPlanInstructions()) && this.hasControlMappingSources() == other.hasControlMappingSources() && Objects.equals(this.controlMappingSources(), other.controlMappingSources());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateControlRequest").add("ControlId", (Object)this.controlId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TestingInformation", (Object)this.testingInformation()).add("ActionPlanTitle", (Object)this.actionPlanTitle()).add("ActionPlanInstructions", (Object)this.actionPlanInstructions()).add("ControlMappingSources", this.hasControlMappingSources() ? this.controlMappingSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlId": {
                return Optional.ofNullable(clazz.cast(this.controlId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "testingInformation": {
                return Optional.ofNullable(clazz.cast(this.testingInformation()));
            }
            case "actionPlanTitle": {
                return Optional.ofNullable(clazz.cast(this.actionPlanTitle()));
            }
            case "actionPlanInstructions": {
                return Optional.ofNullable(clazz.cast(this.actionPlanInstructions()));
            }
            case "controlMappingSources": {
                return Optional.ofNullable(clazz.cast(this.controlMappingSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateControlRequest, T> g) {
        return obj -> g.apply((UpdateControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String controlId;
        private String name;
        private String description;
        private String testingInformation;
        private String actionPlanTitle;
        private String actionPlanInstructions;
        private List<ControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateControlRequest model) {
            super(model);
            this.controlId(model.controlId);
            this.name(model.name);
            this.description(model.description);
            this.testingInformation(model.testingInformation);
            this.actionPlanTitle(model.actionPlanTitle);
            this.actionPlanInstructions(model.actionPlanInstructions);
            this.controlMappingSources(model.controlMappingSources);
        }

        public final String getControlId() {
            return this.controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTestingInformation() {
            return this.testingInformation;
        }

        @Override
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        public final String getActionPlanTitle() {
            return this.actionPlanTitle;
        }

        @Override
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        public final String getActionPlanInstructions() {
            return this.actionPlanInstructions;
        }

        @Override
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        public final Collection<ControlMappingSource.Builder> getControlMappingSources() {
            if (this.controlMappingSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlMappingSources != null ? (Collection)this.controlMappingSources.stream().map(ControlMappingSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder controlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(ControlMappingSource ... controlMappingSources) {
            this.controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<ControlMappingSource.Builder> ... controlMappingSources) {
            this.controlMappingSources(Stream.of(controlMappingSources).map(c -> (ControlMappingSource)((ControlMappingSource.Builder)ControlMappingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControlMappingSources(Collection<ControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = ControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateControlRequest build() {
            return new UpdateControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateControlRequest> {
        public Builder controlId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder testingInformation(String var1);

        public Builder actionPlanTitle(String var1);

        public Builder actionPlanInstructions(String var1);

        public Builder controlMappingSources(Collection<ControlMappingSource> var1);

        public Builder controlMappingSources(ControlMappingSource ... var1);

        public Builder controlMappingSources(Consumer<ControlMappingSource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

