/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListAssessmentsResponse> {
    private static final SdkField<List<AssessmentMetadataItem>> ASSESSMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentMetadata").getter(ListAssessmentsResponse.getter(ListAssessmentsResponse::assessmentMetadata)).setter(ListAssessmentsResponse.setter(Builder::assessmentMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentMetadataItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentsResponse.getter(ListAssessmentsResponse::nextToken)).setter(ListAssessmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssessmentMetadataItem> assessmentMetadata;
    private final String nextToken;

    private ListAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentMetadata = builder.assessmentMetadata;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentMetadata() {
        return this.assessmentMetadata != null && !(this.assessmentMetadata instanceof SdkAutoConstructList);
    }

    public final List<AssessmentMetadataItem> assessmentMetadata() {
        return this.assessmentMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentMetadata() ? this.assessmentMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentsResponse)) {
            return false;
        }
        ListAssessmentsResponse other = (ListAssessmentsResponse)((Object)obj);
        return this.hasAssessmentMetadata() == other.hasAssessmentMetadata() && Objects.equals(this.assessmentMetadata(), other.assessmentMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentsResponse").add("AssessmentMetadata", this.hasAssessmentMetadata() ? this.assessmentMetadata() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentMetadata": {
                return Optional.ofNullable(clazz.cast(this.assessmentMetadata()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentsResponse, T> g) {
        return obj -> g.apply((ListAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<AssessmentMetadataItem> assessmentMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentsResponse model) {
            super(model);
            this.assessmentMetadata(model.assessmentMetadata);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssessmentMetadataItem.Builder> getAssessmentMetadata() {
            if (this.assessmentMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentMetadata != null ? (Collection)this.assessmentMetadata.stream().map(AssessmentMetadataItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assessmentMetadata(Collection<AssessmentMetadataItem> assessmentMetadata) {
            this.assessmentMetadata = ListAssessmentMetadataCopier.copy(assessmentMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentMetadata(AssessmentMetadataItem ... assessmentMetadata) {
            this.assessmentMetadata(Arrays.asList(assessmentMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentMetadata(Consumer<AssessmentMetadataItem.Builder> ... assessmentMetadata) {
            this.assessmentMetadata(Stream.of(assessmentMetadata).map(c -> (AssessmentMetadataItem)((AssessmentMetadataItem.Builder)AssessmentMetadataItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentMetadata(Collection<AssessmentMetadataItem.BuilderImpl> assessmentMetadata) {
            this.assessmentMetadata = ListAssessmentMetadataCopier.copyFromBuilder(assessmentMetadata);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssessmentsResponse build() {
            return new ListAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentsResponse> {
        public Builder assessmentMetadata(Collection<AssessmentMetadataItem> var1);

        public Builder assessmentMetadata(AssessmentMetadataItem ... var1);

        public Builder assessmentMetadata(Consumer<AssessmentMetadataItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

