/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActionEnum {
    CREATE("CREATE"),
    UPDATE_METADATA("UPDATE_METADATA"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    DELETE("DELETE"),
    UNDER_REVIEW("UNDER_REVIEW"),
    REVIEWED("REVIEWED"),
    IMPORT_EVIDENCE("IMPORT_EVIDENCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActionEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActionEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionEnum> knownValues() {
        return Stream.of(ActionEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

