/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder;
import software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFoldersCopier;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEvidenceFoldersByAssessmentControlResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetEvidenceFoldersByAssessmentControlResponse> {
    private static final SdkField<List<AssessmentEvidenceFolder>> EVIDENCE_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidenceFolders").getter(GetEvidenceFoldersByAssessmentControlResponse.getter(GetEvidenceFoldersByAssessmentControlResponse::evidenceFolders)).setter(GetEvidenceFoldersByAssessmentControlResponse.setter(Builder::evidenceFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentEvidenceFolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetEvidenceFoldersByAssessmentControlResponse.getter(GetEvidenceFoldersByAssessmentControlResponse::nextToken)).setter(GetEvidenceFoldersByAssessmentControlResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_FOLDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssessmentEvidenceFolder> evidenceFolders;
    private final String nextToken;

    private GetEvidenceFoldersByAssessmentControlResponse(BuilderImpl builder) {
        super(builder);
        this.evidenceFolders = builder.evidenceFolders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvidenceFolders() {
        return this.evidenceFolders != null && !(this.evidenceFolders instanceof SdkAutoConstructList);
    }

    public final List<AssessmentEvidenceFolder> evidenceFolders() {
        return this.evidenceFolders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidenceFolders() ? this.evidenceFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceFoldersByAssessmentControlResponse)) {
            return false;
        }
        GetEvidenceFoldersByAssessmentControlResponse other = (GetEvidenceFoldersByAssessmentControlResponse)((Object)obj);
        return this.hasEvidenceFolders() == other.hasEvidenceFolders() && Objects.equals(this.evidenceFolders(), other.evidenceFolders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetEvidenceFoldersByAssessmentControlResponse").add("EvidenceFolders", this.hasEvidenceFolders() ? this.evidenceFolders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evidenceFolders": {
                return Optional.ofNullable(clazz.cast(this.evidenceFolders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceFoldersByAssessmentControlResponse, T> g) {
        return obj -> g.apply((GetEvidenceFoldersByAssessmentControlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<AssessmentEvidenceFolder> evidenceFolders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceFoldersByAssessmentControlResponse model) {
            super(model);
            this.evidenceFolders(model.evidenceFolders);
            this.nextToken(model.nextToken);
        }

        public final List<AssessmentEvidenceFolder.Builder> getEvidenceFolders() {
            List<AssessmentEvidenceFolder.Builder> result = AssessmentEvidenceFoldersCopier.copyToBuilder(this.evidenceFolders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder evidenceFolders(Collection<AssessmentEvidenceFolder> evidenceFolders) {
            this.evidenceFolders = AssessmentEvidenceFoldersCopier.copy(evidenceFolders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceFolders(AssessmentEvidenceFolder ... evidenceFolders) {
            this.evidenceFolders(Arrays.asList(evidenceFolders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceFolders(Consumer<AssessmentEvidenceFolder.Builder> ... evidenceFolders) {
            this.evidenceFolders(Stream.of(evidenceFolders).map(c -> (AssessmentEvidenceFolder)((AssessmentEvidenceFolder.Builder)AssessmentEvidenceFolder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvidenceFolders(Collection<AssessmentEvidenceFolder.BuilderImpl> evidenceFolders) {
            this.evidenceFolders = AssessmentEvidenceFoldersCopier.copyFromBuilder(evidenceFolders);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetEvidenceFoldersByAssessmentControlResponse build() {
            return new GetEvidenceFoldersByAssessmentControlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEvidenceFoldersByAssessmentControlResponse> {
        public Builder evidenceFolders(Collection<AssessmentEvidenceFolder> var1);

        public Builder evidenceFolders(AssessmentEvidenceFolder ... var1);

        public Builder evidenceFolders(Consumer<AssessmentEvidenceFolder.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

