/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateAssessmentReportEvidenceResponse extends AuditManagerResponse implements
        ToCopyableBuilder<BatchAssociateAssessmentReportEvidenceResponse.Builder, BatchAssociateAssessmentReportEvidenceResponse> {
    private static final SdkField<List<String>> EVIDENCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("evidenceIds")
            .getter(getter(BatchAssociateAssessmentReportEvidenceResponse::evidenceIds))
            .setter(setter(Builder::evidenceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssessmentReportEvidenceError>> ERRORS_FIELD = SdkField
            .<List<AssessmentReportEvidenceError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchAssociateAssessmentReportEvidenceResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentReportEvidenceError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentReportEvidenceError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_IDS_FIELD,
            ERRORS_FIELD));

    private final List<String> evidenceIds;

    private final List<AssessmentReportEvidenceError> errors;

    private BatchAssociateAssessmentReportEvidenceResponse(BuilderImpl builder) {
        super(builder);
        this.evidenceIds = builder.evidenceIds;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the EvidenceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEvidenceIds() {
        return evidenceIds != null && !(evidenceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier for the evidence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvidenceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifier for the evidence.
     */
    public final List<String> evidenceIds() {
        return evidenceIds;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
     */
    public final List<AssessmentReportEvidenceError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidenceIds() ? evidenceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAssessmentReportEvidenceResponse)) {
            return false;
        }
        BatchAssociateAssessmentReportEvidenceResponse other = (BatchAssociateAssessmentReportEvidenceResponse) obj;
        return hasEvidenceIds() == other.hasEvidenceIds() && Objects.equals(evidenceIds(), other.evidenceIds())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateAssessmentReportEvidenceResponse")
                .add("EvidenceIds", hasEvidenceIds() ? evidenceIds() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evidenceIds":
            return Optional.ofNullable(clazz.cast(evidenceIds()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAssessmentReportEvidenceResponse, T> g) {
        return obj -> g.apply((BatchAssociateAssessmentReportEvidenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateAssessmentReportEvidenceResponse> {
        /**
         * <p>
         * The identifier for the evidence.
         * </p>
         * 
         * @param evidenceIds
         *        The identifier for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceIds(Collection<String> evidenceIds);

        /**
         * <p>
         * The identifier for the evidence.
         * </p>
         * 
         * @param evidenceIds
         *        The identifier for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceIds(String... evidenceIds);

        /**
         * <p>
         * A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
         * </p>
         * 
         * @param errors
         *        A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AssessmentReportEvidenceError> errors);

        /**
         * <p>
         * A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
         * </p>
         * 
         * @param errors
         *        A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AssessmentReportEvidenceError... errors);

        /**
         * <p>
         * A list of errors returned by the <code>BatchAssociateAssessmentReportEvidence</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentReportEvidenceError>.Builder}
         * avoiding the need to create one manually via {@link List<AssessmentReportEvidenceError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentReportEvidenceError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<AssessmentReportEvidenceError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<AssessmentReportEvidenceError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<AssessmentReportEvidenceError>)
         */
        Builder errors(Consumer<AssessmentReportEvidenceError.Builder>... errors);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<String> evidenceIds = DefaultSdkAutoConstructList.getInstance();

        private List<AssessmentReportEvidenceError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAssessmentReportEvidenceResponse model) {
            super(model);
            evidenceIds(model.evidenceIds);
            errors(model.errors);
        }

        public final Collection<String> getEvidenceIds() {
            if (evidenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return evidenceIds;
        }

        @Override
        public final Builder evidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceIds(String... evidenceIds) {
            evidenceIds(Arrays.asList(evidenceIds));
            return this;
        }

        public final void setEvidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
        }

        public final List<AssessmentReportEvidenceError.Builder> getErrors() {
            List<AssessmentReportEvidenceError.Builder> result = AssessmentReportEvidenceErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<AssessmentReportEvidenceError> errors) {
            this.errors = AssessmentReportEvidenceErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssessmentReportEvidenceError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssessmentReportEvidenceError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AssessmentReportEvidenceError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<AssessmentReportEvidenceError.BuilderImpl> errors) {
            this.errors = AssessmentReportEvidenceErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchAssociateAssessmentReportEvidenceResponse build() {
            return new BatchAssociateAssessmentReportEvidenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
