/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentFrameworksResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ListAssessmentFrameworksResponse.Builder, ListAssessmentFrameworksResponse> {
    private static final SdkField<List<AssessmentFrameworkMetadata>> FRAMEWORK_METADATA_LIST_FIELD = SdkField
            .<List<AssessmentFrameworkMetadata>> builder(MarshallingType.LIST)
            .memberName("frameworkMetadataList")
            .getter(getter(ListAssessmentFrameworksResponse::frameworkMetadataList))
            .setter(setter(Builder::frameworkMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkMetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentFrameworkMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentFrameworkMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentFrameworksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_METADATA_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssessmentFrameworkMetadata> frameworkMetadataList;

    private final String nextToken;

    private ListAssessmentFrameworksResponse(BuilderImpl builder) {
        super(builder);
        this.frameworkMetadataList = builder.frameworkMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FrameworkMetadataList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFrameworkMetadataList() {
        return frameworkMetadataList != null && !(frameworkMetadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of metadata objects for the specified framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFrameworkMetadataList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of metadata objects for the specified framework.
     */
    public final List<AssessmentFrameworkMetadata> frameworkMetadataList() {
        return frameworkMetadataList;
    }

    /**
     * <p>
     * The pagination token used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworkMetadataList() ? frameworkMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentFrameworksResponse)) {
            return false;
        }
        ListAssessmentFrameworksResponse other = (ListAssessmentFrameworksResponse) obj;
        return hasFrameworkMetadataList() == other.hasFrameworkMetadataList()
                && Objects.equals(frameworkMetadataList(), other.frameworkMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentFrameworksResponse")
                .add("FrameworkMetadataList", hasFrameworkMetadataList() ? frameworkMetadataList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frameworkMetadataList":
            return Optional.ofNullable(clazz.cast(frameworkMetadataList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentFrameworksResponse, T> g) {
        return obj -> g.apply((ListAssessmentFrameworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssessmentFrameworksResponse> {
        /**
         * <p>
         * The list of metadata objects for the specified framework.
         * </p>
         * 
         * @param frameworkMetadataList
         *        The list of metadata objects for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkMetadataList(Collection<AssessmentFrameworkMetadata> frameworkMetadataList);

        /**
         * <p>
         * The list of metadata objects for the specified framework.
         * </p>
         * 
         * @param frameworkMetadataList
         *        The list of metadata objects for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkMetadataList(AssessmentFrameworkMetadata... frameworkMetadataList);

        /**
         * <p>
         * The list of metadata objects for the specified framework.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentFrameworkMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<AssessmentFrameworkMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentFrameworkMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #frameworkMetadataList(List<AssessmentFrameworkMetadata>)}.
         * 
         * @param frameworkMetadataList
         *        a consumer that will call methods on {@link List<AssessmentFrameworkMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkMetadataList(List<AssessmentFrameworkMetadata>)
         */
        Builder frameworkMetadataList(Consumer<AssessmentFrameworkMetadata.Builder>... frameworkMetadataList);

        /**
         * <p>
         * The pagination token used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<AssessmentFrameworkMetadata> frameworkMetadataList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentFrameworksResponse model) {
            super(model);
            frameworkMetadataList(model.frameworkMetadataList);
            nextToken(model.nextToken);
        }

        public final List<AssessmentFrameworkMetadata.Builder> getFrameworkMetadataList() {
            List<AssessmentFrameworkMetadata.Builder> result = FrameworkMetadataListCopier
                    .copyToBuilder(this.frameworkMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder frameworkMetadataList(Collection<AssessmentFrameworkMetadata> frameworkMetadataList) {
            this.frameworkMetadataList = FrameworkMetadataListCopier.copy(frameworkMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkMetadataList(AssessmentFrameworkMetadata... frameworkMetadataList) {
            frameworkMetadataList(Arrays.asList(frameworkMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkMetadataList(Consumer<AssessmentFrameworkMetadata.Builder>... frameworkMetadataList) {
            frameworkMetadataList(Stream.of(frameworkMetadataList)
                    .map(c -> AssessmentFrameworkMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFrameworkMetadataList(Collection<AssessmentFrameworkMetadata.BuilderImpl> frameworkMetadataList) {
            this.frameworkMetadataList = FrameworkMetadataListCopier.copyFromBuilder(frameworkMetadataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssessmentFrameworksResponse build() {
            return new ListAssessmentFrameworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
