/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file used to structure and automate AWS Audit Manager assessments for a given compliance standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Framework implements SdkPojo, Serializable, ToCopyableBuilder<Framework.Builder, Framework> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Framework::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Framework::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Framework::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Framework::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(Framework::complianceType)).setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Framework::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> LOGO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logo")
            .getter(getter(Framework::logo)).setter(setter(Builder::logo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()).build();

    private static final SdkField<String> CONTROL_SOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSources").getter(getter(Framework::controlSources)).setter(setter(Builder::controlSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSources").build()).build();

    private static final SdkField<List<ControlSet>> CONTROL_SETS_FIELD = SdkField
            .<List<ControlSet>> builder(MarshallingType.LIST)
            .memberName("controlSets")
            .getter(getter(Framework::controlSets))
            .setter(setter(Builder::controlSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Framework::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(Framework::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(Framework::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(Framework::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Framework::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, TYPE_FIELD, COMPLIANCE_TYPE_FIELD, DESCRIPTION_FIELD, LOGO_FIELD, CONTROL_SOURCES_FIELD,
            CONTROL_SETS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CREATED_BY_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String type;

    private final String complianceType;

    private final String description;

    private final String logo;

    private final String controlSources;

    private final List<ControlSet> controlSets;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String createdBy;

    private final String lastUpdatedBy;

    private final Map<String, String> tags;

    private Framework(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.complianceType = builder.complianceType;
        this.description = builder.description;
        this.logo = builder.logo;
        this.controlSources = builder.controlSources;
        this.controlSets = builder.controlSets;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdBy = builder.createdBy;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified framework.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified framework.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the specified framework.
     * </p>
     * 
     * @return The unique identifier for the specified framework.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the specified framework.
     * </p>
     * 
     * @return The name of the specified framework.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The framework type, such as custom or standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as custom or standard.
     * @see FrameworkType
     */
    public final FrameworkType type() {
        return FrameworkType.fromValue(type);
    }

    /**
     * <p>
     * The framework type, such as custom or standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FrameworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The framework type, such as custom or standard.
     * @see FrameworkType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    /**
     * <p>
     * The description of the specified framework.
     * </p>
     * 
     * @return The description of the specified framework.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The logo associated with the framework.
     * </p>
     * 
     * @return The logo associated with the framework.
     */
    public final String logo() {
        return logo;
    }

    /**
     * <p>
     * The sources from which AWS Audit Manager collects evidence for the control.
     * </p>
     * 
     * @return The sources from which AWS Audit Manager collects evidence for the control.
     */
    public final String controlSources() {
        return controlSources;
    }

    /**
     * Returns true if the ControlSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasControlSets() {
        return controlSets != null && !(controlSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control sets associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControlSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The control sets associated with the framework.
     */
    public final List<ControlSet> controlSets() {
        return controlSets;
    }

    /**
     * <p>
     * Specifies when the framework was created.
     * </p>
     * 
     * @return Specifies when the framework was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies when the framework was most recently updated.
     * </p>
     * 
     * @return Specifies when the framework was most recently updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The IAM user or role that created the framework.
     * </p>
     * 
     * @return The IAM user or role that created the framework.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The IAM user or role that most recently updated the framework.
     * </p>
     * 
     * @return The IAM user or role that most recently updated the framework.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the framework.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        hashCode = 31 * hashCode + Objects.hashCode(controlSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlSets() ? controlSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Framework)) {
            return false;
        }
        Framework other = (Framework) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(complianceType(), other.complianceType()) && Objects.equals(description(), other.description())
                && Objects.equals(logo(), other.logo()) && Objects.equals(controlSources(), other.controlSources())
                && hasControlSets() == other.hasControlSets() && Objects.equals(controlSets(), other.controlSets())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Framework").add("Arn", arn()).add("Id", id()).add("Name", name()).add("Type", typeAsString())
                .add("ComplianceType", complianceType()).add("Description", description()).add("Logo", logo())
                .add("ControlSources", controlSources()).add("ControlSets", hasControlSets() ? controlSets() : null)
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("CreatedBy", createdBy())
                .add("LastUpdatedBy", lastUpdatedBy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "logo":
            return Optional.ofNullable(clazz.cast(logo()));
        case "controlSources":
            return Optional.ofNullable(clazz.cast(controlSources()));
        case "controlSets":
            return Optional.ofNullable(clazz.cast(controlSets()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Framework, T> g) {
        return obj -> g.apply((Framework) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Framework> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified framework.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the specified framework.
         * </p>
         * 
         * @param id
         *        The unique identifier for the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the specified framework.
         * </p>
         * 
         * @param name
         *        The name of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The framework type, such as custom or standard.
         * </p>
         * 
         * @param type
         *        The framework type, such as custom or standard.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(String type);

        /**
         * <p>
         * The framework type, such as custom or standard.
         * </p>
         * 
         * @param type
         *        The framework type, such as custom or standard.
         * @see FrameworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FrameworkType
         */
        Builder type(FrameworkType type);

        /**
         * <p>
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the new custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The description of the specified framework.
         * </p>
         * 
         * @param description
         *        The description of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The logo associated with the framework.
         * </p>
         * 
         * @param logo
         *        The logo associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(String logo);

        /**
         * <p>
         * The sources from which AWS Audit Manager collects evidence for the control.
         * </p>
         * 
         * @param controlSources
         *        The sources from which AWS Audit Manager collects evidence for the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSources(String controlSources);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(Collection<ControlSet> controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(ControlSet... controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ControlSet>.Builder} avoiding the need to
         * create one manually via {@link List<ControlSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ControlSet>.Builder#build()} is called immediately and its
         * result is passed to {@link #controlSets(List<ControlSet>)}.
         * 
         * @param controlSets
         *        a consumer that will call methods on {@link List<ControlSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlSets(List<ControlSet>)
         */
        Builder controlSets(Consumer<ControlSet.Builder>... controlSets);

        /**
         * <p>
         * Specifies when the framework was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies when the framework was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies when the framework was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies when the framework was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The IAM user or role that created the framework.
         * </p>
         * 
         * @param createdBy
         *        The IAM user or role that created the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The IAM user or role that most recently updated the framework.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The IAM user or role that most recently updated the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The tags associated with the framework.
         * </p>
         * 
         * @param tags
         *        The tags associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String type;

        private String complianceType;

        private String description;

        private String logo;

        private String controlSources;

        private List<ControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String createdBy;

        private String lastUpdatedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Framework model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            type(model.type);
            complianceType(model.complianceType);
            description(model.description);
            logo(model.logo);
            controlSources(model.controlSources);
            controlSets(model.controlSets);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            createdBy(model.createdBy);
            lastUpdatedBy(model.lastUpdatedBy);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FrameworkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogo() {
            return logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        public final String getControlSources() {
            return controlSources;
        }

        @Override
        public final Builder controlSources(String controlSources) {
            this.controlSources = controlSources;
            return this;
        }

        public final void setControlSources(String controlSources) {
            this.controlSources = controlSources;
        }

        public final List<ControlSet.Builder> getControlSets() {
            List<ControlSet.Builder> result = ControlSetsCopier.copyToBuilder(this.controlSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder controlSets(Collection<ControlSet> controlSets) {
            this.controlSets = ControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(ControlSet... controlSets) {
            controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(Consumer<ControlSet.Builder>... controlSets) {
            controlSets(Stream.of(controlSets).map(c -> ControlSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setControlSets(Collection<ControlSet.BuilderImpl> controlSets) {
            this.controlSets = ControlSetsCopier.copyFromBuilder(controlSets);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Framework build() {
            return new Framework(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
