/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateControlRequest extends AuditManagerRequest implements
        ToCopyableBuilder<CreateControlRequest.Builder, CreateControlRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateControlRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateControlRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TESTING_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testingInformation").getter(getter(CreateControlRequest::testingInformation))
            .setter(setter(Builder::testingInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testingInformation").build())
            .build();

    private static final SdkField<String> ACTION_PLAN_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanTitle").getter(getter(CreateControlRequest::actionPlanTitle))
            .setter(setter(Builder::actionPlanTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanTitle").build()).build();

    private static final SdkField<String> ACTION_PLAN_INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionPlanInstructions").getter(getter(CreateControlRequest::actionPlanInstructions))
            .setter(setter(Builder::actionPlanInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPlanInstructions").build())
            .build();

    private static final SdkField<List<CreateControlMappingSource>> CONTROL_MAPPING_SOURCES_FIELD = SdkField
            .<List<CreateControlMappingSource>> builder(MarshallingType.LIST)
            .memberName("controlMappingSources")
            .getter(getter(CreateControlRequest::controlMappingSources))
            .setter(setter(Builder::controlMappingSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlMappingSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateControlMappingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateControlMappingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateControlRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TESTING_INFORMATION_FIELD, ACTION_PLAN_TITLE_FIELD, ACTION_PLAN_INSTRUCTIONS_FIELD, CONTROL_MAPPING_SOURCES_FIELD,
            TAGS_FIELD));

    private final String name;

    private final String description;

    private final String testingInformation;

    private final String actionPlanTitle;

    private final String actionPlanInstructions;

    private final List<CreateControlMappingSource> controlMappingSources;

    private final Map<String, String> tags;

    private CreateControlRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.testingInformation = builder.testingInformation;
        this.actionPlanTitle = builder.actionPlanTitle;
        this.actionPlanInstructions = builder.actionPlanInstructions;
        this.controlMappingSources = builder.controlMappingSources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the control.
     * </p>
     * 
     * @return The name of the control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the control.
     * </p>
     * 
     * @return The description of the control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The steps to follow to determine if the control has been satisfied.
     * </p>
     * 
     * @return The steps to follow to determine if the control has been satisfied.
     */
    public final String testingInformation() {
        return testingInformation;
    }

    /**
     * <p>
     * The title of the action plan for remediating the control.
     * </p>
     * 
     * @return The title of the action plan for remediating the control.
     */
    public final String actionPlanTitle() {
        return actionPlanTitle;
    }

    /**
     * <p>
     * The recommended actions to carry out if the control is not fulfilled.
     * </p>
     * 
     * @return The recommended actions to carry out if the control is not fulfilled.
     */
    public final String actionPlanInstructions() {
        return actionPlanInstructions;
    }

    /**
     * Returns true if the ControlMappingSources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasControlMappingSources() {
        return controlMappingSources != null && !(controlMappingSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data mapping sources for the specified control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControlMappingSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The data mapping sources for the specified control.
     */
    public final List<CreateControlMappingSource> controlMappingSources() {
        return controlMappingSources;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the control.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the control.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(testingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanTitle());
        hashCode = 31 * hashCode + Objects.hashCode(actionPlanInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlMappingSources() ? controlMappingSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlRequest)) {
            return false;
        }
        CreateControlRequest other = (CreateControlRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(testingInformation(), other.testingInformation())
                && Objects.equals(actionPlanTitle(), other.actionPlanTitle())
                && Objects.equals(actionPlanInstructions(), other.actionPlanInstructions())
                && hasControlMappingSources() == other.hasControlMappingSources()
                && Objects.equals(controlMappingSources(), other.controlMappingSources()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateControlRequest").add("Name", name()).add("Description", description())
                .add("TestingInformation", testingInformation()).add("ActionPlanTitle", actionPlanTitle())
                .add("ActionPlanInstructions", actionPlanInstructions())
                .add("ControlMappingSources", hasControlMappingSources() ? controlMappingSources() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "testingInformation":
            return Optional.ofNullable(clazz.cast(testingInformation()));
        case "actionPlanTitle":
            return Optional.ofNullable(clazz.cast(actionPlanTitle()));
        case "actionPlanInstructions":
            return Optional.ofNullable(clazz.cast(actionPlanInstructions()));
        case "controlMappingSources":
            return Optional.ofNullable(clazz.cast(controlMappingSources()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlRequest, T> g) {
        return obj -> g.apply((CreateControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateControlRequest> {
        /**
         * <p>
         * The name of the control.
         * </p>
         * 
         * @param name
         *        The name of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the control.
         * </p>
         * 
         * @param description
         *        The description of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The steps to follow to determine if the control has been satisfied.
         * </p>
         * 
         * @param testingInformation
         *        The steps to follow to determine if the control has been satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingInformation(String testingInformation);

        /**
         * <p>
         * The title of the action plan for remediating the control.
         * </p>
         * 
         * @param actionPlanTitle
         *        The title of the action plan for remediating the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanTitle(String actionPlanTitle);

        /**
         * <p>
         * The recommended actions to carry out if the control is not fulfilled.
         * </p>
         * 
         * @param actionPlanInstructions
         *        The recommended actions to carry out if the control is not fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPlanInstructions(String actionPlanInstructions);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(Collection<CreateControlMappingSource> controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * 
         * @param controlMappingSources
         *        The data mapping sources for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlMappingSources(CreateControlMappingSource... controlMappingSources);

        /**
         * <p>
         * The data mapping sources for the specified control.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateControlMappingSource>.Builder}
         * avoiding the need to create one manually via {@link List<CreateControlMappingSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateControlMappingSource>.Builder#build()} is called
         * immediately and its result is passed to {@link #controlMappingSources(List<CreateControlMappingSource>)}.
         * 
         * @param controlMappingSources
         *        a consumer that will call methods on {@link List<CreateControlMappingSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlMappingSources(List<CreateControlMappingSource>)
         */
        Builder controlMappingSources(Consumer<CreateControlMappingSource.Builder>... controlMappingSources);

        /**
         * <p>
         * The tags associated with the control.
         * </p>
         * 
         * @param tags
         *        The tags associated with the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String testingInformation;

        private String actionPlanTitle;

        private String actionPlanInstructions;

        private List<CreateControlMappingSource> controlMappingSources = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            testingInformation(model.testingInformation);
            actionPlanTitle(model.actionPlanTitle);
            actionPlanInstructions(model.actionPlanInstructions);
            controlMappingSources(model.controlMappingSources);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTestingInformation() {
            return testingInformation;
        }

        @Override
        public final Builder testingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
            return this;
        }

        public final void setTestingInformation(String testingInformation) {
            this.testingInformation = testingInformation;
        }

        public final String getActionPlanTitle() {
            return actionPlanTitle;
        }

        @Override
        public final Builder actionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
            return this;
        }

        public final void setActionPlanTitle(String actionPlanTitle) {
            this.actionPlanTitle = actionPlanTitle;
        }

        public final String getActionPlanInstructions() {
            return actionPlanInstructions;
        }

        @Override
        public final Builder actionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
            return this;
        }

        public final void setActionPlanInstructions(String actionPlanInstructions) {
            this.actionPlanInstructions = actionPlanInstructions;
        }

        public final List<CreateControlMappingSource.Builder> getControlMappingSources() {
            List<CreateControlMappingSource.Builder> result = CreateControlMappingSourcesCopier
                    .copyToBuilder(this.controlMappingSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder controlMappingSources(Collection<CreateControlMappingSource> controlMappingSources) {
            this.controlMappingSources = CreateControlMappingSourcesCopier.copy(controlMappingSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(CreateControlMappingSource... controlMappingSources) {
            controlMappingSources(Arrays.asList(controlMappingSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlMappingSources(Consumer<CreateControlMappingSource.Builder>... controlMappingSources) {
            controlMappingSources(Stream.of(controlMappingSources)
                    .map(c -> CreateControlMappingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControlMappingSources(Collection<CreateControlMappingSource.BuilderImpl> controlMappingSources) {
            this.controlMappingSources = CreateControlMappingSourcesCopier.copyFromBuilder(controlMappingSources);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateControlRequest build() {
            return new CreateControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
