/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvidenceByEvidenceFolderResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetEvidenceByEvidenceFolderResponse.Builder, GetEvidenceByEvidenceFolderResponse> {
    private static final SdkField<List<Evidence>> EVIDENCE_FIELD = SdkField
            .<List<Evidence>> builder(MarshallingType.LIST)
            .memberName("evidence")
            .getter(getter(GetEvidenceByEvidenceFolderResponse::evidence))
            .setter(setter(Builder::evidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidence").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Evidence> builder(MarshallingType.SDK_POJO)
                                            .constructor(Evidence::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEvidenceByEvidenceFolderResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVIDENCE_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Evidence> evidence;

    private final String nextToken;

    private GetEvidenceByEvidenceFolderResponse(BuilderImpl builder) {
        super(builder);
        this.evidence = builder.evidence;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Evidence property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEvidence() {
        return evidence != null && !(evidence instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvidence()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
     */
    public final List<Evidence> evidence() {
        return evidence;
    }

    /**
     * <p>
     * The pagination token used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvidence() ? evidence() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceByEvidenceFolderResponse)) {
            return false;
        }
        GetEvidenceByEvidenceFolderResponse other = (GetEvidenceByEvidenceFolderResponse) obj;
        return hasEvidence() == other.hasEvidence() && Objects.equals(evidence(), other.evidence())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvidenceByEvidenceFolderResponse").add("Evidence", hasEvidence() ? evidence() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evidence":
            return Optional.ofNullable(clazz.cast(evidence()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceByEvidenceFolderResponse, T> g) {
        return obj -> g.apply((GetEvidenceByEvidenceFolderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEvidenceByEvidenceFolderResponse> {
        /**
         * <p>
         * The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
         * </p>
         * 
         * @param evidence
         *        The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidence(Collection<Evidence> evidence);

        /**
         * <p>
         * The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
         * </p>
         * 
         * @param evidence
         *        The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidence(Evidence... evidence);

        /**
         * <p>
         * The list of evidence returned by the <code>GetEvidenceByEvidenceFolder</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Evidence>.Builder} avoiding the need to
         * create one manually via {@link List<Evidence>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Evidence>.Builder#build()} is called immediately and its
         * result is passed to {@link #evidence(List<Evidence>)}.
         * 
         * @param evidence
         *        a consumer that will call methods on {@link List<Evidence>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evidence(List<Evidence>)
         */
        Builder evidence(Consumer<Evidence.Builder>... evidence);

        /**
         * <p>
         * The pagination token used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<Evidence> evidence = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceByEvidenceFolderResponse model) {
            super(model);
            evidence(model.evidence);
            nextToken(model.nextToken);
        }

        public final List<Evidence.Builder> getEvidence() {
            List<Evidence.Builder> result = EvidenceListCopier.copyToBuilder(this.evidence);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder evidence(Collection<Evidence> evidence) {
            this.evidence = EvidenceListCopier.copy(evidence);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidence(Evidence... evidence) {
            evidence(Arrays.asList(evidence));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidence(Consumer<Evidence.Builder>... evidence) {
            evidence(Stream.of(evidence).map(c -> Evidence.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvidence(Collection<Evidence.BuilderImpl> evidence) {
            this.evidence = EvidenceListCopier.copyFromBuilder(evidence);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetEvidenceByEvidenceFolderResponse build() {
            return new GetEvidenceByEvidenceFolderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
